/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.AxisRecomputationEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.locks.DefaultDataSetLock;
import de.gsi.dataset.spi.AbstractStylable;
import de.gsi.dataset.spi.DataRange;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.spi.utils.MathUtils;
import de.gsi.dataset.spi.utils.StringHashMapList;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntToDoubleFunction;

public abstract class AbstractDataSet<D extends AbstractStylable<D>>
extends AbstractStylable<D>
implements DataSet,
DataSetMetaData {
    private static final long serialVersionUID = -7612136495756923417L;
    private static final String[] DEFAULT_AXES_NAME = new String[]{"x-Axis", "y-Axis", "z-Axis"};
    private final transient AtomicBoolean autoNotification = new AtomicBoolean(true);
    private String name;
    protected final int dimension;
    private boolean isVisible = true;
    private final List<AxisDescription> axesDescriptions = new ArrayList<AxisDescription>();
    private final transient List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    private final transient DataSetLock<? extends DataSet> lock = new DefaultDataSetLock<AbstractDataSet>(this);
    private final StringHashMapList dataLabels = new StringHashMapList();
    private final StringHashMapList dataStyles = new StringHashMapList();
    private final List<String> infoList = new ArrayList<String>();
    private final List<String> warningList = new ArrayList<String>();
    private final List<String> errorList = new ArrayList<String>();
    private transient EditConstraints editConstraints;
    private final Map<String, String> metaInfoMap = new ConcurrentHashMap<String, String>();
    private final transient AtomicBoolean axisUpdating = new AtomicBoolean(false);
    protected final transient EventListener axisListener = e -> {
        if (!this.isAutoNotification() || !(e instanceof AxisChangeEvent) || this.axisUpdating.get()) {
            return;
        }
        this.axisUpdating.set(true);
        AxisChangeEvent evt = (AxisChangeEvent)e;
        int axisDim = evt.getDimension();
        AxisDescription axisdescription = this.getAxisDescription(axisDim);
        if (!axisdescription.isDefined() && evt instanceof AxisRecomputationEvent) {
            this.recomputeLimits(axisDim);
            this.axisUpdating.set(false);
            return;
        }
        this.invokeListener(e);
        this.axisUpdating.set(false);
    };

    public AbstractDataSet(String name, int dimension) {
        AssertUtils.gtThanZero("dimension", dimension);
        this.name = name;
        this.dimension = dimension;
        for (int i = 0; i < this.dimension; ++i) {
            Object axisName = i < DEFAULT_AXES_NAME.length ? DEFAULT_AXES_NAME[i] : "dim" + (i + 1) + "-Axis";
            DefaultAxisDescription axisDescription = new DefaultAxisDescription(i, (String)axisName, "a.u.");
            axisDescription.autoNotification().set(false);
            axisDescription.addListener(this.axisListener);
            this.axesDescriptions.add(axisDescription);
        }
    }

    public String addDataLabel(int index, String label) {
        String retVal = this.lock().writeLockGuard(() -> this.dataLabels.put(index, label));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    public String addDataStyle(int index, String style) {
        String retVal = this.lock().writeLockGuard(() -> this.dataStyles.put(index, style));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    @Override
    public AtomicBoolean autoNotification() {
        return this.autoNotification;
    }

    protected int binarySearch(int dimIndex, double search, int indexMin, int indexMax) {
        if (indexMin == indexMax) {
            return indexMin;
        }
        if (indexMax - indexMin == 1) {
            if (Math.abs(this.get(dimIndex, indexMin) - search) < Math.abs(this.get(dimIndex, indexMax) - search)) {
                return indexMin;
            }
            return indexMax;
        }
        int middle = (indexMax + indexMin) / 2;
        double valMiddle = this.get(dimIndex, middle);
        if (valMiddle == search) {
            return middle;
        }
        if (search < valMiddle) {
            return this.binarySearch(dimIndex, search, indexMin, middle);
        }
        return this.binarySearch(dimIndex, search, middle, indexMax);
    }

    public D clearMetaInfo() {
        this.infoList.clear();
        this.warningList.clear();
        this.errorList.clear();
        return this.fireInvalidated(new UpdatedMetaDataEvent(this, "cleared meta data"));
    }

    protected boolean equalDataLabels(DataSet other) {
        if (other instanceof AbstractDataSet) {
            AbstractDataSet otherAbsDs = (AbstractDataSet)other;
            return this.getDataLabelMap().equals(otherAbsDs.getDataLabelMap());
        }
        for (int index = 0; index < this.getDataCount(); ++index) {
            String label2;
            String label1 = this.getDataLabel(index);
            if (Objects.equals(label1, label2 = other.getDataLabel(index))) continue;
            return false;
        }
        return true;
    }

    protected boolean equalEditConstraints(DataSet other) {
        if (other instanceof EditableDataSet) {
            EditableDataSet otherEditDs = (EditableDataSet)other;
            if (this.editConstraints != null && otherEditDs.getEditConstraints() == null) {
                return false;
            }
            return this.editConstraints == null || this.editConstraints.equals(otherEditDs.getEditConstraints());
        }
        return true;
    }

    protected boolean equalErrorValues(DataSet other, double epsilon) {
        if (!(this instanceof DataSetError) || !(other instanceof DataSetError)) {
            return true;
        }
        DataSetError thisErrorDs = (DataSetError)((Object)this);
        DataSetError otherErrorDs = (DataSetError)other;
        if (!thisErrorDs.getErrorType(0).equals((Object)otherErrorDs.getErrorType(0))) {
            return false;
        }
        if (!thisErrorDs.getErrorType(1).equals((Object)otherErrorDs.getErrorType(1))) {
            return false;
        }
        if (epsilon <= 0.0) {
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                for (int index = 0; index < this.getDataCount(); ++index) {
                    if (thisErrorDs.getErrorNegative(dimIndex, index) != otherErrorDs.getErrorNegative(dimIndex, index)) {
                        return false;
                    }
                    if (thisErrorDs.getErrorPositive(dimIndex, index) == otherErrorDs.getErrorPositive(dimIndex, index)) continue;
                    return false;
                }
            }
            return true;
        }
        for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
            for (int index = 0; index < this.getDataCount(); ++index) {
                if (!MathUtils.nearlyEqual(thisErrorDs.getErrorNegative(dimIndex, index), otherErrorDs.getErrorNegative(dimIndex, index), epsilon)) {
                    return false;
                }
                if (MathUtils.nearlyEqual(thisErrorDs.getErrorPositive(dimIndex, index), otherErrorDs.getErrorPositive(dimIndex, index), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean equalMetaData(DataSet other) {
        if (other instanceof DataSetMetaData) {
            DataSetMetaData otherMetaDs = (DataSetMetaData)((Object)other);
            if (!this.getErrorList().equals(otherMetaDs.getErrorList())) {
                return false;
            }
            if (!this.getWarningList().equals(otherMetaDs.getWarningList())) {
                return false;
            }
            if (!this.getInfoList().equals(otherMetaDs.getInfoList())) {
                return false;
            }
            return this.getMetaInfo().equals(otherMetaDs.getMetaInfo());
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        return this.equals(obj, -1.0);
    }

    public boolean equals(Object obj, double epsilon) {
        String name2;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)obj;
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getDataCount() != other.getDataCount()) {
            return false;
        }
        String name1 = this.getName();
        if (!Objects.equals(name1, name2 = other.getName())) {
            return false;
        }
        if (this.getAxisDescriptions().isEmpty() && !other.getAxisDescriptions().isEmpty()) {
            return false;
        }
        if (!this.getAxisDescriptions().equals(other.getAxisDescriptions())) {
            return false;
        }
        if (!this.equalDataLabels(other)) {
            return false;
        }
        if (!this.equalEditConstraints(other)) {
            return false;
        }
        if (!this.equalMetaData(other)) {
            return false;
        }
        if (!this.equalValues(other, epsilon)) {
            return false;
        }
        return this.equalErrorValues(other, epsilon);
    }

    protected boolean equalValues(DataSet other, double epsilon) {
        if (epsilon <= 0.0) {
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                for (int index = 0; index < this.getDataCount(); ++index) {
                    if (this.get(dimIndex, index) == other.get(dimIndex, index)) continue;
                    return false;
                }
            }
        } else {
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                for (int index = 0; index < this.getDataCount(); ++index) {
                    if (MathUtils.nearlyEqual(this.get(dimIndex, index), other.get(dimIndex, index), epsilon)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public D setVisible(boolean visible) {
        if (visible != this.isVisible) {
            this.isVisible = visible;
            this.fireInvalidated(new UpdatedMetaDataEvent(this, "changed visibility"));
        }
        return (D)this.getThis();
    }

    public D fireInvalidated(UpdateEvent event) {
        this.invokeListener(event);
        return (D)this.getThis();
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return this.axesDescriptions;
    }

    @Override
    public String getDataLabel(int index) {
        return (String)this.dataLabels.get(index);
    }

    public StringHashMapList getDataLabelMap() {
        return this.dataLabels;
    }

    public StringHashMapList getDataStyleMap() {
        return this.dataStyles;
    }

    @Override
    public final int getDimension() {
        return this.dimension;
    }

    public EditConstraints getEditConstraints() {
        return this.editConstraints;
    }

    @Override
    public List<String> getErrorList() {
        return this.errorList;
    }

    @Override
    public List<String> getInfoList() {
        return this.infoList;
    }

    @Override
    public Map<String, String> getMetaInfo() {
        return this.metaInfoMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStyle(int index) {
        return (String)this.dataStyles.get(index);
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    @Override
    public List<String> getWarningList() {
        return this.warningList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.axesDescriptions.hashCode();
        result = 31 * result + this.dataLabels.hashCode();
        result = 31 * result + this.dimension;
        result = 31 * result + Objects.hashCode(this.editConstraints);
        result = 31 * result + this.errorList.hashCode();
        result = 31 * result + this.infoList.hashCode();
        result = 31 * result + this.metaInfoMap.hashCode();
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + this.warningList.hashCode();
        return result;
    }

    public DataSetLock<? extends DataSet> lock() {
        return this.lock;
    }

    public String removeDataLabel(int index) {
        String retVal = this.lock().writeLockGuard(() -> (String)this.dataLabels.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    public String removeStyle(int index) {
        String retVal = this.lock().writeLockGuard(() -> (String)this.dataStyles.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    public D setEditConstraints(EditConstraints constraints) {
        this.lock().writeLockGuard(() -> {
            this.editConstraints = constraints;
            return this.editConstraints;
        });
        return this.fireInvalidated(new UpdatedMetaDataEvent(this, "new edit constraints"));
    }

    public D setName(String name) {
        this.name = name;
        return (D)this.getThis();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append(" [dim=").append(this.getDimension()).append(',').append(" dataCount=").append(this.getDataCount()).append(',');
        for (int i = 0; i < this.getDimension(); ++i) {
            AxisDescription desc = this.getAxisDescription(i);
            boolean isDefined = desc.isDefined();
            builder.append(" axisName ='").append(desc.getName()).append("',").append(" axisUnit = '").append(desc.getUnit()).append("',").append(" axisRange = ").append(" [").append(isDefined ? Double.valueOf(desc.getMin()) : "NotDefined").append(", ").append(isDefined ? Double.valueOf(desc.getMax()) : "NotDefined").append("],");
            if (!(this instanceof DataSetError)) continue;
            DataSetError.ErrorType error = ((DataSetError)((Object)this)).getErrorType(i);
            builder.append(" errorType(").append(i).append(")=").append((Object)error).append(',');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public double[] getValues(int dimIndex) {
        int n = this.getDataCount();
        double[] retValues = new double[n];
        for (int i = 0; i < n; ++i) {
            retValues[i] = this.get(dimIndex, i);
        }
        return retValues;
    }

    @Override
    public double getValue(int dimIndex, double ... x) {
        AssertUtils.checkArrayDimension("x", x, 1);
        int index1 = this.getIndex(0, x);
        double x1 = this.get(0, index1);
        double y1 = this.get(dimIndex, index1);
        int index2 = x1 < x[0] ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.get(dimIndex, index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.get(0, index2);
        if (x1 == x2) {
            return this.get(dimIndex, index1);
        }
        double de1 = this.get(dimIndex, index1);
        return de1 + (this.get(dimIndex, index2) - de1) * (x[0] - x1) / (x2 - x1);
    }

    public static int binarySearch(double search, int indexMin, int indexMax, IntToDoubleFunction getter) {
        if (indexMin == indexMax) {
            return indexMin;
        }
        if (indexMax - indexMin == 1) {
            if (Math.abs(getter.applyAsDouble(indexMin) - search) < Math.abs(getter.applyAsDouble(indexMax) - search)) {
                return indexMin;
            }
            return indexMax;
        }
        int middle = (indexMax + indexMin) / 2;
        double valMiddle = getter.applyAsDouble(middle);
        if (valMiddle == search) {
            return middle;
        }
        if (search < valMiddle) {
            return AbstractDataSet.binarySearch(search, indexMin, middle, getter);
        }
        return AbstractDataSet.binarySearch(search, middle, indexMax, getter);
    }

    @Override
    public int getIndex(int dimIndex, double ... x) {
        AssertUtils.checkArrayDimension("x", x, 1);
        if (this.getDataCount() == 0) {
            return 0;
        }
        if (!Double.isFinite(x[0])) {
            return 0;
        }
        double min = this.getAxisDescription(dimIndex).getMin();
        double max = this.getAxisDescription(dimIndex).getMax();
        if (Double.isFinite(min) && x[0] <= min || x[0] <= this.get(dimIndex, 0)) {
            return 0;
        }
        int lastIndex = this.getDataCount() - 1;
        if (Double.isFinite(max) && x[0] >= max || x[0] >= this.get(dimIndex, this.getDataCount() - 1)) {
            return lastIndex;
        }
        return AbstractDataSet.binarySearch(x[0], 0, lastIndex, val -> this.get(dimIndex, val));
    }

    @Override
    public DataSet recomputeLimits(int dimIndex) {
        DataRange newRange = new DataRange();
        int dataCount = this.getDataCount();
        for (int i = 0; i < dataCount; ++i) {
            newRange.add(this.get(dimIndex, i));
        }
        this.getAxisDescription(dimIndex).set(newRange.getMin(), newRange.getMax());
        return this;
    }

    @Override
    public synchronized List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    protected boolean copyMetaData(DataSet other) {
        this.setName(other.getName());
        if (!(other instanceof DataSetMetaData)) {
            return false;
        }
        DataSetMetaData otherMeta = (DataSetMetaData)((Object)other);
        this.infoList.clear();
        this.infoList.addAll(otherMeta.getInfoList());
        this.warningList.clear();
        this.warningList.addAll(otherMeta.getWarningList());
        this.errorList.clear();
        this.errorList.addAll(otherMeta.getErrorList());
        this.metaInfoMap.clear();
        this.metaInfoMap.putAll(otherMeta.getMetaInfo());
        return true;
    }

    protected void copyDataLabelsAndStyles(DataSet other, boolean copy) {
        this.setStyle(other.getStyle());
        if (copy || !(other instanceof AbstractDataSet)) {
            int index;
            this.getDataLabelMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String label = other.getDataLabel(index);
                if (label == null || label.isEmpty()) continue;
                this.addDataLabel(index, label);
            }
            this.getDataStyleMap().clear();
            for (index = 0; index < other.getDataCount(); ++index) {
                String style = other.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                this.addDataStyle(index, style);
            }
            return;
        }
        AbstractDataSet otherAbstract = (AbstractDataSet)other;
        this.getDataLabelMap().clear();
        this.getDataLabelMap().putAll(otherAbstract.getDataLabelMap());
        this.getDataStyleMap().clear();
        this.getDataStyleMap().putAll(otherAbstract.getDataStyleMap());
    }

    protected void copyAxisDescription(DataSet other) {
        for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
            this.getAxisDescription(dimIndex).set(other.getAxisDescription(dimIndex));
        }
    }
}

