/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DataRange;

public abstract class AbstractErrorDataSet<D extends AbstractErrorDataSet<D>>
extends AbstractDataSet<D>
implements DataSetError {
    private static final long serialVersionUID = -5592816592868472957L;
    private final DataSetError.ErrorType[] errorType;

    protected AbstractErrorDataSet(String name, int dimension, DataSetError.ErrorType ... errorTypes) {
        super(name, dimension);
        this.errorType = errorTypes;
    }

    @Override
    public D fireInvalidated(UpdateEvent event) {
        super.fireInvalidated(event);
        return (D)this.getThis();
    }

    @Override
    public DataSetError.ErrorType getErrorType(int dimIndex) {
        return this.errorType[dimIndex];
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    @Override
    public DataSetLock<D> lock() {
        return super.lock();
    }

    public D recomputeLimits(int dimIndex) {
        DataRange newRange = new DataRange();
        int dataCount = this.getDataCount();
        switch (this.getErrorType(dimIndex)) {
            case NO_ERROR: {
                super.recomputeLimits(dimIndex);
                break;
            }
            case ASYMMETRIC: {
                for (int i = 0; i < dataCount; ++i) {
                    double value = this.get(dimIndex, i);
                    double errorNeg = this.getErrorNegative(dimIndex, i);
                    double errorPos = this.getErrorPositive(dimIndex, i);
                    newRange.add(value - errorNeg);
                    newRange.add(value + errorPos);
                }
                this.getAxisDescription(dimIndex).set(newRange.getMin(), newRange.getMax());
                break;
            }
            default: {
                for (int i = 0; i < dataCount; ++i) {
                    double value = this.get(dimIndex, i);
                    double error = this.getErrorPositive(dimIndex, i);
                    newRange.add(value - error);
                    newRange.add(value + error);
                }
                this.getAxisDescription(dimIndex).set(newRange.getMin(), newRange.getMax());
            }
        }
        return (D)this.getThis();
    }

    public D setErrorType(int dimIndex, DataSetError.ErrorType errorType) {
        this.errorType[dimIndex] = errorType;
        return (D)this.getThis();
    }
}

