/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import java.util.ArrayDeque;

public class AveragingDataSet
extends AbstractDataSet<AveragingDataSet>
implements DataSet {
    private static final long serialVersionUID = 1L;
    private int averageSize = 1;
    private int fuzzyCount;
    private InternalDataSet dataset;
    private final ArrayDeque<DataSet> deque = new ArrayDeque();

    public AveragingDataSet(String name) {
        this(name, 2, 0);
    }

    public AveragingDataSet(String name, int nDims) {
        this(name, nDims, 0);
    }

    public AveragingDataSet(String name, int nDims, int fuzzyCount) {
        super(name, nDims);
        this.fuzzyCount = fuzzyCount;
    }

    public void add(DataSet ds) {
        if (this.averageSize == 1) {
            this.dataset = new InternalDataSet(ds);
        } else if (this.dataset == null || this.deque.isEmpty()) {
            this.dataset = new InternalDataSet(ds);
            this.deque.clear();
            this.deque.add(new InternalDataSet(ds));
        } else if (this.deque.size() < this.averageSize) {
            this.dataset.opScale(this.deque.size());
            this.dataset.opAdd(ds);
            this.deque.add(new InternalDataSet(ds));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        } else {
            this.dataset.opScale(this.deque.size());
            this.dataset.opSub(this.deque.pop());
            this.dataset.opAdd(ds);
            this.deque.add(new InternalDataSet(ds));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        }
        this.dataset.recomputeLimits(0);
        this.dataset.recomputeLimits(1);
        this.fireInvalidated(new AddedDataEvent(this));
    }

    public void clear() {
        this.deque.clear();
        this.dataset = null;
    }

    public int getAverageCount() {
        if (this.averageSize == 1) {
            return this.dataset == null ? 0 : 1;
        }
        return this.deque.size();
    }

    public int getAverageSize() {
        return this.averageSize;
    }

    @Override
    public int getDataCount() {
        return this.dataset == null ? 0 : this.dataset.getDataCount();
    }

    public int getFuzzyCount() {
        return this.fuzzyCount;
    }

    @Override
    public String getStyle(int index) {
        if (this.dataset == null) {
            return "";
        }
        return this.dataset.getStyle(index);
    }

    @Override
    public final double get(int dimIndex, int index) {
        if (this.dataset == null) {
            return Double.NaN;
        }
        return this.dataset.get(dimIndex, index);
    }

    public void setAverageSize(int avgCount) {
        if (avgCount < 1) {
            return;
        }
        if (this.averageSize != avgCount) {
            this.deque.clear();
            this.dataset = null;
        }
        this.averageSize = avgCount;
    }

    public void setFuzzyCount(int fuzzyCount) {
        this.fuzzyCount = fuzzyCount;
    }

    @Override
    public double getValue(int dimIndex, double ... x) {
        return this.get(dimIndex, this.getIndex(0, x[0]));
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            if (other instanceof AveragingDataSet) {
                this.fuzzyCount = ((AveragingDataSet)other).getFuzzyCount();
                this.averageSize = ((AveragingDataSet)other).getAverageSize();
                if (copy) {
                    this.clear();
                    ((AveragingDataSet)other).deque.forEach(ds -> this.add(new DefaultDataSet((DataSet)ds)));
                } else {
                    this.dataset = ((AveragingDataSet)other).dataset;
                    this.deque.clear();
                    this.deque.addAll(((AveragingDataSet)other).deque);
                }
                this.getAxisDescriptions().forEach(AxisDescription::clear);
                for (int dim = 0; dim < this.getDimension(); ++dim) {
                    this.recomputeLimits(dim);
                }
                return;
            }
            this.clear();
            if (copy) {
                this.add(new DefaultDataSet(other));
            } else {
                this.add(other);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
            for (int dim = 0; dim < this.getDimension(); ++dim) {
                this.recomputeLimits(dim);
            }
        }));
        return this.fireInvalidated(new UpdatedDataEvent(this, "set(DataSet, boolean=" + copy + ")"));
    }

    private class InternalDataSet
    extends DoubleErrorDataSet {
        private static final long serialVersionUID = 1L;

        public InternalDataSet(DataSet ds) {
            super(ds.getName(), ds.getValues(0), ds.getValues(1), new double[ds.getDataCount()], new double[ds.getDataCount()], ds.getDataCount(), true);
        }

        public boolean isIncompatible(DataSet d) {
            return Math.abs(super.getDataCount() - d.getDataCount()) > AveragingDataSet.this.fuzzyCount;
        }

        public void opAdd(DataSet d) {
            if (this.isIncompatible(d)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            this.yValues.size(d.getDataCount());
            for (int i = 0; i < this.yValues.size(); ++i) {
                double[] dArray = this.yValues.elements();
                int n = i;
                dArray[n] = dArray[n] + d.get(1, i);
            }
        }

        public void opScale(double f) {
            int i = 0;
            while (i < this.yValues.size()) {
                double[] dArray = this.yValues.elements();
                int n = i++;
                dArray[n] = dArray[n] * f;
            }
        }

        public void opSub(DataSet d) {
            if (this.isIncompatible(d)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            this.yValues.size(d.getDataCount());
            for (int i = 0; i < this.yValues.size(); ++i) {
                double[] dArray = this.yValues.elements();
                int n = i;
                dArray[n] = dArray[n] - d.get(1, i);
            }
        }
    }
}

