/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.CircularBuffer;
import de.gsi.dataset.utils.DoubleCircularBuffer;

public class CircularDoubleErrorDataSet
extends AbstractErrorDataSet<CircularDoubleErrorDataSet>
implements DataSetError,
DataSet2D {
    private static final long serialVersionUID = -8010355203980379253L;
    protected DoubleCircularBuffer xValues;
    protected DoubleCircularBuffer yValues;
    protected DoubleCircularBuffer yErrorsPos;
    protected DoubleCircularBuffer yErrorsNeg;
    protected CircularBuffer<String> dataLabels;
    protected CircularBuffer<String> dataStyles;

    public CircularDoubleErrorDataSet(String name, int initialSize) {
        super(name, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        AssertUtils.gtEqThanZero("initialSize", initialSize);
        this.xValues = new DoubleCircularBuffer(initialSize);
        this.yValues = new DoubleCircularBuffer(initialSize);
        this.yErrorsPos = new DoubleCircularBuffer(initialSize);
        this.yErrorsNeg = new DoubleCircularBuffer(initialSize);
        this.dataLabels = new CircularBuffer(initialSize);
        this.dataStyles = new CircularBuffer(initialSize);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String label) {
        return this.add(x, y, yErrorNeg, yErrorPos, label, null);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String label, String style) {
        this.lock().writeLockGuard(() -> {
            this.xValues.put(x);
            this.yValues.put(y);
            this.yErrorsPos.put(yErrorPos);
            this.yErrorsNeg.put(yErrorNeg);
            this.dataLabels.put(label);
            this.dataStyles.put(style);
            this.getAxisDescription(0).setMin(this.xValues.get(0));
            this.getAxisDescription(0).setMax(this.xValues.get(this.xValues.available() - 1));
            this.getAxisDescription(1).clear();
        });
        return (CircularDoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public CircularDoubleErrorDataSet add(double[] xVals, double[] yVals, double[] yErrNeg, double[] yErrPos) {
        AssertUtils.notNull("X coordinates", xVals);
        AssertUtils.notNull("Y coordinates", yVals);
        AssertUtils.notNull("Y error neg", yErrNeg);
        AssertUtils.notNull("Y error pos", yErrPos);
        int dataCount = Math.min(Math.min(xVals.length, yVals.length), Math.min(yErrNeg.length, yErrPos.length));
        return this.add(xVals, yVals, yErrNeg, yErrPos, dataCount);
    }

    public CircularDoubleErrorDataSet add(double[] xVals, double[] yVals, double[] yErrNeg, double[] yErrPos, int dataCount) {
        AssertUtils.notNull("X coordinates", xVals);
        AssertUtils.notNull("Y coordinates", yVals);
        AssertUtils.notNull("Y error neg", yErrNeg);
        AssertUtils.notNull("Y error pos", yErrPos);
        AssertUtils.gtOrEqual("X coordinates", dataCount, xVals.length);
        AssertUtils.gtOrEqual("Y coordinates", dataCount, yVals.length);
        AssertUtils.gtOrEqual("Y error neg", dataCount, yErrNeg.length);
        AssertUtils.gtOrEqual("Y error pos", dataCount, yErrPos.length);
        this.lock().writeLockGuard(() -> {
            this.xValues.put(xVals, dataCount);
            this.yValues.put(yVals, dataCount);
            this.yErrorsNeg.put(yErrNeg, dataCount);
            this.yErrorsPos.put(yErrPos, dataCount);
            this.dataLabels.put((String[])new String[yVals.length], dataCount);
            this.dataStyles.put((String[])new String[yVals.length], dataCount);
            this.getAxisDescription(0).setMin(this.xValues.get(0));
            this.getAxisDescription(0).setMax(this.xValues.get(this.xValues.available() - 1));
            this.getAxisDescription(1).clear();
        });
        return (CircularDoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public int getDataCount() {
        return this.xValues.available();
    }

    @Override
    public String getDataLabel(int index) {
        return this.dataLabels.get(index);
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsNeg.get(index);
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsPos.get(index);
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }

    @Override
    public final double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.xValues.get(index) : this.yValues.get(index);
    }

    @Override
    public String addDataLabel(int index, String label) {
        throw new UnsupportedOperationException("Adding data labels later is not supported, supply labels to add()");
    }

    @Override
    public String addDataStyle(int index, String style) {
        throw new UnsupportedOperationException("Adding data styles later is not supported, supply labels to add()");
    }

    @Override
    public String removeStyle(int index) {
        throw new UnsupportedOperationException("Removing data styles is not supported for this type of DataSet");
    }

    @Override
    public String removeDataLabel(int index) {
        throw new UnsupportedOperationException("Removing data labels is not supported for this type of DataSet");
    }

    public CircularDoubleErrorDataSet reset() {
        this.lock().writeLockGuard(() -> {
            this.xValues.reset();
            this.yValues.reset();
            this.yErrorsNeg.reset();
            this.yErrorsPos.reset();
            this.dataLabels.reset();
            this.dataStyles.reset();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (CircularDoubleErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            this.reset();
            if (other.getDataCount() == 0) {
                return;
            }
            int count = other.getDataCount();
            if (other instanceof DataSetError) {
                this.add(other.getValues(0), other.getValues(1), ((DataSetError)other).getErrorsNegative(1), ((DataSetError)other).getErrorsPositive(1), other.getDataCount());
            } else {
                this.add(other.getValues(0), other.getValues(1), new double[count], new double[count], other.getDataCount());
            }
            this.copyMetaData(other);
            this.copyDataLabelsAndStyles(other, copy);
            this.copyAxisDescription(other);
        }));
        return this.fireInvalidated(new UpdatedDataEvent(this, "set(DataSet, boolean=" + copy + ")"));
    }
}

