/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.dataset.spi.DoubleGridDataSet;
import de.gsi.dataset.spi.FloatDataSet;
import de.gsi.dataset.spi.MultiDimDoubleDataSet;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetBuilder.class);
    protected String name;
    protected Map<Integer, double[]> values = new HashMap<Integer, double[]>();
    protected Map<Integer, double[]> errorsPos = new HashMap<Integer, double[]>();
    protected Map<Integer, double[]> errorsNeg = new HashMap<Integer, double[]>();
    protected Map<Integer, float[]> valuesFloat = new HashMap<Integer, float[]>();
    protected Map<Integer, float[]> errorsPosFloat = new HashMap<Integer, float[]>();
    protected Map<Integer, float[]> errorsNegFloat = new HashMap<Integer, float[]>();
    protected int[] initialCapacity = null;
    private int dimension = -1;
    private boolean useErrors = false;
    private boolean useFloat = false;
    protected List<String> infoList = new ArrayList<String>();
    protected List<String> warningList = new ArrayList<String>();
    protected List<String> errorList = new ArrayList<String>();
    protected Map<String, String> metaInfoMap = new HashMap<String, String>();
    protected Map<Integer, String> dataLabels = new HashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new HashMap<Integer, String>();
    protected Map<Integer, AxisDescription> axisDescriptions = new HashMap<Integer, AxisDescription>();

    public DataSetBuilder() {
    }

    public DataSetBuilder(String dataSetName) {
        this.setName(dataSetName);
    }

    protected void addDataLabelStyleMap(DataSet dataSet) {
        if (!(dataSet instanceof AbstractDataSet)) {
            if (!this.dataLabels.isEmpty() || !this.dataStyles.isEmpty()) {
                LOGGER.atWarn().addArgument((Object)dataSet.getClass().getCanonicalName()).log("Dropping MetaData because return type does not implement DataSetMetaData: {}");
            }
            return;
        }
        AbstractDataSet ds = (AbstractDataSet)dataSet;
        this.dataLabels.forEach(ds::addDataLabel);
        this.dataStyles.forEach(ds::addDataStyle);
    }

    protected void addDataRanges(DataSet dataSet) {
        for (Map.Entry<Integer, AxisDescription> descriptionEntry : this.axisDescriptions.entrySet()) {
            dataSet.getAxisDescription(descriptionEntry.getKey()).set(descriptionEntry.getValue());
        }
    }

    protected void addMetaData(DataSet dataSet) {
        if (!(dataSet instanceof DataSetMetaData)) {
            if (!(this.infoList.isEmpty() && this.warningList.isEmpty() && this.errorList.isEmpty() && this.metaInfoMap.isEmpty())) {
                LOGGER.atWarn().addArgument((Object)dataSet.getClass().getCanonicalName()).log("Dropping MetaData because return type does not implement DataSetMetaData: {}");
            }
            return;
        }
        DataSetMetaData ds = (DataSetMetaData)((Object)dataSet);
        ds.getInfoList().addAll(this.infoList);
        ds.getWarningList().addAll(this.warningList);
        ds.getErrorList().addAll(this.errorList);
        ds.getMetaInfo().putAll(this.metaInfoMap);
    }

    public DataSet build() {
        Object dsName = this.name == null ? "DataSet@" + System.currentTimeMillis() : this.name;
        int dim = this.getResultDimension();
        int[] size = this.getResultSize(dim);
        DataSet dataSet = this.buildRawDataSet((String)dsName, dim, size);
        this.addMetaData(dataSet);
        this.addDataRanges(dataSet);
        this.addDataLabelStyleMap(dataSet);
        return dataSet;
    }

    public <T extends DataSet> T build(Class<T> clazz) {
        DataSet result;
        Object dsName = this.name == null ? "DataSet@" + System.currentTimeMillis() : this.name;
        int nDim = this.getResultDimension();
        int[] size = this.getResultSize(nDim);
        int dataCount = 0;
        for (int i = 0; i < nDim; ++i) {
            dataCount = Math.max(dataCount, size[i]);
        }
        if (nDim <= 2 && this.values.size() + this.errorsPos.size() + this.errorsNeg.size() == 0 && this.valuesFloat.size() > 0 && this.errorsNegFloat.size() + this.errorsPosFloat.size() == 0) {
            this.useFloat = true;
        }
        if (clazz.isAssignableFrom(DefaultDataSet.class) && nDim <= 2 && !this.useErrors && !this.useFloat) {
            result = this.buildDefaultDataSet((String)dsName, dataCount);
        } else if (clazz.isAssignableFrom(DefaultErrorDataSet.class) && nDim <= 2 && this.useErrors && !this.useFloat) {
            result = this.buildDefaultErrorDataSet((String)dsName, dataCount);
        } else if (clazz.isAssignableFrom(FloatDataSet.class) && nDim <= 2 && !this.useErrors && this.useFloat) {
            result = this.buildDefaultDataSetFloat((String)dsName, dataCount);
        } else if (clazz.isAssignableFrom(MultiDimDoubleDataSet.class) && !this.useErrors && !this.useFloat) {
            result = this.buildMultiDimDataSet((String)dsName, size);
        } else if (clazz.isAssignableFrom(DoubleGridDataSet.class) && !this.useErrors && !this.useFloat) {
            result = this.buildGridDataSet((String)dsName, size);
        } else {
            if (EditableDataSet.class.isAssignableFrom(clazz) && !this.useErrors) {
                throw new UnsupportedOperationException("Instantiation of generic editable DataSet not implemented yet");
            }
            throw new UnsupportedOperationException("Return type not supported for DataSet Builder: " + clazz.getCanonicalName());
        }
        this.addMetaData(result);
        this.addDataRanges(result);
        this.addDataLabelStyleMap(result);
        return (T)result;
    }

    private int getResultDimension() {
        int maxDim = this.values.keySet().stream().max(Integer::compare).orElse(-1);
        maxDim = Math.max(maxDim, this.valuesFloat.keySet().stream().max(Integer::compare).orElse(-1));
        maxDim = Math.max(maxDim, this.errorsNeg.keySet().stream().max(Integer::compare).orElse(-1));
        maxDim = Math.max(maxDim, this.errorsNegFloat.keySet().stream().max(Integer::compare).orElse(-1));
        maxDim = Math.max(maxDim, this.errorsPos.keySet().stream().max(Integer::compare).orElse(-1));
        maxDim = Math.max(maxDim, this.errorsPosFloat.keySet().stream().max(Integer::compare).orElse(-1));
        maxDim = Math.max(maxDim, this.axisDescriptions.keySet().stream().max(Integer::compare).orElse(-1));
        if (this.dimension == -1) {
            return maxDim + 1;
        }
        if (this.dimension <= maxDim) {
            throw new UnsupportedOperationException("Supplied data dimensions exceed requested number of dimensions");
        }
        return this.dimension;
    }

    private int[] getResultSize(int nDims) {
        int[] result = new int[nDims];
        for (int i = 0; i < nDims; ++i) {
            result[i] = this.getResultSize(nDims, i);
        }
        return result;
    }

    private int getResultSize(int nDims, int dimIndex) {
        if (this.initialCapacity != null && dimIndex < this.initialCapacity.length) {
            return this.initialCapacity[dimIndex];
        }
        if (this.initialCapacity != null && this.initialCapacity.length > 0) {
            return this.initialCapacity[this.initialCapacity.length - 1];
        }
        int result = 0;
        if (this.values.containsKey(dimIndex)) {
            result = Math.max(result, this.values.get(dimIndex).length);
        }
        if (this.valuesFloat.containsKey(dimIndex)) {
            result = Math.max(result, this.valuesFloat.get(dimIndex).length);
        }
        if (this.errorsNeg.containsKey(dimIndex)) {
            result = Math.max(result, this.errorsNeg.get(dimIndex).length);
        }
        if (this.errorsNegFloat.containsKey(dimIndex)) {
            result = Math.max(result, this.errorsNegFloat.get(dimIndex).length);
        }
        if (this.errorsPos.containsKey(dimIndex)) {
            result = Math.max(result, this.errorsPos.get(dimIndex).length);
        }
        if (this.errorsPosFloat.containsKey(dimIndex)) {
            result = Math.max(result, this.errorsPosFloat.get(dimIndex).length);
        }
        if (dimIndex == nDims - 1) {
            result = Math.max(result, this.dataLabels.keySet().stream().max(Integer::compare).orElse(-1));
            result = Math.max(result, this.dataStyles.keySet().stream().max(Integer::compare).orElse(-1));
        }
        return result;
    }

    protected DataSet buildRawDataSet(String dsName, int dim, int[] size) {
        switch (dim) {
            case 0: 
            case 1: 
            case 2: {
                int dataCount = 0;
                for (int i2 = 0; i2 < dim; ++i2) {
                    dataCount = Math.max(dataCount, size[i2]);
                }
                if (this.values.size() + this.errorsPos.size() + this.errorsNeg.size() == 0 && this.valuesFloat.size() > 0 && this.errorsNegFloat.size() + this.errorsPosFloat.size() == 0) {
                    this.useFloat = true;
                }
                if (this.errorsNeg.size() == 0 && this.errorsPos.size() == 0 && this.errorsNegFloat.size() == 0 && this.errorsPosFloat.size() == 0 && !this.useErrors) {
                    if (this.useFloat) {
                        return this.buildDefaultDataSetFloat(dsName, dataCount);
                    }
                    return this.buildDefaultDataSet(dsName, dataCount);
                }
                if (this.useFloat) {
                    throw new UnsupportedOperationException("No float error DataSet implemented yet");
                }
                return this.buildDefaultErrorDataSet(dsName, dataCount);
            }
        }
        if (this.useFloat) {
            throw new UnsupportedOperationException("Float DataSet Not implemented for nDims > 2");
        }
        if (this.errorsNeg.size() != 0 || this.errorsPos.size() != 0 || this.errorsNegFloat.size() != 0 || this.errorsPosFloat.size() != 0 || this.useErrors) {
            throw new UnsupportedOperationException("Error DataSet Not implemented for nDims > 2");
        }
        if (IntStream.of(size).allMatch(i -> i == size[0] || i == -1)) {
            return this.buildMultiDimDataSet(dsName, size);
        }
        return this.buildGridDataSet(dsName, size);
    }

    private DataSet buildDefaultDataSet(String dsName, int size) {
        double[] xvalues = this.getValues(0, size);
        double[] yvalues = this.getValues(1, size);
        return new DefaultDataSet(dsName, xvalues, yvalues, size, false);
    }

    private DataSet buildDefaultDataSetFloat(String dsName, int size) {
        float[] xvalues = this.getValuesFloat(0, size);
        float[] yvalues = this.getValuesFloat(1, size);
        return new FloatDataSet(dsName, xvalues, yvalues, size, false);
    }

    private DataSet buildDefaultErrorDataSet(String dsName, int size) {
        double[] xvalues = this.getValues(0, size);
        double[] yvalues = this.getValues(1, size);
        if (this.errorsNeg.containsKey(0) || this.errorsPos.containsKey(0) || this.errorsNegFloat.containsKey(0) || this.errorsPosFloat.containsKey(0)) {
            throw new UnsupportedOperationException("DataSetBuilder: X Errors not implemented for 2D DataSetBuilder");
        }
        double[] yen = this.getErrors(1, size, false);
        double[] yep = this.getErrors(1, size, true);
        DefaultErrorDataSet dataSet = new DefaultErrorDataSet(dsName, xvalues, yvalues, yen, yep, size, false);
        dataSet.setErrorType(1, this.getErrorType(1));
        return dataSet;
    }

    private DataSet buildMultiDimDataSet(String dsName, int[] size) {
        int nDims = size.length;
        double[][] inputValues = new double[nDims][];
        for (int dimIndex = 0; dimIndex < nDims; ++dimIndex) {
            inputValues[dimIndex] = this.getValues(dimIndex, size[dimIndex]);
            if (!this.errorsNeg.containsKey(dimIndex) && !this.errorsPos.containsKey(dimIndex) && !this.useErrors) continue;
            throw new UnsupportedOperationException("DataSetBuilder: Errors not implemented for MultiDimDataSet");
        }
        return new MultiDimDoubleDataSet(dsName, false, inputValues);
    }

    private DataSet buildGridDataSet(String dsName, int[] size) {
        int nDims = size.length;
        if (size[nDims - 1] == 0) {
            return new DoubleGridDataSet(dsName, nDims, new int[nDims - 1]);
        }
        int nGrid = 0;
        int validateDataCount = 1;
        for (int i = 0; i < size.length; ++i) {
            if (size[i] != size[size.length - 1]) {
                nGrid = i + 1;
                validateDataCount *= size[i];
                continue;
            }
            if (size[i] == validateDataCount) continue;
            throw new IllegalArgumentException("Dimension Mismatch");
        }
        double[][] gridValues = new double[nGrid][];
        double[][] inputValues = new double[nDims - nGrid][];
        for (int dimIndex = 0; dimIndex < nDims; ++dimIndex) {
            if (dimIndex < nGrid) {
                gridValues[dimIndex] = this.getValues(dimIndex, size[dimIndex]);
            } else {
                inputValues[dimIndex - nGrid] = this.getValues(dimIndex, size[dimIndex]);
            }
            if (!this.errorsNeg.containsKey(dimIndex) && !this.errorsPos.containsKey(dimIndex) && !this.useErrors) continue;
            throw new UnsupportedOperationException("DataSetBuilder: Errors not implemented for MultiDimDataSet");
        }
        return new DoubleGridDataSet(dsName, false, gridValues, (double[][])inputValues);
    }

    private double[] getValues(int dimIndex, int size) {
        double[] vals = this.values.get(dimIndex);
        if (vals == null && this.valuesFloat.containsKey(dimIndex)) {
            float[] valsFloat = this.valuesFloat.get(dimIndex);
            vals = IntStream.range(0, size).mapToDouble(i -> i < valsFloat.length ? (double)valsFloat[i] : 0.0).toArray();
        } else if (vals == null) {
            vals = dimIndex == 0 ? IntStream.range(0, size).mapToDouble(x -> x).toArray() : new double[size];
        } else if (vals.length != size) {
            double[] newVal = new double[size];
            System.arraycopy(vals, 0, newVal, 0, Math.min(vals.length, newVal.length));
            vals = newVal;
        }
        return vals;
    }

    private float[] getValuesFloat(int dimIndex, int size) {
        float[] vals;
        block4: {
            block3: {
                vals = this.valuesFloat.get(dimIndex);
                if (vals != null || !this.values.containsKey(dimIndex)) break block3;
                double[] valsDouble = this.values.get(dimIndex);
                vals = new float[size];
                for (int i = 0; i < size; ++i) {
                    vals[i] = (float)valsDouble[i];
                }
                break block4;
            }
            if (vals != null) break block4;
            vals = new float[size];
            if (dimIndex == 0) {
                vals = new float[size];
                for (int i = 0; i < size; ++i) {
                    vals[i] = i;
                }
            }
        }
        return vals;
    }

    private DataSetError.ErrorType getErrorType(int dimIndex) {
        Object[] en;
        Object[] ep;
        if (this.errorsPos.get(dimIndex) == null && this.errorsNeg.get(dimIndex) == null) {
            ep = this.errorsPosFloat.get(dimIndex);
            en = this.errorsNegFloat.get(dimIndex);
        } else if (this.errorsPosFloat.get(dimIndex) == null && this.errorsNegFloat.get(dimIndex) == null) {
            ep = this.errorsPos.get(dimIndex);
            en = this.errorsNeg.get(dimIndex);
        } else {
            String mixed = String.format("ep(double)=%s, en(double)=%s, ep(float)=%s, en(float)=%s", Arrays.toString(this.errorsPos.get(dimIndex)), Arrays.toString(this.errorsNeg.get(dimIndex)), Arrays.toString(this.errorsPosFloat.get(dimIndex)), Arrays.toString(this.errorsNegFloat.get(dimIndex)));
            throw new UnsupportedOperationException("mixed double/float error vectors for dimIndex " + dimIndex + " not supported: " + mixed);
        }
        if (ep != null && en != null) {
            return DataSetError.ErrorType.ASYMMETRIC;
        }
        if (ep != null || en != null) {
            return DataSetError.ErrorType.SYMMETRIC;
        }
        return DataSetError.ErrorType.NO_ERROR;
    }

    private double[] getErrors(int dimIndex, int size, boolean pos) {
        float[] floatsAlternate;
        double[] vals = pos ? this.errorsPos.get(dimIndex) : this.errorsNeg.get(dimIndex);
        float[] floats = pos ? this.errorsPosFloat.get(dimIndex) : this.errorsNegFloat.get(dimIndex);
        double[] valsAlternate = !pos ? this.errorsPos.get(dimIndex) : this.errorsNeg.get(dimIndex);
        float[] fArray = floatsAlternate = !pos ? this.errorsPosFloat.get(dimIndex) : this.errorsNegFloat.get(dimIndex);
        if (vals == null && floats != null) {
            vals = IntStream.range(0, size).mapToDouble(i -> floats[i]).toArray();
        } else if (vals == null && valsAlternate != null) {
            vals = valsAlternate;
        } else if (vals == null && floatsAlternate != null) {
            vals = IntStream.range(0, size).mapToDouble(i -> floatsAlternate[i]).toArray();
        } else if (vals == null) {
            vals = new double[size];
        }
        return vals;
    }

    private AxisDescription getAxisDescription(int dimIndex) {
        if (dimIndex < 0) {
            throw new UnsupportedOperationException("axis dimension cannot be negative]: " + dimIndex);
        }
        return this.axisDescriptions.computeIfAbsent(dimIndex, DefaultAxisDescription::new);
    }

    public DataSetBuilder setAxisMax(int dimension, double value) {
        this.getAxisDescription(dimension).setMax(value);
        return this;
    }

    public DataSetBuilder setAxisMin(int dimension, double value) {
        this.getAxisDescription(dimension).setMin(value);
        return this;
    }

    public DataSetBuilder setAxisName(int dimension, String name) {
        this.getAxisDescription(dimension).set(name, new String[0]);
        return this;
    }

    public DataSetBuilder setAxisUnit(int dimension, String unit) {
        this.getAxisDescription(dimension).set(this.getAxisDescription(dimension).getName(), unit);
        return this;
    }

    public DataSetBuilder setDataLabelMap(Map<Integer, String> map) {
        if (map != null && !map.isEmpty()) {
            this.dataLabels.putAll(map);
        }
        return this;
    }

    public DataSetBuilder setDataStyleMap(Map<Integer, String> map) {
        if (map != null && !map.isEmpty()) {
            this.dataStyles.putAll(map);
        }
        return this;
    }

    public DataSetBuilder setMetaErrorList(String ... errors) {
        this.errorList.addAll(Arrays.asList(errors));
        return this;
    }

    public DataSetBuilder setMetaInfoList(String ... infos) {
        this.infoList.addAll(Arrays.asList(infos));
        return this;
    }

    public DataSetBuilder setMetaInfoMap(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            this.metaInfoMap.putAll(map);
        }
        return this;
    }

    public DataSetBuilder setMetaWarningList(String ... warning) {
        this.warningList.addAll(Arrays.asList(warning));
        return this;
    }

    public final DataSetBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public DataSetBuilder setNegError(int dimIndex, double[] errors) {
        double[] vals = new double[errors.length];
        System.arraycopy(errors, 0, vals, 0, errors.length);
        return this.setNegErrorNoCopy(dimIndex, vals);
    }

    public final DataSetBuilder setNegError(int dimIndex, float[] errors) {
        float[] vals = new float[errors.length];
        System.arraycopy(errors, 0, vals, 0, errors.length);
        return this.setNegErrorNoCopy(dimIndex, vals);
    }

    public DataSetBuilder setNegErrorNoCopy(int dimIndex, double[] errors) {
        this.errorsNeg.put(dimIndex, errors);
        return this.setEnableErrors(true);
    }

    public DataSetBuilder setNegErrorNoCopy(int dimIndex, float[] errors) {
        this.errorsNegFloat.put(dimIndex, errors);
        return this.setEnableErrors(true);
    }

    public final DataSetBuilder setPosError(int dimIndex, double[] errors) {
        double[] vals = new double[errors.length];
        System.arraycopy(errors, 0, vals, 0, errors.length);
        return this.setPosErrorNoCopy(dimIndex, vals);
    }

    public final DataSetBuilder setPosError(int dimIndex, float[] errors) {
        float[] vals = new float[errors.length];
        System.arraycopy(errors, 0, vals, 0, errors.length);
        return this.setPosErrorNoCopy(dimIndex, vals);
    }

    public final DataSetBuilder setPosErrorNoCopy(int dimIndex, double[] errors) {
        this.errorsPos.put(dimIndex, errors);
        return this.setEnableErrors(true);
    }

    public final DataSetBuilder setPosErrorNoCopy(int dimIndex, float[] errors) {
        this.errorsPosFloat.put(dimIndex, errors);
        return this.setEnableErrors(true);
    }

    public final DataSetBuilder setValues(int dimIndex, double[] values) {
        double[] vals = new double[values.length];
        System.arraycopy(values, 0, vals, 0, values.length);
        return this.setValuesNoCopy(dimIndex, vals);
    }

    public final DataSetBuilder setValues(int dimIndex, float[] values) {
        float[] vals = new float[values.length];
        System.arraycopy(values, 0, vals, 0, values.length);
        return this.setValuesNoCopy(dimIndex, vals);
    }

    public final DataSetBuilder setValues(int dimIndex, double[][] values) {
        AssertUtils.nonEmptyArray("values", (Object[])values);
        AssertUtils.nonEmptyArray("values first col", values[0]);
        int ysize = values.length;
        int xsize = values[0].length;
        int size = ysize * xsize;
        double[] vals = new double[size];
        for (int i = 0; i < ysize; ++i) {
            AssertUtils.checkArrayDimension("column length", values[i], xsize);
            System.arraycopy(values[i], 0, vals, i * xsize, xsize);
        }
        return this.setValuesNoCopy(dimIndex, vals);
    }

    public DataSetBuilder setValuesNoCopy(int dimIndex, double[] values) {
        this.values.put(dimIndex, values);
        return this;
    }

    public DataSetBuilder setValuesNoCopy(int dimIndex, float[] values) {
        this.valuesFloat.put(dimIndex, values);
        return this;
    }

    public DataSetBuilder setDimension(int nDims) {
        this.dimension = nDims;
        return this;
    }

    public DataSetBuilder setEnableErrors(boolean enableErrors) {
        this.useErrors = enableErrors;
        return this;
    }

    public DataSetBuilder setUseFloat(boolean useFloat) {
        this.useFloat = useFloat;
        return this;
    }

    public DataSetBuilder setInitalCapacity(int ... newInitialCapacity) {
        this.initialCapacity = newInitialCapacity;
        return this;
    }
}

