/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.trees.IndexedNavigableSet;
import de.gsi.dataset.utils.trees.IndexedTreeSet;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class LimitedIndexedTreeDataSet
extends AbstractErrorDataSet<LimitedIndexedTreeDataSet>
implements DataSet {
    private static final long serialVersionUID = -6372417982869679455L;
    protected transient IndexedNavigableSet<DataAtom> data = new IndexedTreeSet<DataAtom>();
    protected int maxQueueSize;
    protected double maxLength = Double.MAX_VALUE;
    protected boolean subtractOffset = false;
    protected boolean isSortedByX = true;

    public LimitedIndexedTreeDataSet(String name) {
        super(name, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        this.maxQueueSize = 1000;
    }

    public LimitedIndexedTreeDataSet(String name, int maxQueueSize) {
        super(name, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        this.maxQueueSize = maxQueueSize;
    }

    public LimitedIndexedTreeDataSet(String name, int maxQueueSize, double maxLength) {
        super(name, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        this.maxQueueSize = maxQueueSize;
        this.maxLength = maxLength;
    }

    public LimitedIndexedTreeDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0, new String[0]);
    }

    public LimitedIndexedTreeDataSet add(double x, double y, double ex, double ey, String ... labelStyle) {
        this.lock().writeLockGuard(() -> {
            this.data.add(new DataAtom(x, y, ex, ey, labelStyle));
            this.getAxisDescription(0).add(x - ex);
            this.getAxisDescription(0).add(x + ex);
            this.getAxisDescription(1).add(y - ey);
            this.getAxisDescription(1).add(y + ey);
            this.expire();
        });
        return (LimitedIndexedTreeDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet add(double[] xValues, double[] yValues) {
        return this.add(xValues, yValues, new double[yValues.length], new double[yValues.length], new String[0]);
    }

    public LimitedIndexedTreeDataSet add(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors, String ... labelStyle) {
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("X error data", xErrors);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error data", yValues);
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < xValues.length; ++i) {
                double x = xValues[i];
                double y = yValues[i];
                double ex = xErrors[i];
                double ey = yErrors[i];
                this.data.add(new DataAtom(x, y, ex, ey, labelStyle));
                this.getAxisDescription(0).add(x - ex);
                this.getAxisDescription(0).add(x + ex);
                this.getAxisDescription(1).add(y - ey);
                this.getAxisDescription(1).add(y + ey);
            }
            this.expire();
        });
        return (LimitedIndexedTreeDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public String addDataLabel(int index, String label) {
        String old = this.data.get((int)index).label;
        this.data.get((int)index).label = label;
        return old;
    }

    @Override
    public String addDataStyle(int index, String style) {
        String old = this.data.get((int)index).style;
        this.data.get((int)index).style = style;
        return old;
    }

    public LimitedIndexedTreeDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (LimitedIndexedTreeDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clear"));
    }

    public void expire() {
        this.lock().writeLockGuard(() -> this.expire(((DataAtom)this.data.last()).getX()));
    }

    public void expire(double now) {
        this.lock().writeLockGuard(() -> {
            try {
                DataAtom first = (DataAtom)this.data.first();
                if (first == null) {
                    return;
                }
                while (this.data.size() > this.maxQueueSize || now - first.getX() > this.maxLength) {
                    this.data.remove(first);
                    first = (DataAtom)this.data.first();
                }
                this.getAxisDescriptions().forEach(AxisDescription::clear);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        });
    }

    @Override
    public double get(int dimIndex, int i) {
        switch (dimIndex) {
            case 0: {
                return this.subtractOffset ? this.data.get(i).getX() - this.data.get(this.data.size() - 1).getX() : this.data.get(i).getX();
            }
            case 1: {
                return this.data.get(i).getY();
            }
        }
        throw new IndexOutOfBoundsException("dimIndex out of bound 2");
    }

    public IndexedNavigableSet<DataAtom> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.data.get(index).getLabel();
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? this.data.get(index).getErrorX() : this.data.get(index).getErrorY();
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? this.data.get(index).getErrorX() : this.data.get(index).getErrorY();
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    @Override
    public String getStyle(int index) {
        return this.data.get(index).getStyle();
    }

    public boolean isSortedByX() {
        return this.isSortedByX;
    }

    public boolean isSubtractOffset() {
        return this.subtractOffset;
    }

    public LimitedIndexedTreeDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            ArrayList<DataAtom> toRemove = new ArrayList<DataAtom>();
            for (int i = fromIndex; i < toIndex; ++i) {
                toRemove.add(this.data.get(i));
            }
            this.data.removeAll(toRemove);
            this.getAxisDescription(0).setMax(Double.NaN);
            this.getAxisDescription(1).setMax(Double.NaN);
        });
        return (LimitedIndexedTreeDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet remove(int[] indices) {
        AssertUtils.notNull("Indices array", indices);
        if (indices.length == 0) {
            return this;
        }
        this.lock().writeLockGuard(() -> {
            ArrayList<DataAtom> tupleTobeRemovedReferences = new ArrayList<DataAtom>();
            for (int indexToRemove : indices) {
                tupleTobeRemovedReferences.add(this.data.get(indexToRemove));
            }
            this.data.removeAll(tupleTobeRemovedReferences);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (LimitedIndexedTreeDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public String removeDataLabel(int index) {
        String old = this.data.get((int)index).label;
        this.data.get((int)index).label = "";
        return old;
    }

    @Override
    public String removeStyle(int index) {
        String old = this.data.get((int)index).style;
        this.data.get((int)index).style = "";
        return old;
    }

    public LimitedIndexedTreeDataSet reset() {
        this.lock().writeLockGuard(() -> this.getData().clear());
        return this;
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues) {
        int ndim = xValues.length;
        return this.set(xValues, yValues, new double[ndim], new double[ndim], ndim);
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors, int count) {
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        if (xValues.length < count || yValues.length < count || xErrors.length < count || yErrors.length < count) {
            throw new IllegalArgumentException("Arrays with coordinates must have length >= count!");
        }
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < xValues.length; ++i) {
                double x = xValues[i];
                double y = yValues[i];
                double dx = xErrors[i];
                double dy = yValues[i];
                this.getAxisDescription(0).add(x - dx);
                this.getAxisDescription(0).add(x + dx);
                this.getAxisDescription(1).add(y - dy);
                this.getAxisDescription(1).add(y + dy);
                this.data.add(new DataAtom(x, y, dx, dy, new String[0]));
            }
            this.expire();
        });
        return (LimitedIndexedTreeDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues, double[] yErrors, int count) {
        return this.set(xValues, yValues, new double[count], yErrors, count);
    }

    public LimitedIndexedTreeDataSet set(double[] xValues, double[] yValues, int count) {
        return this.set(xValues, yValues, new double[count], new double[count], count);
    }

    public LimitedIndexedTreeDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    public LimitedIndexedTreeDataSet set(int index, double x, double y, double dx, double dy) {
        this.lock().writeLockGuard(() -> {
            this.data.get(index).set(x, y, dy, dy, new String[0]);
            this.getAxisDescription(0).add(x - dx);
            this.getAxisDescription(0).add(x + dx);
            this.getAxisDescription(1).add(y - dy);
            this.getAxisDescription(1).add(y + dy);
            this.expire();
        });
        return (LimitedIndexedTreeDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        this.lock().writeLockGuard(() -> other.lock().readLockGuard(() -> {
            this.clearData();
            if (other instanceof DataSetError) {
                DataSetError oEds = (DataSetError)other;
                for (int i = 0; i < other.getDataCount(); ++i) {
                    double ex = Math.abs(Math.max(oEds.getErrorNegative(0, i), oEds.getErrorPositive(0, i)));
                    double ey = Math.abs(Math.max(oEds.getErrorNegative(1, i), oEds.getErrorPositive(1, i)));
                    this.add(oEds.get(0, i), oEds.get(1, i), ex, ey, new String[0]);
                }
            } else {
                for (int i = 0; i < other.getDataCount(); ++i) {
                    this.add(other.get(0, i), other.get(1, i));
                }
            }
            super.copyDataLabelsAndStyles(other, copy);
            super.copyMetaData(other);
            super.copyAxisDescription(other);
        }));
        return this.fireInvalidated(new UpdatedDataEvent(this, "set(DataSet, boolean=" + copy + ")"));
    }

    public LimitedIndexedTreeDataSet setMaxLength(double maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public LimitedIndexedTreeDataSet setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public void setSortedByX(boolean sortedByX) {
        this.isSortedByX = sortedByX;
    }

    public void setSubtractOffset(boolean subtractOffset) {
        this.subtractOffset = subtractOffset;
    }

    protected class DataAtom
    implements Comparable<DataAtom> {
        protected double x;
        protected double y;
        protected double ex;
        protected double ey;
        protected String label;
        protected String style;

        protected DataAtom(double x, double y, double ex, double ey, String ... args) {
            this.set(x, y, ex, ey, args);
        }

        @Override
        public int compareTo(DataAtom other) {
            if (this == other) {
                return 0;
            }
            if (LimitedIndexedTreeDataSet.this.isSortedByX) {
                if (this.getX() < other.getX()) {
                    return -1;
                }
                if (this.getX() > other.getX()) {
                    return 1;
                }
            } else {
                if (this.getY() < other.getY()) {
                    return -1;
                }
                if (this.getY() > other.getY()) {
                    return 1;
                }
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataAtom)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            return ((DataAtom)obj).getX() == this.getX();
        }

        public int hashCode() {
            return Double.hashCode(this.getX());
        }

        protected double getErrorX() {
            return this.ex;
        }

        protected double getErrorY() {
            return this.ey;
        }

        protected String getLabel() {
            return this.label;
        }

        protected String getStyle() {
            return this.style;
        }

        protected double getX() {
            return this.x;
        }

        protected double getY() {
            return this.y;
        }

        protected final void set(double x, double y, double ex, double ey, String ... args) {
            this.x = x;
            this.y = y;
            this.ex = ex;
            this.ey = ey;
            if (args == null) {
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                if (i == 0) {
                    this.label = args[i];
                }
                if (i != 1) continue;
                this.style = args[i];
            }
        }
    }
}

