/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.financial;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.dataset.spi.financial.api.attrs.AttributeModelAware;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcv;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import java.util.Iterator;

public class OhlcvDataSet
extends AbstractDataSet<OhlcvDataSet>
implements Iterable<IOhlcvItem>,
IOhlcvItemAware,
AttributeModelAware {
    public static final int DIM_Y_OPEN = 1;
    public static final int DIM_Y_HIGH = 2;
    public static final int DIM_Y_LOW = 3;
    public static final int DIM_Y_CLOSE = 4;
    public static final int DIM_Y_VOLUME = 5;
    public static final int DIM_Y_OI = 6;
    private IOhlcv ohlcv;
    private boolean isCategoryBased = false;

    public OhlcvDataSet(String title) {
        super(title, 7);
    }

    public void setData(IOhlcv ohlcv) {
        this.ohlcv = ohlcv;
    }

    public IOhlcv getData() {
        return this.ohlcv;
    }

    public boolean isCategoryBased() {
        return this.isCategoryBased;
    }

    public void setCategoryBased(boolean categoryBased) {
        this.isCategoryBased = categoryBased;
    }

    @Override
    public double get(int dimIndex, int index) {
        IOhlcvItem ohlcvItem = this.ohlcv.getOhlcvItem(index);
        switch (dimIndex) {
            case 0: {
                return this.isCategoryBased ? (double)index : (double)ohlcvItem.getTimeStamp().getTime() / 1000.0;
            }
            case 1: {
                return ohlcvItem.getOpen();
            }
            case 2: {
                return ohlcvItem.getHigh();
            }
            case 3: {
                return ohlcvItem.getLow();
            }
            case 4: {
                return ohlcvItem.getClose();
            }
            case 5: {
                return ohlcvItem.getVolume();
            }
            case 6: {
                return ohlcvItem.getOpenInterest();
            }
        }
        throw new IllegalArgumentException("Dimension not allowed! dimIndex=" + dimIndex);
    }

    @Override
    public Iterator<IOhlcvItem> iterator() {
        return this.ohlcv.iterator();
    }

    @Override
    public int getDataCount() {
        return this.ohlcv.size();
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        this.ohlcv = ((OhlcvDataSet)other).ohlcv;
        return this;
    }

    public int getXIndex(double x) {
        return this.getIndex(0, x);
    }

    @Override
    public AttributeModel getAddon() {
        return this.ohlcv.getAddon();
    }

    @Override
    public AttributeModel getAddonOrCreate() {
        return this.ohlcv.getAddonOrCreate();
    }

    @Override
    public IOhlcvItem getItem(int index) {
        return this.ohlcv.getOhlcvItem(index);
    }

    @Override
    public IOhlcvItem getLastItem() {
        int size = this.ohlcv.size();
        if (size == 0) {
            return null;
        }
        return this.ohlcv.getOhlcvItem(size - 1);
    }
}

