/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayChar
extends MultiArray<char[]> {
    public static MultiArrayChar wrap(char[] elements) {
        return MultiArrayChar.wrap(elements, 0, elements.length);
    }

    public static MultiArrayChar wrap(char[] elements, int offset, int length) {
        return new MultiArray1DChar(elements, new int[]{length}, offset);
    }

    public static MultiArrayChar wrap(char[] elements, int[] dimensions) {
        return MultiArrayChar.wrap(elements, 0, dimensions);
    }

    public static MultiArrayChar wrap(char[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DChar(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DChar(elements, dimensions, offset);
            }
        }
        return new MultiArrayChar(elements, dimensions, offset);
    }

    public static MultiArrayChar allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DChar(new char[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DChar(new char[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayChar(new char[nElements], dimensions, 0);
    }

    protected MultiArrayChar(char[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, char value) {
        ((char[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, char value) {
        ((char[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public char getStrided(int index) {
        return ((char[])this.elements)[index + this.offset];
    }

    public char get(int[] indices) {
        return ((char[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayChar)) {
            return false;
        }
        MultiArrayChar that = (MultiArrayChar)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((char[])this.elements, this.offset, this.offset + this.getElementsCount(), (char[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Character.hashCode(((char[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DChar
    extends MultiArrayChar {
        private final int stride;

        protected MultiArray2DChar(char[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[1];
        }

        public char get(int row, int column) {
            return ((char[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int row, int column, char value) {
            ((char[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public char[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((char[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DChar
    extends MultiArrayChar {
        protected MultiArray1DChar(char[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public char get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, char value) {
            this.setStrided(index, value);
        }
    }
}

