/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import de.gsi.dataset.testdata.spi.AbstractTestFunction;

public class CosineFunction
extends AbstractTestFunction<CosineFunction> {
    private static final long serialVersionUID = -3391027911729531271L;
    private final boolean useSystemTimeOffset;

    public CosineFunction(String name, int count) {
        super(name, count);
        this.useSystemTimeOffset = false;
    }

    public CosineFunction(String name, int count, boolean useSystemTime) {
        super(name, count);
        this.useSystemTimeOffset = useSystemTime;
        this.update();
    }

    @Override
    public double[] generateY(int count) {
        double[] retVal = new double[count];
        double period = (double)count / 10.0;
        double offset = this.useSystemTimeOffset ? (double)System.currentTimeMillis() / 1000.0 : 0.0;
        for (int i = 0; i < count; ++i) {
            double t = (double)i / period;
            retVal[i] = Math.cos(Math.PI * 2 * (t + 0.1 * offset));
        }
        return retVal;
    }
}

