/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import de.gsi.dataset.testdata.spi.AbstractTestFunction;

public class GaussFunction
extends AbstractTestFunction<GaussFunction> {
    private static final long serialVersionUID = -2090964369869257806L;
    private final double centre;
    private final double sigma;

    public GaussFunction(String name, int count) {
        super(name, count);
        this.centre = 0.5 * (double)count;
        this.sigma = 0.1 * (double)count;
        this.update();
    }

    public GaussFunction(String name, int count, double mean, double sigma) {
        super(name, count);
        this.centre = mean;
        this.sigma = sigma;
        this.update();
    }

    @Override
    public double[] generateY(int count) {
        double[] retVal = new double[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = GaussFunction.gauss(i, this.centre, this.sigma) * this.sigma;
        }
        return retVal;
    }

    public static double gauss(double x) {
        return Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double gauss(double x, double mu, double sigma) {
        return GaussFunction.gauss((x - mu) / sigma) / sigma;
    }
}

