/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ArrayCache {
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, boolean[]>> booleanArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, byte[]>> byteArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, double[]>> doubleArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, float[]>> floatArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, int[]>> intArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, long[]>> longArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, short[]>> shortArrayCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, WeakHashMap<Integer, String[]>> stringArrayCache = new ConcurrentHashMap();

    private ArrayCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] getCachedBooleanArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, boolean[]>> concurrentHashMap = booleanArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = booleanArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            boolean[] cachedArray = (boolean[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new boolean[size];
            } else {
                booleanArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCachedByteArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, byte[]>> concurrentHashMap = byteArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = byteArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            byte[] cachedArray = (byte[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new byte[size];
            } else {
                byteArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] getCachedDoubleArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, double[]>> concurrentHashMap = doubleArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = doubleArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            double[] cachedArray = (double[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new double[size];
            } else {
                doubleArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] getCachedFloatArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, float[]>> concurrentHashMap = floatArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = floatArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            float[] cachedArray = (float[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new float[size];
            } else {
                floatArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getCachedIntArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, int[]>> concurrentHashMap = intArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = intArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            int[] cachedArray = (int[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new int[size];
            } else {
                intArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getCachedLongArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, long[]>> concurrentHashMap = longArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = longArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            long[] cachedArray = (long[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new long[size];
            } else {
                longArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short[] getCachedShortArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, short[]>> concurrentHashMap = shortArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = shortArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            short[] cachedArray = (short[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new short[size];
            } else {
                shortArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getCachedStringArray(String arrayName, int size) {
        ConcurrentHashMap<String, WeakHashMap<Integer, String[]>> concurrentHashMap = stringArrayCache;
        synchronized (concurrentHashMap) {
            WeakHashMap nameHashMap = stringArrayCache.computeIfAbsent(arrayName, key -> new WeakHashMap());
            String[] cachedArray = (String[])nameHashMap.get(size);
            if (cachedArray == null) {
                cachedArray = new String[size];
            } else {
                stringArrayCache.get(arrayName).remove(size);
            }
            return cachedArray;
        }
    }

    public static void release(String arrayName, boolean[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        booleanArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public static void release(String arrayName, byte[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        byteArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public static void release(String arrayName, double[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        doubleArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public static void release(String arrayName, float[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        floatArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public static void release(String arrayName, int[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        intArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public static void release(String arrayName, long[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        longArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public static void release(String arrayName, short[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        shortArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public static void release(String arrayName, String[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        stringArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }
}

