/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import de.gsi.dataset.utils.CacheCollection;
import java.lang.ref.Reference;
import java.util.List;

public class ByteArrayCache
extends CacheCollection<byte[]> {
    private static final ByteArrayCache SELF = new ByteArrayCache();

    public byte[] getArray(int requiredSize) {
        return this.getArray(requiredSize, false);
    }

    public byte[] getArrayExact(int requiredSize) {
        return this.getArray(requiredSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getArray(int requiredSize, boolean exact) {
        List list = this.contents;
        synchronized (list) {
            byte[] bestFit = null;
            int bestFitSize = Integer.MAX_VALUE;
            for (Reference candidate : this.contents) {
                byte[] localRef = (byte[])candidate.get();
                if (localRef == null) continue;
                int sizeDiff = localRef.length - requiredSize;
                if (sizeDiff == 0) {
                    bestFit = localRef;
                    break;
                }
                if (sizeDiff <= 0 || sizeDiff >= bestFitSize || exact) continue;
                bestFitSize = sizeDiff;
                bestFit = localRef;
            }
            if (bestFit == null) {
                bestFit = new byte[requiredSize];
                return bestFit;
            }
            this.remove(bestFit);
            return bestFit;
        }
    }

    public static ByteArrayCache getInstance() {
        return SELF;
    }
}

