/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

public class DoubleCircularBuffer {
    private final double[] elements;
    private final int capacity;
    private int writePos;
    private boolean flipped;

    public DoubleCircularBuffer(double[] initalElements, int capacity) {
        this(capacity);
        this.put(initalElements, initalElements.length);
    }

    public DoubleCircularBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capcacity='" + capacity + "' must be larger than zero");
        }
        this.capacity = capacity;
        this.elements = new double[capacity];
        this.flipped = false;
    }

    public int available() {
        if (this.flipped) {
            return this.capacity;
        }
        return this.writePos;
    }

    public int capacity() {
        return this.capacity;
    }

    public double[] elements() {
        return this.elements;
    }

    public double get() {
        return this.get(0);
    }

    public double[] get(double[] into, int length) {
        return this.get(into, 0, length);
    }

    public double[] get(double[] into, int readPos, int length) {
        double[] retVal = into == null || into.length < length ? new double[length] : into;
        for (int i = 0; i < length; ++i) {
            retVal[i] = this.get(i + readPos);
        }
        return retVal;
    }

    public double get(int readPos) {
        int index = this.getIndex(readPos);
        return this.elements[index];
    }

    protected int getIndex(int readPos) {
        int index;
        int n = index = this.flipped ? this.writePos + readPos : readPos;
        if (!this.flipped) {
            if (index >= 0) {
                return index;
            }
            throw new IllegalArgumentException("writePos = '" + this.writePos + "' readPos = '" + readPos + "'/index = '" + index + "' is beyond circular buffer capacity limits = [0," + this.capacity + "]");
        }
        while (index < 0) {
            index += this.capacity;
        }
        while (index >= this.capacity) {
            index -= this.capacity;
        }
        return index;
    }

    public boolean isBufferFlipped() {
        return this.flipped;
    }

    public boolean put(double element) {
        this.elements[this.writePos++] = element;
        if (this.writePos == this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return true;
    }

    public int put(double[] newElements, int length) {
        return this.put(newElements, 0, length);
    }

    public int put(double[] newElements, int startIndex, int length) {
        int lengthUpperHalf = this.capacity - this.writePos;
        if (length <= lengthUpperHalf) {
            System.arraycopy(newElements, startIndex, this.elements, this.writePos, length);
            this.writePos += length;
            if (this.writePos == this.capacity) {
                this.writePos = 0;
                this.flipped = true;
            }
            return this.writePos;
        }
        System.arraycopy(newElements, startIndex, this.elements, this.writePos, lengthUpperHalf);
        this.writePos = this.capacity - 1;
        this.writePos += lengthUpperHalf;
        if (this.writePos >= this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return this.put(newElements, startIndex + lengthUpperHalf, length - lengthUpperHalf);
    }

    public int remainingCapacity() {
        return this.capacity - this.available();
    }

    public double replace(double element) {
        return this.replace(element, 0);
    }

    public double replace(double element, int atIndex) {
        int internalIndex = this.getIndex(atIndex);
        double oldValue = this.elements[internalIndex];
        this.elements[internalIndex] = element;
        return oldValue;
    }

    public void reset() {
        this.writePos = 0;
        this.flipped = false;
    }

    public int writePosition() {
        return this.writePos;
    }
}

