/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessingProfiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingProfiler.class);
    protected static boolean debugState = false;
    protected static boolean verboseOutput = true;
    protected static boolean loggerOutput = false;

    private ProcessingProfiler() {
    }

    public static List<String> getCallingClassMethod(int ... recursionDepth) {
        int i;
        int nLast;
        ArrayList<String> list = new ArrayList<String>();
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int[] nArray = recursionDepth;
        int n = nArray.length;
        for (int j = 0; j < n && (nLast = 2 + (i = nArray[j])) < stacktrace.length; ++j) {
            StringBuilder strBuilder = new StringBuilder();
            StackTraceElement stackTraceElement = stacktrace[nLast];
            String fullClassName = stackTraceElement.getClassName();
            String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String methodName = stackTraceElement.getMethodName();
            int lineNumer = stackTraceElement.getLineNumber();
            strBuilder.append(simpleClassName).append("::").append(methodName).append("(line:").append(lineNumer).append(')');
            list.add(strBuilder.toString());
        }
        return list;
    }

    protected static String getCallingClassMethod(String msg) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int nLast = msg == null ? 4 : 3;
        StackTraceElement stackTraceElement = stacktrace[nLast];
        String fullClassName = stackTraceElement.getClassName();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        String methodName = stackTraceElement.getMethodName();
        int lineNumer = stackTraceElement.getLineNumber();
        return simpleClassName + "::" + methodName + "(line:" + lineNumer + ")";
    }

    public static boolean getDebugState() {
        return debugState;
    }

    public static boolean getLoggerOutputState() {
        return loggerOutput;
    }

    public static long getTimeDiff(long lastStamp) {
        return ProcessingProfiler.getTimeDiff(lastStamp, null);
    }

    public static long getTimeDiff(long lastStamp, String msg) {
        if (!debugState) {
            return 0L;
        }
        long now = System.nanoTime();
        double diff = TimeUnit.NANOSECONDS.toMillis(now - lastStamp);
        if (verboseOutput) {
            String compoundName = ProcessingProfiler.getCallingClassMethod(msg);
            String message = String.format("%-55s - time diff = %8.3f [ms] msg: '%s'", compoundName, diff, msg == null ? "" : msg);
            if (loggerOutput) {
                LOGGER.info(message);
            } else {
                System.out.println(message);
            }
        }
        return now;
    }

    public static long getTimeStamp() {
        if (debugState) {
            return System.nanoTime();
        }
        return 0L;
    }

    public static boolean getVerboseOutputState() {
        return verboseOutput;
    }

    public static void setDebugState(boolean state) {
        debugState = state;
    }

    public static void setLoggerOutputState(boolean state) {
        loggerOutput = state;
    }

    public static void setVerboseOutputState(boolean state) {
        verboseOutput = state;
    }
}

