/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;

public class SoftHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_RETENTION_SIZE = 100;
    private final Map<K, SoftValue<V, K>> map;
    private final int retentionSize;
    private final Queue<V> strongReferences;
    private final ReentrantLock strongReferencesLock;
    private final ReferenceQueue<? super V> queue;

    public SoftHashMap() {
        this(100);
    }

    public SoftHashMap(int retentionSize) {
        this.retentionSize = Math.max(0, retentionSize);
        this.queue = new ReferenceQueue();
        this.strongReferencesLock = new ReentrantLock();
        this.map = new ConcurrentHashMap<K, SoftValue<V, K>>();
        this.strongReferences = new ConcurrentLinkedQueue<V>();
    }

    public SoftHashMap(Map<K, V> source) {
        this(100);
        this.putAll(source);
    }

    public SoftHashMap(Map<K, V> source, int retentionSize) {
        this(retentionSize);
        this.putAll(source);
    }

    @Override
    public void clear() {
        this.strongReferencesLock.lock();
        try {
            this.strongReferences.clear();
        }
        finally {
            this.strongReferencesLock.unlock();
        }
        this.processQueue();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        Collection<V> values = this.values();
        return values != null && values.contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        Set<K> keys = this.map.keySet();
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        ConcurrentHashMap kvPairs = new ConcurrentHashMap(keys.size());
        for (Object key : keys) {
            V v = this.get(key);
            if (v == null) continue;
            kvPairs.put(key, v);
        }
        return kvPairs.entrySet();
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        V result = null;
        SoftValue<V, K> value = this.map.get(key);
        if (value != null) {
            result = (V)value.get();
            if (result == null) {
                this.map.remove(key);
            } else {
                this.addToStrongReferences(result);
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftValue<? super V, K> sv = new SoftValue<V, K>(value, key, this.queue);
        SoftValue<? super V, K> previous = this.map.put(key, sv);
        this.addToStrongReferences(value);
        return previous == null ? null : (V)previous.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null || m.isEmpty()) {
            this.processQueue();
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        SoftValue<V, K> raw = this.map.remove(key);
        return raw == null ? null : (V)raw.get();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        Set<K> keys = this.map.keySet();
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<V> values = new ArrayList<V>(keys.size());
        for (Object key : keys) {
            V v = this.get(key);
            if (v == null) continue;
            values.add(v);
        }
        return values;
    }

    private void addToStrongReferences(V result) {
        this.strongReferencesLock.lock();
        try {
            this.strongReferences.add(result);
            this.trimStrongReferencesIfNecessary();
        }
        finally {
            this.strongReferencesLock.unlock();
        }
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(sv.key);
        }
    }

    private void trimStrongReferencesIfNecessary() {
        while (this.strongReferences.size() > this.retentionSize) {
            this.strongReferences.poll();
        }
    }

    private static class SoftValue<V, K>
    extends SoftReference<V> {
        private final K key;

        private SoftValue(V value, K key, ReferenceQueue<? super V> queue) {
            super(value, queue);
            this.key = key;
        }
    }
}

