/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.logging.Level;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.operation.projection.AzimuthalEquidistant;
import org.geotools.referencing.operation.projection.LambertAzimuthalEqualArea;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class EnvelopeReprojector {
    EnvelopeReprojector() {
    }

    static GeneralEnvelope transform(CoordinateOperation operation, Envelope envelope) throws TransformException {
        CoordinateReferenceSystem crs;
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (crs = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(crs, sourceCRS)) {
            throw new MismatchedReferenceSystemException(Errors.format((int)92));
        }
        MathTransform mt = operation.getMathTransform();
        GeneralDirectPosition centerPt = new GeneralDirectPosition(mt.getTargetDimensions());
        GeneralEnvelope transformed = CRS.transform(mt, envelope, centerPt);
        EnvelopeReprojector.expandOnAxisExtremCrossing(envelope, sourceCRS, mt, transformed);
        CoordinateReferenceSystem targetCRS = operation.getTargetCRS();
        if (targetCRS == null) {
            return transformed;
        }
        MapProjection sourceProjection = CRS.getMapProjection(sourceCRS);
        GeneralEnvelope generalEnvelope = EnvelopeReprojector.toGeneralEnvelope(envelope);
        EnvelopeReprojector.expandOnPolarOrigin(sourceCRS, mt, transformed, targetCRS, sourceProjection, generalEnvelope);
        MapProjection targetProjection = CRS.getMapProjection(targetCRS);
        if (targetProjection instanceof PolarStereographic && sourceCRS instanceof GeographicCRS) {
            EnvelopeReprojector.expandOnPolarQuadrands(envelope, sourceCRS, mt, transformed, generalEnvelope);
        }
        transformed.setCoordinateReferenceSystem(targetCRS);
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null) {
            return transformed;
        }
        GeneralEnvelope transformedSingularities = EnvelopeReprojector.expandSingularityPoints(mt, centerPt, transformed, generalEnvelope, targetCS);
        if (transformedSingularities != null) {
            return transformedSingularities;
        }
        if (targetProjection != null) {
            EnvelopeReprojector.getProjectionCenterLonLat(targetCRS, centerPt);
            if (EnvelopeReprojector.isPole(centerPt, DefaultGeographicCRS.WGS84)) {
                EnvelopeReprojector.includePoles(envelope, sourceCRS, centerPt, transformed, targetCRS, targetProjection);
            }
            if (targetProjection instanceof AzimuthalEquidistant.Abstract) {
                EnvelopeReprojector.expandOnAntimeridian(envelope, sourceCRS, centerPt, transformed, targetCRS);
            }
        }
        return transformed;
    }

    private static void expandOnAntimeridian(Envelope envelope, CoordinateReferenceSystem sourceCRS, GeneralDirectPosition centerPt, GeneralEnvelope transformed, CoordinateReferenceSystem targetCRS) {
        EnvelopeReprojector.getProjectionCenterLonLat(targetCRS, centerPt);
        try {
            Envelope geoEnvelope;
            MathTransform geoToTarget;
            if (sourceCRS instanceof GeographicCRS) {
                geoToTarget = CRS.findMathTransform(sourceCRS, targetCRS);
                geoEnvelope = envelope;
            } else {
                MathTransform mtWgs84 = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
                geoToTarget = CRS.findMathTransform(DefaultGeographicCRS.WGS84, targetCRS);
                geoEnvelope = CRS.transform(mtWgs84, envelope, null);
            }
            double nagativeMeridian = -centerPt.getOrdinate(1);
            if (geoEnvelope.getMinimum(1) <= nagativeMeridian && geoEnvelope.getMaximum(1) >= nagativeMeridian) {
                EnvelopeReprojector.expandOnMeridian(transformed, geoToTarget, geoEnvelope, nagativeMeridian - 1.0E-6, 50);
                EnvelopeReprojector.expandOnMeridian(transformed, geoToTarget, geoEnvelope, nagativeMeridian + 1.0E-6, 50);
            }
        }
        catch (FactoryException | TransformException e) {
            CRS.LOGGER.log(Level.FINE, "Failed to transform from source to WGS84 to further enlarge the envelope on extreme points, proceeding without expansion", e);
        }
    }

    private static void includePoles(Envelope envelope, CoordinateReferenceSystem sourceCRS, GeneralDirectPosition centerPt, GeneralEnvelope transformed, CoordinateReferenceSystem targetCRS, MapProjection targetProjection) {
        try {
            Envelope geoEnvelope;
            MathTransform geoToTarget;
            if (sourceCRS instanceof GeographicCRS) {
                geoToTarget = CRS.findMathTransform(sourceCRS, targetCRS);
                geoEnvelope = envelope;
            } else {
                MathTransform mtWgs84 = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
                geoToTarget = CRS.findMathTransform(DefaultGeographicCRS.WGS84, targetCRS);
                geoEnvelope = CRS.transform(mtWgs84, envelope, null);
            }
            EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
            if (targetProjection instanceof PolarStereographic || targetProjection instanceof LambertAzimuthalEqualArea) {
                centerPt.setOrdinate(0, EnvelopeReprojector.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                centerPt.setOrdinate(0, EnvelopeReprojector.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                centerPt.setOrdinate(0, EnvelopeReprojector.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                EnvelopeReprojector.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
            }
        }
        catch (FactoryException | TransformException e) {
            CRS.LOGGER.log(Level.FINE, "Failed to transform from source to WGS84 to further enlarge the envelope on extreme points, proceeding without expansion", e);
        }
    }

    private static GeneralEnvelope expandSingularityPoints(MathTransform mt, GeneralDirectPosition centerPt, GeneralEnvelope transformed, GeneralEnvelope generalEnvelope, CoordinateSystem targetCS) {
        DirectPosition sourcePt = null;
        GeneralDirectPosition targetPt = null;
        int dimension = targetCS.getDimension();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            if (axis == null) continue;
            boolean testMax = false;
            do {
                double extremum;
                double d = extremum = testMax ? axis.getMaximumValue() : axis.getMinimumValue();
                if (Double.isInfinite(extremum) || Double.isNaN(extremum)) continue;
                if (targetPt == null) {
                    try {
                        mt = mt.inverse();
                    }
                    catch (NoninvertibleTransformException exception) {
                        if (dimension >= mt.getSourceDimensions()) {
                            CRS.unexpectedException("transform", (Exception)((Object)exception));
                        }
                        return transformed;
                    }
                    targetPt = new GeneralDirectPosition(mt.getSourceDimensions());
                    for (int j = 0; j < dimension; ++j) {
                        targetPt.setOrdinate(j, centerPt.getOrdinate(j));
                    }
                }
                targetPt.setOrdinate(i, extremum);
                try {
                    sourcePt = mt.transform(targetPt, sourcePt);
                }
                catch (Exception e) {
                    continue;
                }
                if (!generalEnvelope.contains(sourcePt)) continue;
                transformed.add(targetPt);
            } while (testMax = !testMax);
            if (targetPt == null) continue;
            targetPt.setOrdinate(i, centerPt.getOrdinate(i));
        }
        return null;
    }

    private static void expandOnPolarQuadrands(Envelope envelope, CoordinateReferenceSystem sourceCRS, MathTransform mt, GeneralEnvelope transformed, GeneralEnvelope generalEnvelope) throws TransformException {
        CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
        for (int i = 0; i < sourceCS.getDimension(); ++i) {
            int lon;
            CoordinateSystemAxis axis = sourceCS.getAxis(i);
            if (!CRS.equalsIgnoreMetadata(DefaultCoordinateSystemAxis.LONGITUDE, axis)) continue;
            double minLon = envelope.getMinimum(i);
            double maxLon = envelope.getMaximum(i);
            DirectPosition lower = generalEnvelope.getLowerCorner();
            DirectPosition upper = generalEnvelope.getUpperCorner();
            DirectPosition2D dest = new DirectPosition2D();
            if (maxLon - minLon >= 360.0) {
                for (lon = -180; lon <= 180; lon += 90) {
                    EnvelopeReprojector.addLowerUpperPoints(mt, transformed, i, lower, upper, dest, lon);
                }
                continue;
            }
            for (lon = -180; lon <= 180; lon += 90) {
                if (!(minLon < (double)lon) || !(maxLon > (double)lon)) continue;
                EnvelopeReprojector.addLowerUpperPoints(mt, transformed, i, lower, upper, dest, lon);
            }
        }
    }

    private static void expandOnPolarOrigin(CoordinateReferenceSystem sourceCRS, MathTransform mt, GeneralEnvelope transformed, CoordinateReferenceSystem targetCRS, MapProjection sourceProjection, GeneralEnvelope generalEnvelope) throws TransformException {
        ParameterValue fn;
        double originY;
        ParameterValue fe;
        double originX;
        DirectPosition2D origin;
        if ((sourceProjection instanceof PolarStereographic || sourceProjection instanceof LambertAzimuthalEqualArea) && EnvelopeReprojector.isPole(origin = new DirectPosition2D(originX = (fe = sourceProjection.getParameterValues().parameter(MapProjection.AbstractProvider.FALSE_EASTING.getName().getCode())).doubleValue(), originY = (fn = sourceProjection.getParameterValues().parameter(MapProjection.AbstractProvider.FALSE_NORTHING.getName().getCode())).doubleValue()), sourceCRS)) {
            if (generalEnvelope.contains(origin)) {
                if (targetCRS instanceof GeographicCRS) {
                    DirectPosition lowerCorner = transformed.getLowerCorner();
                    if (CRS.getAxisOrder(targetCRS) == CRS.AxisOrder.NORTH_EAST) {
                        lowerCorner.setOrdinate(1, -180.0);
                        transformed.add(lowerCorner);
                        lowerCorner.setOrdinate(1, 180.0);
                        transformed.add(lowerCorner);
                    } else {
                        lowerCorner.setOrdinate(0, -180.0);
                        transformed.add(lowerCorner);
                        lowerCorner.setOrdinate(0, 180.0);
                        transformed.add(lowerCorner);
                    }
                } else {
                    DirectPosition lc = transformed.getLowerCorner();
                    DirectPosition uc = transformed.getUpperCorner();
                    for (int j = -180; j < 180; ++j) {
                        EnvelopeReprojector.expandEnvelopeByLongitude(j, lc, transformed, targetCRS);
                        EnvelopeReprojector.expandEnvelopeByLongitude(j, uc, transformed, targetCRS);
                    }
                }
            } else {
                DirectPosition uc;
                DirectPosition lc;
                if (generalEnvelope.getMinimum(0) < originX && generalEnvelope.getMaximum(0) > originX) {
                    lc = generalEnvelope.getLowerCorner();
                    lc.setOrdinate(0, originX);
                    mt.transform(lc, lc);
                    transformed.add(lc);
                    uc = generalEnvelope.getUpperCorner();
                    uc.setOrdinate(0, originX);
                    mt.transform(uc, uc);
                    transformed.add(uc);
                }
                if (generalEnvelope.getMinimum(1) < originY && generalEnvelope.getMaximum(1) > originY) {
                    lc = generalEnvelope.getLowerCorner();
                    lc.setOrdinate(1, originY);
                    mt.transform(lc, lc);
                    transformed.add(lc);
                    uc = generalEnvelope.getUpperCorner();
                    uc.setOrdinate(1, originY);
                    mt.transform(uc, uc);
                    transformed.add(uc);
                }
            }
        }
    }

    private static void expandOnAxisExtremCrossing(Envelope envelope, CoordinateReferenceSystem sourceCRS, MathTransform mt, GeneralEnvelope transformed) throws TransformException {
        CoordinateSystem cs;
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null) {
            GeneralDirectPosition sourcePt = null;
            DirectPosition targetPt = null;
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                boolean b2;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null) continue;
                double min = envelope.getMinimum(i);
                double max = envelope.getMaximum(i);
                double v1 = axis.getMinimumValue();
                double v2 = axis.getMaximumValue();
                boolean b1 = v1 > min && v1 < max;
                boolean bl = b2 = v2 > min && v2 < max;
                if (!b1 && !b2) continue;
                if (sourcePt == null) {
                    sourcePt = new GeneralDirectPosition(dimension);
                    for (int j = 0; j < dimension; ++j) {
                        sourcePt.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (b1) {
                    sourcePt.setOrdinate(i, v1);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                if (b2) {
                    sourcePt.setOrdinate(i, v2);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                sourcePt.setOrdinate(i, envelope.getMedian(i));
            }
        }
    }

    private static void expandOnMeridian(GeneralEnvelope target, MathTransform geoToTarget, Envelope geoEnvelope, double antimeridian, int numPoints) throws TransformException {
        double minLon = geoEnvelope.getMinimum(0);
        double maxLon = geoEnvelope.getMaximum(0);
        double[] points = new double[numPoints * 2];
        double lon = minLon;
        double delta = (maxLon - minLon) / (double)(numPoints - 1);
        int i = 0;
        while (i < points.length) {
            points[i++] = lon;
            points[i++] = antimeridian;
            lon = minLon + delta * (double)i / 2.0;
        }
        geoToTarget.transform(points, 0, points, 0, numPoints);
        DirectPosition2D dp = new DirectPosition2D();
        int i2 = 0;
        while (i2 < points.length) {
            dp.setOrdinate(0, points[i2++]);
            dp.setOrdinate(1, points[i2++]);
            target.add(dp);
        }
    }

    private static void addLowerUpperPoints(MathTransform mt, GeneralEnvelope transformed, int axis, DirectPosition lower, DirectPosition upper, DirectPosition dest, double ordinate) throws TransformException {
        lower.setOrdinate(axis, ordinate);
        mt.transform(lower, dest);
        transformed.add(dest);
        upper.setOrdinate(axis, ordinate);
        mt.transform(upper, dest);
        transformed.add(dest);
    }

    private static GeneralEnvelope toGeneralEnvelope(Envelope envelope) {
        GeneralEnvelope generalEnvelope = envelope instanceof GeneralEnvelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
        return generalEnvelope;
    }

    private static boolean isPole(DirectPosition point, CoordinateReferenceSystem crs) {
        GeographicCRS geographic;
        DirectPosition2D result;
        block5: {
            result = new DirectPosition2D();
            try {
                ProjectedCRS projectedCRS = CRS.getProjectedCRS(crs);
                if (projectedCRS != null) {
                    geographic = projectedCRS.getBaseCRS();
                    MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)projectedCRS, (CoordinateReferenceSystem)geographic);
                    mt.transform(point, (DirectPosition)result);
                    break block5;
                }
                if (crs instanceof GeographicCRS) {
                    result = point;
                    geographic = (GeographicCRS)crs;
                    break block5;
                }
                return false;
            }
            catch (MismatchedDimensionException | FactoryException | TransformException e) {
                return false;
            }
        }
        double EPS = 1.0E-6;
        if (CRS.getAxisOrder((CoordinateReferenceSystem)geographic) == CRS.AxisOrder.NORTH_EAST) {
            return Math.abs(result.getOrdinate(0) - 90.0) < 1.0E-6 || Math.abs(result.getOrdinate(0) + 90.0) < 1.0E-6;
        }
        return Math.abs(result.getOrdinate(1) - 90.0) < 1.0E-6 || Math.abs(result.getOrdinate(1) + 90.0) < 1.0E-6;
    }

    private static void expandEnvelopeByLongitude(double longitude, DirectPosition input, GeneralEnvelope transformed, CoordinateReferenceSystem sourceCRS) {
        try {
            MathTransform mt = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
            DirectPosition2D pos = new DirectPosition2D(sourceCRS);
            mt.transform(input, (DirectPosition)pos);
            pos.setOrdinate(0, longitude);
            mt.inverse().transform((DirectPosition)pos, (DirectPosition)pos);
            transformed.add(pos);
        }
        catch (Exception e) {
            CRS.LOGGER.log(Level.FINER, "Tried to expand target envelope to include longitude " + longitude + " but failed. This is not necesseraly and issue, this is a best effort attempt to handle the polar stereographic pole singularity during reprojection", e);
        }
    }

    private static GeneralDirectPosition getProjectionCenterLonLat(CoordinateReferenceSystem crs, GeneralDirectPosition centerPt) {
        centerPt.setOrdinate(0, 0.0);
        centerPt.setOrdinate(1, 0.0);
        MapProjection projection = CRS.getMapProjection(crs);
        if (projection == null) {
            return centerPt;
        }
        for (GeneralParameterValue gpv : projection.getParameterValues().values()) {
            if (!(gpv instanceof ParameterValue)) continue;
            ParameterValue pv = (ParameterValue)gpv;
            ReferenceIdentifier pvName = pv.getDescriptor().getName();
            if (MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().equals(pvName)) {
                centerPt.setOrdinate(1, pv.doubleValue());
                continue;
            }
            if (MapProjection.AbstractProvider.LATITUDE_OF_CENTRE.getName().equals(pvName)) {
                centerPt.setOrdinate(1, pv.doubleValue());
                continue;
            }
            if (MapProjection.AbstractProvider.LONGITUDE_OF_CENTRE.getName().equals(pvName)) {
                centerPt.setOrdinate(0, pv.doubleValue());
                continue;
            }
            if (!MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().equals(pvName)) continue;
            centerPt.setOrdinate(0, pv.doubleValue());
        }
        return centerPt;
    }

    private static void expandEnvelopeOnExtremePoints(GeneralDirectPosition centerPt, GeneralEnvelope transformed, MathTransform geoToTarget, Envelope geoEnvelope) throws TransformException {
        double centerLat;
        GeneralDirectPosition workPoint = new GeneralDirectPosition(centerPt.getDimension());
        double centerLon = centerPt.getOrdinate(0);
        double minLon = geoEnvelope.getMinimum(0);
        double maxLon = geoEnvelope.getMaximum(0);
        double minLat = geoEnvelope.getMinimum(1);
        double maxLat = geoEnvelope.getMaximum(1);
        if (minLon <= centerLon && centerLon <= maxLon) {
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, centerLon, minLat);
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, centerLon, maxLat);
        }
        if (minLat <= (centerLat = centerPt.getOrdinate(1)) && centerLat <= maxLat) {
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, minLon, centerLat);
            EnvelopeReprojector.includeTransformedPoint(transformed, geoToTarget, workPoint, maxLon, centerLat);
        }
    }

    private static void includeTransformedPoint(GeneralEnvelope envelope, MathTransform mt, GeneralDirectPosition workPoint, double x, double y) throws TransformException {
        workPoint.setOrdinate(0, x);
        workPoint.setOrdinate(1, y);
        mt.transform((DirectPosition)workPoint, (DirectPosition)workPoint);
        envelope.add(workPoint);
    }

    private static double rollLongitude(double x) {
        double rolled = x - (double)((int)(x + Math.signum(x) * 180.0) / 360) * 360.0;
        return rolled;
    }
}

