/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.base64;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToolBar;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import org.apache.commons.io.FileUtils;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.api.Mapton;
import org.mapton.api.report.MEditorSystem;
import org.mapton.api.report.MSplitNavSettings;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.dialogs.NbMessage;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.LogPanel;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class Base64Editor
extends MEditorSystem {
    private BorderPane mBorderPane;
    private final ResourceBundle mBundle = NbBundle.getBundle(Base64Editor.class);
    private final LogPanel mPreviewLogPanel = new LogPanel();
    private final TextArea mSourceTextArea = new TextArea();

    public Base64Editor() {
        this.getSplitNavSettings().setTitleMode(MSplitNavSettings.TitleMode.NAME);
    }

    public String getName() {
        return "Base64";
    }

    public Node getNode() {
        if (this.mBorderPane == null) {
            this.initToolBar();
            this.createUI();
            this.initListeners();
        }
        return this.mBody;
    }

    private void createUI() {
        this.mSourceTextArea.setPromptText(this.mBundle.getString("prompt_source"));
        this.mSourceTextArea.setFont(Font.font((String)"monospaced"));
        this.mSourceTextArea.textProperty().addListener((observable, oldValue, newValue) -> this.encode());
        GridPane gridPane = new GridPane();
        gridPane.addRow(0, new Node[]{this.mSourceTextArea, this.mPreviewLogPanel});
        FxHelper.autoSizeColumn((GridPane)gridPane, (int)2);
        this.mPreviewLogPanel.setWrapText(true);
        this.mBorderPane = new BorderPane((Node)gridPane);
        gridPane.prefHeightProperty().bind((ObservableValue)this.mBorderPane.heightProperty());
        this.mSourceTextArea.prefHeightProperty().bind((ObservableValue)gridPane.heightProperty());
        this.mNotificationPane.setContent((Node)this.mBorderPane);
    }

    private void decode() {
        try {
            byte[] bytesIn = this.mSourceTextArea.getText().getBytes("utf-8");
            byte[] bytesOut = Base64.getDecoder().decode(bytesIn);
            String result = new String(bytesOut, "utf-8");
            this.mPreviewLogPanel.setText(result);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException ex) {
            NbMessage.error((String)Dict.Dialog.ERROR.toString(), (String)ex.getMessage());
        }
    }

    private void encode() {
        try {
            byte[] bytesIn = this.mSourceTextArea.getText().getBytes("utf-8");
            byte[] bytesOut = Base64.getEncoder().encode(bytesIn);
            String result = new String(bytesOut, "utf-8");
            this.mPreviewLogPanel.setText(result);
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initListeners() {
        this.mSourceTextArea.setOnDragOver(dragEvent -> {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragboard.hasFiles()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.mSourceTextArea.setOnDragDropped(event -> {
            try {
                File file = (File)event.getDragboard().getFiles().get(0);
                String s = FileUtils.readFileToString((File)file, (String)"utf-8");
                this.mSourceTextArea.setText(s);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    private void initToolBar() {
        Action clearAction = new Action(Dict.CLEAR.toString(), event -> this.mSourceTextArea.clear());
        clearAction.setGraphic((Node)MaterialIcon._Content.CLEAR.getImageView(Mapton.getIconSizeToolBarInt(), Mapton.getThemeForegroundColor()));
        Action encodeAction = new Action(Dict.ENCODE.toString(), event -> this.encode());
        encodeAction.setGraphic((Node)MaterialIcon._Navigation.CHEVRON_RIGHT.getImageView(Mapton.getIconSizeToolBarInt(), Mapton.getThemeForegroundColor()));
        Action decodeAction = new Action(Dict.DECODE.toString(), event -> this.decode());
        decodeAction.setGraphic((Node)MaterialIcon._Navigation.CHEVRON_LEFT.getImageView(Mapton.getIconSizeToolBarInt(), Mapton.getThemeForegroundColor()));
        Action copyAction = new Action(Dict.COPY.toString(), event -> SystemHelper.copyToClipboard((String)this.mPreviewLogPanel.getText()));
        copyAction.setGraphic((Node)MaterialIcon._Content.CONTENT_COPY.getImageView(Mapton.getIconSizeToolBarInt(), Mapton.getThemeForegroundColor()));
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(encodeAction);
        actions.add(decodeAction);
        actions.add(ActionUtils.ACTION_SEPARATOR);
        actions.add(copyAction);
        actions.add(ActionUtils.ACTION_SPAN);
        actions.add(clearAction);
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        FxHelper.slimToolBar((ToolBar)toolBar);
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        this.mSplitNavSetting.getToolBarItems().setAll((Collection)toolBar.getItems());
    }
}

