/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.google;

import com.dlsc.gmapsfx.GoogleMapView;
import com.dlsc.gmapsfx.javascript.object.LatLong;
import com.dlsc.gmapsfx.javascript.object.LatLongBounds;
import com.dlsc.gmapsfx.service.geocoding.GeocoderGeometry;
import com.dlsc.gmapsfx.service.geocoding.GeocoderStatus;
import com.dlsc.gmapsfx.service.geocoding.GeocodingResult;
import com.dlsc.gmapsfx.service.geocoding.GeocodingService;
import com.dlsc.gmapsfx.service.geocoding.GeocodingServiceCallback;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import org.mapton.api.MBookmark;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.google_maps.api.GoogleMaps;
import org.openide.util.Exceptions;

public class GoogleSearchEngine {
    boolean mDone = false;

    public GoogleSearchEngine() {
        GoogleMapView googleMapView = new GoogleMapView(Locale.getDefault().getLanguage(), GoogleMaps.getKey());
    }

    public String getName() {
        return "Google Maps";
    }

    public ArrayList<MBookmark> getResults(String searchString) {
        ArrayList<MBookmark> bookmarks = new ArrayList<MBookmark>();
        this.mDone = false;
        GeocodingServiceCallback callback = (results, status) -> {
            if (status != GeocoderStatus.OK) {
                this.mDone = true;
                return;
            }
            for (GeocodingResult result : results) {
                GeocoderGeometry geometry = result.getGeometry();
                LatLong latLon = geometry.getLocation();
                MBookmark bookmark = new MBookmark();
                bookmark.setName(result.getFormattedAddress());
                bookmark.setLatitude(Double.valueOf(latLon.getLatitude()));
                bookmark.setLongitude(Double.valueOf(latLon.getLongitude()));
                LatLongBounds bounds = geometry.getBounds();
                MLatLon southWest = new MLatLon(bounds.getSouthWest().getLatitude(), bounds.getSouthWest().getLongitude());
                MLatLon northEast = new MLatLon(bounds.getNorthEast().getLatitude(), bounds.getNorthEast().getLongitude());
                MLatLonBox latLonBox = new MLatLonBox(southWest, northEast);
                bookmark.setLatLonBox(latLonBox);
                bookmarks.add(bookmark);
            }
            this.mDone = true;
        };
        Platform.runLater(() -> {
            GeocodingService service = new GeocodingService();
            service.geocode(searchString, callback);
        });
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                Thread.currentThread().interrupt();
            }
        } while (!this.mDone);
        return bookmarks;
    }

    public boolean isInstantSearch() {
        return false;
    }
}

