/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.jxmapviewer2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import org.apache.commons.io.FileUtils;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.TileCache;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.mapton.api.Mapton;
import org.openide.util.Exceptions;
import se.trixon.almond.util.SystemHelper;

public class MapKit
extends JXMapKit {
    private JLabel mCopyrightNoticeLabel;
    private JXMapViewer mMap = this.getMainMap();
    private DefaultTileFactory mTileFactory;
    private TileFactoryInfo mTileFactoryInfo;

    public MapKit() {
        this.init();
        this.mTileFactoryInfo = new OSMTileFactoryInfo();
        this.mTileFactory = new DefaultTileFactory(this.mTileFactoryInfo);
        this.mTileFactory.setThreadPoolSize(2);
        this.mTileFactory.setUserAgent(((Object)((Object)this)).getClass().getName());
        this.mTileFactory.setTileCache(new TileCache(){
            private File mCacheDir;

            public BufferedImage get(URI uri) throws IOException {
                long tileAge;
                File tileFile = this.getCachedFile(uri);
                if (tileFile.isFile() && (tileAge = System.currentTimeMillis() - tileFile.lastModified()) < TimeUnit.DAYS.toMillis(14L)) {
                    try {
                        return ImageIO.read(tileFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.get(uri);
            }

            public void put(URI uri, byte[] bimg, BufferedImage bufferedImage) {
                try {
                    super.put(uri, bimg, bufferedImage);
                    File tileFile = this.getCachedFile(uri);
                    FileUtils.forceMkdirParent((File)tileFile);
                    ImageIO.write((RenderedImage)bufferedImage, "png", tileFile);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (NullPointerException ex) {
                    System.err.println(ex.getMessage());
                }
            }

            private File getCacheDir() {
                if (this.mCacheDir == null) {
                    this.mCacheDir = new File(Mapton.getCacheDir(), "jxmapviewer2");
                }
                return this.mCacheDir;
            }

            private File getCachedFile(URI uri) {
                String uriString = uri.toString().replace("?", "$");
                int beginIndex = uriString.indexOf("//") + 2;
                return new File(this.getCacheDir(), uriString.substring(beginIndex));
            }
        });
        this.setTileFactory((TileFactory)this.mTileFactory);
        try {
            this.mMap.setLoadingImage((Image)ImageIO.read(MapKit.class.getResource("mapton32.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        try {
            this.setCopyrightNotice("<html>&nbsp;\u00a9 <a href=\"\">OpenStreetMap</a> contributors&nbsp;<html>", new URI("https://www.openstreetmap.org/copyright"), gridBagConstraints);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public JLabel getCopyrightNoticeLabel() {
        return this.mCopyrightNoticeLabel;
    }

    public void removeCopyrightNotice() {
        if (this.mCopyrightNoticeLabel != null) {
            this.mMap.remove((Component)this.mCopyrightNoticeLabel);
        }
    }

    public void setCopyrightNotice(String text, final URI uri, GridBagConstraints gridBagConstraints) {
        this.removeCopyrightNotice();
        this.mCopyrightNoticeLabel = new JLabel();
        this.mCopyrightNoticeLabel.setText(text);
        this.mCopyrightNoticeLabel.setForeground(Color.BLACK);
        this.mCopyrightNoticeLabel.setBackground(Color.WHITE);
        this.mCopyrightNoticeLabel.setOpaque(true);
        this.mCopyrightNoticeLabel.setCursor(new Cursor(12));
        this.mCopyrightNoticeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (uri != null && MapKit.this.mCopyrightNoticeLabel.isEnabled()) {
                    SystemHelper.desktopBrowse((String)uri.toString());
                }
            }
        });
        this.mMap.add((Component)this.mCopyrightNoticeLabel, (Object)gridBagConstraints);
    }

    private void init() {
        this.getZoomSlider().setVisible(false);
        this.getZoomInButton().setVisible(false);
        this.getZoomOutButton().setVisible(false);
    }
}

