/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;

public class EqualAreaListVisitor
implements FeatureCalc {
    private Expression expression;
    private Expression areaExpression;
    private int count = 0;
    private int binCount;
    private List<ValueArea> items = new ArrayList<ValueArea>();
    private List<Comparable>[] bins;
    boolean visited = false;
    int countNull = 0;
    int countNaN = 0;

    public EqualAreaListVisitor(Expression expression, Expression areaExpression, int bins) {
        this.expression = expression;
        this.areaExpression = areaExpression;
        this.binCount = bins;
        this.bins = this.createBinsArray(bins);
    }

    public void init(SimpleFeatureCollection collection) {
    }

    @Override
    public CalcResult getResult() {
        if (this.binCount == 0 || this.count == 0) {
            return CalcResult.NULL_RESULT;
        }
        Collections.sort(this.items);
        if (this.binCount > this.count) {
            this.binCount = this.count;
            this.bins = this.createBinsArray(this.binCount);
        }
        double totalArea = this.items.stream().mapToDouble(item -> item.area).sum();
        double avgArea = totalArea / (double)this.binCount;
        ArrayList<Comparable<Object>> currentBin = new ArrayList<Comparable>();
        int binIndex = 0;
        double area = 0.0;
        for (ValueArea valueArea : this.items) {
            currentBin.add(valueArea.value);
            if (!((area += valueArea.area) >= avgArea * (double)(binIndex + 1)) || binIndex >= this.binCount - 1) continue;
            this.bins[binIndex++] = currentBin;
            currentBin = new ArrayList();
        }
        if (currentBin.isEmpty()) {
            --binIndex;
        } else {
            this.bins[binIndex] = currentBin;
        }
        if (binIndex < this.binCount - 1) {
            List<Comparable>[] reduced = this.createBinsArray(binIndex + 1);
            System.arraycopy(this.bins, 0, reduced, 0, binIndex + 1);
            this.bins = reduced;
        }
        return new AbstractCalcResult(){

            @Override
            public Object getValue() {
                return EqualAreaListVisitor.this.bins;
            }
        };
    }

    private List<Comparable>[] createBinsArray(int binCount) {
        ArrayList[] result = new ArrayList[binCount];
        return result;
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        double doubleVal;
        Object value = this.expression.evaluate((Object)feature);
        if (value == null) {
            ++this.countNull;
            return;
        }
        if (value instanceof Double && (Double.isNaN(doubleVal = ((Double)value).doubleValue()) || Double.isInfinite(doubleVal))) {
            ++this.countNaN;
            return;
        }
        ++this.count;
        Double area = (Double)this.areaExpression.evaluate((Object)feature, Double.class);
        Comparable cast = (Comparable)value;
        this.items.add(new ValueArea(cast, area));
    }

    public void reset(int bins) {
        this.binCount = bins;
        this.count = 0;
        this.items = new ArrayList<ValueArea>();
        this.bins = this.createBinsArray(bins);
        this.countNull = 0;
        this.countNaN = 0;
    }

    public int getNaNCount() {
        return this.countNaN;
    }

    public int getNullCount() {
        return this.countNull;
    }

    private static class ValueArea
    implements Comparable<ValueArea> {
        Comparable<Object> value;
        double area;

        public ValueArea(Comparable<Object> value, double area) {
            this.value = value;
            this.area = area;
        }

        @Override
        public int compareTo(ValueArea other) {
            return this.value.compareTo(other.value);
        }

        public String toString() {
            return "ValueArea{value=" + this.value + ", area=" + this.area + "}";
        }
    }
}

