/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Set;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;

public class UniqueCountVisitor
extends UniqueVisitor {
    Integer count = null;

    public UniqueCountVisitor(String attributeTypeName) {
        super(attributeTypeName);
    }

    public UniqueCountVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        super(attributeTypeIndex, type);
    }

    public UniqueCountVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        super(attrName, type);
    }

    public UniqueCountVisitor(Expression expr) {
        super(expr);
    }

    public void setValue(Integer count) {
        this.count = count;
    }

    @Override
    public CalcResult getResult() {
        Integer result;
        Set uniqueValues = this.getUnique();
        if (this.count == null) {
            if (uniqueValues.isEmpty()) {
                return CalcResult.NULL_RESULT;
            }
            result = uniqueValues.size();
        } else {
            result = this.count;
        }
        return new CountVisitor.CountResult(result);
    }
}

