/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.mapton.api.MArea;
import org.mapton.api.MAreaFilterManager;
import org.mapton.api.MDict;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.WWHelper;
import org.openide.util.Exceptions;

public class AreaLayerBundle
extends LayerBundle {
    private final MAreaFilterManager mAreaFilterManager = MAreaFilterManager.getInstance();
    private final RenderableLayer mLayer = new RenderableLayer();

    public AreaLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(2000L);
    }

    private void init() {
        String name = MDict.AREAS.toString();
        this.mLayer.setName(name);
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(name);
        this.mLayer.setEnabled(true);
        this.mLayer.setPickEnabled(true);
        this.setParentLayer((Layer)this.mLayer);
    }

    private void initListeners() {
        this.mAreaFilterManager.getItems().addListener(c -> this.repaint());
        this.mAreaFilterManager.getCheckedItems().addListener(c -> this.repaint());
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            BasicShapeAttributes attrs = new BasicShapeAttributes();
            attrs.setOutlineMaterial(Material.CYAN);
            attrs.setOutlineWidth(3.0);
            attrs.setDrawInterior(false);
            attrs.setDrawOutline(true);
            for (MArea area : this.mAreaFilterManager.getItems()) {
                if (!area.isEnabled()) continue;
                try {
                    SurfacePolyline renderable;
                    Geometry geometry = area.getGeometry();
                    if (geometry instanceof LineString) {
                        LineString lineString = (LineString)geometry;
                        renderable = new SurfacePolyline((ShapeAttributes)attrs, WWHelper.positionsFromGeometry((Geometry)lineString, 0.0));
                        this.mLayer.addRenderable((Renderable)renderable);
                        continue;
                    }
                    if (!(geometry instanceof Polygon)) continue;
                    Polygon polygon = (Polygon)geometry;
                    renderable = new SurfacePolygon((ShapeAttributes)attrs, WWHelper.positionsFromGeometry((Geometry)polygon, 0.0));
                    this.mLayer.addRenderable((Renderable)renderable);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.setDragEnabled(false);
        });
    }
}

