/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.mapton.worldwind.ModuleOptions;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class BackgroundImageOptionsView
extends BorderPane {
    private final Slider mOpacitySlider = new Slider(0.0, 1.0, 1.0);
    private final ModuleOptions mOptions = ModuleOptions.getInstance();

    public BackgroundImageOptionsView() {
        this.createUI();
        this.initStates();
        this.initListeners();
        this.load();
    }

    private void createUI() {
        VBox opacityBox = new VBox(new Node[]{new Label(Dict.OPACITY.toString()), this.mOpacitySlider});
        opacityBox.setPadding(FxHelper.getUIScaledInsets((double)8.0));
        this.setCenter((Node)opacityBox);
    }

    private void initListeners() {
        this.mOpacitySlider.valueProperty().addListener((observable, oldValue, newValue) -> this.mOptions.put("background_image.opacity", this.mOpacitySlider.getValue()));
    }

    private void initStates() {
    }

    private void load() {
        this.mOpacitySlider.setValue(this.mOptions.getDouble("background_image.opacity", new Double[]{1.0}));
    }
}

