/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import org.mapton.api.MCooTrans;
import org.mapton.api.MDict;
import org.mapton.api.MLocalGrid;
import org.mapton.api.MLocalGridManager;
import org.mapton.api.MOptions;
import org.mapton.worldwind.api.LayerBundle;
import se.trixon.almond.util.fx.FxHelper;

public class GridLayerBundle
extends LayerBundle {
    private int mAltitudeMode;
    private BasicShapeAttributes mEquatorAttributes;
    private final BasicShapeAttributes mGridAttributes = new BasicShapeAttributes();
    private final RenderableLayer mLayer = new RenderableLayer();
    private final MLocalGridManager mManager = MLocalGridManager.getInstance();
    private final MOptions mOptions = MOptions.getInstance();
    private BasicShapeAttributes mPolarAttributes;
    private BasicShapeAttributes mTropicAttributes;

    public GridLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.initAttributes();
        this.repaint(0L);
    }

    private void draw(Position pos1, Position pos2, BasicShapeAttributes attributes, String pathType) {
        Path path = new Path(pos1, pos2);
        path.setAttributes((ShapeAttributes)attributes);
        path.setFollowTerrain(true);
        path.setAltitudeMode(this.mAltitudeMode);
        path.setPathType(pathType);
        this.mLayer.addRenderable((Renderable)path);
    }

    private void drawLatitude(double latitude, BasicShapeAttributes attributes) {
        Position pos0 = Position.fromDegrees((double)latitude, (double)0.0);
        Position pos1 = Position.fromDegrees((double)latitude, (double)180.0);
        Position pos2 = Position.fromDegrees((double)latitude, (double)-180.0);
        this.draw(pos0, pos1, attributes, "gov.nasa.worldwind.avkey.Linear");
        this.draw(pos0, pos2, attributes, "gov.nasa.worldwind.avkey.Linear");
    }

    private void drawLongitude(double longitude, BasicShapeAttributes attributes) {
        Position pos0 = Position.fromDegrees((double)0.0, (double)longitude);
        Position pos1 = Position.fromDegrees((double)90.0, (double)longitude);
        Position pos2 = Position.fromDegrees((double)-90.0, (double)longitude);
        this.draw(pos0, pos1, attributes, "gov.nasa.worldwind.avkey.Linear");
        this.draw(pos0, pos2, attributes, "gov.nasa.worldwind.avkey.Linear");
    }

    private void init() {
        this.mLayer.setName(MDict.GRID.toString());
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(MDict.GRID.toString());
        this.mLayer.setPickEnabled(false);
        this.attachTopComponentToLayer("GridTopComponent", (Layer)this.mLayer);
        this.setParentLayer((Layer)this.mLayer);
    }

    private void initAttributes() {
        this.mGridAttributes.setOutlineMaterial(Material.CYAN);
        this.mGridAttributes.setOutlineWidth(0.7);
        this.mGridAttributes.setDrawOutline(true);
        this.mGridAttributes.setOutlineOpacity(0.5);
        this.mEquatorAttributes = (BasicShapeAttributes)this.mGridAttributes.copy();
        this.mEquatorAttributes.setOutlineMaterial(Material.RED);
        this.mEquatorAttributes.setOutlineWidth(3.0);
        this.mTropicAttributes = (BasicShapeAttributes)this.mGridAttributes.copy();
        this.mTropicAttributes.setOutlineMaterial(Material.ORANGE);
        this.mTropicAttributes.setOutlineWidth(2.0);
        this.mPolarAttributes = (BasicShapeAttributes)this.mGridAttributes.copy();
        this.mPolarAttributes.setOutlineMaterial(Material.BLUE);
        this.mPolarAttributes.setOutlineWidth(2.0);
    }

    private void initListeners() {
        this.mOptions.getPreferences().addPreferenceChangeListener(pce -> this.repaint());
        this.mManager.getItems().addListener(c -> this.repaint());
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            int n = this.mAltitudeMode = this.mOptions.is("global_clamp_to_ground", new boolean[0]) ? 1 : 0;
            if (this.mOptions.is("grid.global.plot", new boolean[0])) {
                this.plotGlobal();
            }
            if (this.mOptions.is("grid.local.plot", new boolean[0])) {
                this.plotLocal();
            }
            this.setDragEnabled(false);
        });
    }

    private void plotGlobal() {
        int i;
        if (this.mOptions.is("grid.global.latitudes", new boolean[0])) {
            for (i = -90; i < 90; i += 15) {
                this.drawLatitude(i, this.mGridAttributes);
            }
        }
        if (this.mOptions.is("grid.global.longitudes", new boolean[0])) {
            for (i = -180; i < 180; i += 15) {
                this.drawLongitude(i, i == 0 ? this.mEquatorAttributes : this.mGridAttributes);
            }
        }
        double POLAR = 66.563167;
        double TROPIC = 23.43683;
        if (this.mOptions.is("grid.global.polar_arctic", new boolean[0])) {
            this.drawLatitude(66.563167, this.mPolarAttributes);
        }
        if (this.mOptions.is("grid.global.tropic_cancer", new boolean[0])) {
            this.drawLatitude(23.43683, this.mTropicAttributes);
        }
        if (this.mOptions.is("grid.global.equator", new boolean[0])) {
            this.drawLatitude(0.0, this.mEquatorAttributes);
        }
        if (this.mOptions.is("grid.global.tropic_capricorn", new boolean[0])) {
            this.drawLatitude(-23.43683, this.mTropicAttributes);
        }
        if (this.mOptions.is("grid.global.polar_antarctic", new boolean[0])) {
            this.drawLatitude(-66.563167, this.mPolarAttributes);
        }
    }

    private void plotLocal() {
        ObservableList grids = this.mManager.getItems();
        if (grids != null) {
            for (MLocalGrid grid : grids) {
                if (!grid.isVisible()) continue;
                this.plotLocal(grid);
            }
        }
    }

    private void plotLocal(MLocalGrid grid) {
        Position pos2;
        Position pos1;
        Point2D p2;
        Point2D p1;
        BasicShapeAttributes shapeAttributes = new BasicShapeAttributes();
        shapeAttributes.setDrawOutline(true);
        shapeAttributes.setOutlineWidth(grid.getLineWidth());
        shapeAttributes.setOutlineMaterial(new Material(FxHelper.colorToColor((Color)FxHelper.colorFromHexRGBA((String)grid.getColor()))));
        MCooTrans cooTrans = MCooTrans.getCooTrans((String)grid.getCooTrans());
        String pathType = cooTrans.isOrthogonal() ? "gov.nasa.worldwind.avkey.GreatCircle" : "gov.nasa.worldwind.avkey.Linear";
        double latMin = grid.getLatStart();
        double latMax = grid.getLatStart() + grid.getLatStep() * (double)grid.getLatCount();
        double lonMin = grid.getLonStart();
        double lonMax = grid.getLonStart() + grid.getLonStep() * (double)grid.getLonCount();
        for (int lonCount = 0; lonCount < grid.getLonCount() + 1; ++lonCount) {
            double lon = grid.getLonStart() + (double)lonCount * grid.getLonStep();
            p1 = cooTrans.toWgs84(latMin, lon);
            p2 = cooTrans.toWgs84(latMax, lon);
            pos1 = Position.fromDegrees((double)p1.getY(), (double)p1.getX());
            pos2 = Position.fromDegrees((double)p2.getY(), (double)p2.getX());
            this.draw(pos1, pos2, shapeAttributes, pathType);
        }
        for (int latCount = 0; latCount < grid.getLatCount() + 1; ++latCount) {
            double lat = grid.getLatStart() + (double)latCount * grid.getLatStep();
            p1 = cooTrans.toWgs84(lat, lonMin);
            p2 = cooTrans.toWgs84(lat, lonMax);
            pos1 = Position.fromDegrees((double)p1.getY(), (double)p1.getX());
            pos2 = Position.fromDegrees((double)p2.getY(), (double)p2.getX());
            this.draw(pos1, pos2, shapeAttributes, pathType);
        }
    }
}

