/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import java.util.ArrayList;
import org.mapton.api.Mapton;
import org.mapton.worldwind.api.LayerBundle;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.GlobalStateChangeEvent;

public class IndicatorLayerBundle
extends LayerBundle {
    private GlobalStateChangeEvent mGsce;
    private final RenderableLayer mLayer = new RenderableLayer();

    public IndicatorLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    @Override
    public void populate() {
        this.getLayers().add((Object)this.mLayer);
    }

    private void init() {
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(Dict.INDICATORS.toString());
        this.mLayer.setName(Dict.INDICATORS.toString());
        this.mLayer.setPickEnabled(false);
        this.setParentLayer((Layer)this.mLayer);
    }

    private void initListeners() {
        Mapton.getGlobalState().addListener(gsce -> {
            this.mGsce = gsce;
            this.repaint(0L);
        }, new String[]{"indicator_layer.load"});
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            Object patt0$temp = this.mGsce.getValue();
            if (patt0$temp instanceof Renderable) {
                Renderable renderable = (Renderable)patt0$temp;
                this.mLayer.addRenderable(renderable);
            } else {
                ArrayList arrayList;
                Renderable[] patt1$temp = this.mGsce.getValue();
                if (patt1$temp instanceof Renderable[]) {
                    Renderable[] renderables;
                    for (Renderable renderable : renderables = (Renderable[])patt1$temp) {
                        this.mLayer.addRenderable(renderable);
                    }
                } else if (this.mGsce.getValue() instanceof ArrayList && !(arrayList = (ArrayList)this.mGsce.getValue()).isEmpty() && arrayList.get(0) instanceof Renderable) {
                    for (Renderable renderable : arrayList) {
                        this.mLayer.addRenderable(renderable);
                    }
                }
            }
            this.setDragEnabled(false);
        });
    }
}

