/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.CheckModel;
import org.controlsfx.control.CheckTreeView;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionGroup;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.mapton.api.MActivatable;
import org.mapton.api.MDict;
import org.mapton.api.Mapton;
import org.mapton.api.ui.MOptionsPopOver;
import org.mapton.worldwind.WorldWindowPanel;
import org.mapton.worldwind.api.LayerBundle;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.StringHelper;
import se.trixon.almond.util.fx.DelayedResetRunner;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class LayerView
extends BorderPane
implements MActivatable {
    private CheckModel<TreeItem<Layer>> mCheckModel;
    private ContextMenu mContextMenu;
    private final Preferences mExpandedPreferences;
    private TextField mFilterTextField;
    private final Set<Layer> mLayerEnabledListenerSet;
    private final Map<String, CheckBoxTreeItem<Layer>> mLayerParents;
    private final HashMap<Layer, CheckBoxTreeCell<Layer>> mLayerToCheckBoxTreeCell = new HashMap();
    private WorldWindowPanel mMap;
    private Action mOptionsAction;
    private MOptionsPopOver mOptionsPopOver;
    private CheckBoxTreeItem<Layer> mRootItem;
    private ToolBar mToolBar;
    private final Set<CheckBoxTreeItem<Layer>> mTreeItemExpanderSet;
    private final Set<CheckBoxTreeItem<Layer>> mTreeItemListenerSet;
    private CheckTreeView<Layer> mTreeView;
    private final Preferences mVisibilityPreferences = NbPreferences.forModule(LayerView.class).node("layer_visibility");

    public static LayerView getInstance() {
        return Holder.INSTANCE;
    }

    private LayerView() {
        this.mExpandedPreferences = NbPreferences.forModule(LayerView.class).node("layer_group_expanded");
        this.mLayerParents = new TreeMap<String, CheckBoxTreeItem<Layer>>();
        this.mLayerEnabledListenerSet = Collections.synchronizedSet(new HashSet());
        this.mTreeItemListenerSet = Collections.synchronizedSet(new HashSet());
        this.mTreeItemExpanderSet = Collections.synchronizedSet(new HashSet());
        Platform.runLater(() -> this.createUI());
    }

    public void activate() {
        this.mFilterTextField.requestFocus();
    }

    synchronized void refresh(WorldWindowPanel map) {
        if (this.mMap == null) {
            this.mMap = map;
            DelayedResetRunner delayedResetRunner = new DelayedResetRunner(100, () -> this.refresh(map));
            this.mMap.getCustomLayers().addListener(change -> delayedResetRunner.reset());
            return;
        }
        this.mRootItem.getChildren().clear();
        this.mTreeItemListenerSet.clear();
        TreeMap<String, CheckBoxTreeItem> layerParents = new TreeMap<String, CheckBoxTreeItem>();
        SortedList sortedLayers = this.mMap.getCustomLayers().sorted((o1, o2) -> o1.getName().compareTo(o2.getName()));
        ObservableList filteredLayers = FXCollections.observableArrayList();
        for (Layer layer : sortedLayers) {
            boolean validFilter;
            boolean hidden;
            Object hiddenValue = layer.getValue("mapton.layer.hide_from_manager");
            boolean bl = hidden = hiddenValue != null;
            if (hidden) {
                hidden = BooleanUtils.toBoolean((String)layer.getValue("mapton.layer.hide_from_manager").toString());
            }
            String filter = this.mFilterTextField.getText();
            boolean bl2 = validFilter = StringHelper.matchesSimpleGlob((String)this.getCategory(layer), (String)filter, (boolean)true, (boolean)true) || StringHelper.matchesSimpleGlob((String)layer.getName(), (String)filter, (boolean)true, (boolean)true);
            if (hidden || !validFilter) continue;
            filteredLayers.add((Object)layer);
        }
        for (Layer layer : filteredLayers) {
            CheckBoxTreeItem layerTreeItem = new CheckBoxTreeItem((Object)layer);
            String category = this.getCategory(layer);
            CheckBoxTreeItem parent = layerParents.computeIfAbsent(category, k -> this.getParent(this.mRootItem, category));
            parent.getChildren().add((Object)layerTreeItem);
        }
        this.mLayerParents.clear();
        this.mLayerParents.putAll(this.mLayerParents);
        this.postPopulate(this.mRootItem);
        Mapton.getExecutionFlow().executeWhenReady("execution_flow_map_ww_initialized", () -> FxHelper.runLater(() -> {
            this.restoreLayerVisibility(this.mRootItem);
            this.setCenter((Node)this.mTreeView);
        }));
        this.mTreeItemExpanderSet.forEach(checkBoxTreeItem -> checkBoxTreeItem.setExpanded(true));
        if (this.getCenter() != this.mTreeView) {
            this.initListeners();
        }
    }

    private void createUI() {
        RenderableLayer rootLayer = new RenderableLayer();
        rootLayer.setName("");
        this.mRootItem = new CheckBoxTreeItem((Object)rootLayer);
        this.mTreeView = new CheckTreeView(this.mRootItem);
        this.mCheckModel = this.mTreeView.getCheckModel();
        this.mTreeView.setShowRoot(false);
        this.mTreeView.setCellFactory(param -> new LayerTreeCell());
        this.mOptionsPopOver = new MOptionsPopOver();
        this.mOptionsPopOver.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
        this.mOptionsPopOver.setOnShowing(windowEvent -> {
            LayerBundle layerBundle = (LayerBundle)((Layer)this.getSelectedTreeItem().getValue()).getValue("layerBundle");
            this.mOptionsPopOver.setContentNode(layerBundle.getOptionsView());
        });
        this.mOptionsAction = this.mOptionsPopOver.getAction();
        this.mOptionsAction.setDisabled(true);
        MaskerPane maskerPane = new MaskerPane();
        maskerPane.setText(MDict.LOADING_LAYERS.toString());
        maskerPane.setProgress(-1.0);
        this.setCenter((Node)maskerPane);
        this.mFilterTextField = TextFields.createClearableTextField();
        this.mFilterTextField.setPromptText(Dict.LAYER_SEARCH.toString());
        this.mFilterTextField.setMinWidth(20.0);
        int iconSize = (int)((double)Mapton.getIconSizeToolBarInt() * 0.8);
        ActionGroup selectActionGroup = new ActionGroup(Dict.SHOW.toString(), (Node)MaterialIcon._Image.REMOVE_RED_EYE.getImageView(iconSize), new Action[]{new Action(Dict.SHOW.toString(), actionEvent -> this.setChecked(this.getSelectedCheckBoxTreeItem(), true)), new Action(Dict.HIDE.toString(), actionEvent -> this.setChecked(this.getSelectedCheckBoxTreeItem(), false)), ActionUtils.ACTION_SEPARATOR, new Action(Dict.EXPAND.toString(), actionEvent -> this.setExpanded(this.getSelectedCheckBoxTreeItem(), true)), new Action(Dict.COLLAPSE.toString(), actionEvent -> this.setExpanded(this.getSelectedCheckBoxTreeItem(), false))});
        List<Action> actions = Arrays.asList(selectActionGroup, this.mOptionsAction);
        this.mToolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)this.mToolBar.getItems().stream(), (double)iconSize);
        FxHelper.undecorateButtons((Stream)this.mToolBar.getItems().stream());
        FxHelper.slimToolBar((ToolBar)this.mToolBar);
        BorderPane topBorderPane = new BorderPane((Node)this.mFilterTextField);
        topBorderPane.setRight((Node)this.mToolBar);
        this.mToolBar.setMinWidth((double)iconSize * 4.8);
        this.setTop((Node)topBorderPane);
        MenuItem optionsItem = new MenuItem(Dict.OPTIONS.toString());
        optionsItem.disableProperty().bind((ObservableValue)this.mOptionsAction.disabledProperty());
        optionsItem.setOnAction(actionEvent -> this.mOptionsAction.handle(new ActionEvent((Object)this.getOptionsToolBarButton(), (EventTarget)this)));
        this.mContextMenu = new ContextMenu(new MenuItem[]{optionsItem});
    }

    private String getCategory(Layer layer) {
        return StringUtils.defaultString((String)((String)layer.getValue("mapton.layer.category")));
    }

    private String getLayerPath(Layer layer) {
        return "%s/%s".formatted(this.getCategory(layer), layer.getName());
    }

    private ButtonBase getOptionsToolBarButton() {
        return FxHelper.getButtonForAction((Action)this.mOptionsAction, (ObservableList)this.mToolBar.getItems());
    }

    private CheckBoxTreeItem<Layer> getParent(CheckBoxTreeItem<Layer> parent, String category) {
        String[] categorySegments = StringUtils.split((String)category, (String)"/");
        StringBuilder sb = new StringBuilder();
        for (String segment : categorySegments) {
            sb.append(segment);
            String path = sb.toString();
            if (this.mLayerParents.containsKey(path)) {
                parent = this.mLayerParents.get(path);
            } else {
                RenderableLayer layer = new RenderableLayer();
                layer.setValue("mapton.layer.category", (Object)path);
                layer.setName(segment);
                ObservableList observableList = parent.getChildren();
                parent = this.mLayerParents.computeIfAbsent(sb.toString(), k -> new CheckBoxTreeItem((Object)layer));
                observableList.add((Object)parent);
            }
            sb.append("/");
        }
        return parent;
    }

    private CheckBoxTreeItem<Layer> getSelectedCheckBoxTreeItem() {
        return (CheckBoxTreeItem)this.mTreeView.getSelectionModel().getSelectedItem();
    }

    private TreeItem<Layer> getSelectedTreeItem() {
        return (TreeItem)this.mTreeView.getSelectionModel().getSelectedItem();
    }

    private void initListeners() {
        this.mTreeView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            try {
                LayerBundle layerBundle = (LayerBundle)((Layer)this.getSelectedTreeItem().getValue()).getValue("layerBundle");
                Node optionsNode = layerBundle.getOptionsView();
                this.mOptionsAction.setDisabled(optionsNode == null);
            }
            catch (Exception e) {
                this.mOptionsAction.setDisabled(true);
            }
        });
        this.mFilterTextField.textProperty().addListener((observable, oldValue, newValue) -> this.refresh(this.mMap));
        this.mCheckModel.getCheckedItems().addListener(c -> {
            LayerView layerView = this;
            synchronized (layerView) {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().forEach(treeItem -> {
                            if (!this.isCategoryTreeItem((TreeItem<Layer>)treeItem) && !((Layer)treeItem.getValue()).isEnabled()) {
                                ((Layer)treeItem.getValue()).setEnabled(true);
                                this.mVisibilityPreferences.putBoolean(this.getLayerPath((Layer)treeItem.getValue()), true);
                            }
                        });
                        continue;
                    }
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().forEach(treeItem -> {
                        if (!this.isCategoryTreeItem((TreeItem<Layer>)treeItem) && ((Layer)treeItem.getValue()).isEnabled()) {
                            ((Layer)treeItem.getValue()).setEnabled(false);
                            this.mVisibilityPreferences.putBoolean(this.getLayerPath((Layer)treeItem.getValue()), false);
                        }
                    });
                }
            }
        });
        Mapton.getGlobalState().addListener(evt -> Platform.runLater(() -> this.setChecked(this.mRootItem, false)), new String[]{"map.clear.all.layers"});
    }

    private boolean isCategoryTreeItem(TreeItem<Layer> treeItem) {
        return !treeItem.getChildren().isEmpty();
    }

    private void postPopulate(CheckBoxTreeItem<Layer> treeItem) {
        Layer layer = (Layer)treeItem.getValue();
        if (this.isCategoryTreeItem((TreeItem<Layer>)treeItem)) {
            String path = this.getCategory(layer);
            if (this.mExpandedPreferences.getBoolean(path, false)) {
                this.mTreeItemExpanderSet.add(treeItem);
            }
            if (!this.mTreeItemListenerSet.contains(treeItem)) {
                treeItem.expandedProperty().addListener((observable, oldValue, newValue) -> this.mExpandedPreferences.putBoolean(path, (boolean)newValue));
                this.mTreeItemListenerSet.add(treeItem);
            }
            Comparator c1 = (o1, o2) -> Boolean.compare(this.isCategoryTreeItem((TreeItem<Layer>)o1), this.isCategoryTreeItem((TreeItem<Layer>)o2));
            Comparator c2 = (o1, o2) -> ((Layer)o1.getValue()).getName().compareTo(((Layer)o2.getValue()).getName());
            treeItem.getChildren().sort(c1.reversed().thenComparing(c2));
            for (TreeItem childTreeItem : treeItem.getChildren()) {
                this.postPopulate((CheckBoxTreeItem<Layer>)((CheckBoxTreeItem)childTreeItem));
            }
        } else if (!this.mLayerEnabledListenerSet.contains(layer)) {
            this.mLayerEnabledListenerSet.add(layer);
            layer.addPropertyChangeListener("Enabled", pce -> {
                boolean newValue = (Boolean)pce.getNewValue();
                if (newValue) {
                    this.mCheckModel.check((Object)treeItem);
                } else {
                    try {
                        this.mCheckModel.clearCheck((Object)treeItem);
                    }
                    catch (UnsupportedOperationException e) {
                        System.err.println("Error detected in LayerView");
                    }
                }
                this.mVisibilityPreferences.putBoolean(this.getLayerPath((Layer)treeItem.getValue()), newValue);
            });
        }
    }

    private void restoreLayerVisibility(CheckBoxTreeItem<Layer> treeItem) {
        if (this.isCategoryTreeItem((TreeItem<Layer>)treeItem)) {
            for (TreeItem childTreeItem : treeItem.getChildren()) {
                this.restoreLayerVisibility((CheckBoxTreeItem<Layer>)((CheckBoxTreeItem)childTreeItem));
            }
        } else {
            Layer layer = (Layer)treeItem.getValue();
            if (this.mVisibilityPreferences.getBoolean(this.getLayerPath(layer), layer.isEnabled())) {
                this.mCheckModel.check(treeItem);
                if (!layer.isEnabled()) {
                    layer.setEnabled(true);
                }
            } else {
                this.mCheckModel.clearCheck(treeItem);
                layer.setEnabled(false);
            }
        }
    }

    private void setChecked(CheckBoxTreeItem<Layer> treeItem, boolean checked) {
        if (treeItem == null) {
            return;
        }
        if (!this.isCategoryTreeItem((TreeItem<Layer>)treeItem)) {
            if (checked) {
                this.mCheckModel.check(treeItem);
            } else {
                this.mCheckModel.clearCheck(treeItem);
            }
        }
        for (TreeItem childTreeItem : treeItem.getChildren()) {
            this.setChecked((CheckBoxTreeItem<Layer>)((CheckBoxTreeItem)childTreeItem), checked);
        }
    }

    private void setExpanded(CheckBoxTreeItem<Layer> treeItem, boolean expanded) {
        if (treeItem == null) {
            return;
        }
        if (this.isCategoryTreeItem((TreeItem<Layer>)treeItem)) {
            if (treeItem != this.mRootItem) {
                treeItem.setExpanded(expanded);
            }
            for (TreeItem childTreeItem : treeItem.getChildren()) {
                this.setExpanded((CheckBoxTreeItem<Layer>)((CheckBoxTreeItem)childTreeItem), expanded);
            }
        }
    }

    private static class Holder {
        private static final LayerView INSTANCE = new LayerView();

        private Holder() {
        }
    }

    class LayerTreeCell
    extends CheckBoxTreeCell<Layer> {
        public LayerTreeCell() {
            this.createUI();
        }

        public void updateItem(Layer layer, boolean empty) {
            super.updateItem((Object)layer, empty);
            LayerView.this.mLayerToCheckBoxTreeCell.put(layer, this);
            TreeItem treeItem = this.getTreeItem();
            if (treeItem != null) {
                if (treeItem.isLeaf()) {
                    this.setContextMenu(LayerView.this.mContextMenu);
                } else {
                    this.setContextMenu(null);
                }
            }
            if (layer == null || empty) {
                this.clearContent();
            } else {
                this.addContent(layer);
            }
        }

        private void addContent(Layer layer) {
            this.setText(layer.getName());
            this.setOnMouseClicked(mouseEvent -> {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == MouseButton.PRIMARY && layer.hasKey("mapton.layer.fast_open")) {
                    Mapton.getGlobalState().put("map.layer.fastopen_tool", layer.getValue("mapton.layer.fast_open"));
                    if (!mouseEvent.isAltDown()) {
                        LayerView.this.mCheckModel.check((Object)this.getTreeItem());
                    }
                }
            });
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
            this.setOnMouseClicked(null);
        }

        private void createUI() {
        }
    }
}

