/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Border;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MDict;
import org.mapton.api.MWmsStyle;
import org.mapton.api.Mapton;
import org.mapton.worldwind.ModuleOptions;
import org.mapton.worldwind.api.MapStyle;
import org.openide.util.Lookup;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class StyleView
extends HBox {
    private CheckBox mAtmosphereCheckBox;
    private CheckBox mCompassCheckBox;
    private CheckBox mControlsCheckBox;
    private CheckBox mElevationCheckBox;
    private CheckBox mMaskCheckBox;
    private final GridPane mLeftPane = new GridPane();
    private RadioButton mModeFlatRadioButton;
    private RadioButton mModeGlobeRadioButton;
    private VBox mMapOpacityBox;
    private VBox mMaskOpacityBox;
    private final Slider mMapOpacitySlider = new Slider(0.0, 1.0, 1.0);
    private final Slider mMaskOpacitySlider = new Slider(0.0, 1.0, 1.0);
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private CheckBox mPlaceNameCheckBox;
    private ComboBox<String> mProjComboBox;
    private final ArrayList<String> mProjections = new ArrayList();
    private CheckBox mScaleBarCheckBox;
    private CheckBox mStarsCheckBox;
    private final VBox mStyleBox = new VBox(16.0);
    private CheckBox mWorldMapCheckBox;
    private ColorPicker mMaskColorPicker;

    public StyleView() {
        this.mProjections.add(MDict.PROJ_LAT_LON.toString());
        this.mProjections.add(MDict.PROJ_MERCATOR.toString());
        this.mProjections.add(MDict.PROJ_POLAR_NORTH.toString());
        this.mProjections.add(MDict.PROJ_POLAR_SOUTH.toString());
        this.mProjections.add(MDict.PROJ_SINUSOIDAL.toString());
        this.mProjections.add(MDict.PROJ_SINUSOIDAL_MODIFIED.toString());
        this.mProjections.add(MDict.PROJ_TRANSVERSE_MERCATOR.toString());
        this.mProjections.add(MDict.PROJ_UPS_NORTH.toString());
        this.mProjections.add(MDict.PROJ_UPS_SOUTH.toString());
        this.createUI();
        this.initListeners();
        this.load();
        Lookup.getDefault().lookupResult(MapStyle.class).addLookupListener(ev -> this.initStyle());
        this.initStyle();
    }

    private void createUI() {
        this.setSpacing(FxHelper.getUIScaled((int)16));
        this.setPadding(FxHelper.getUIScaledInsets((double)8.0, (double)16.0, (double)16.0, (double)16.0));
        double width = FxHelper.getUIScaled((int)200);
        this.mLeftPane.setPrefWidth(width);
        this.mStyleBox.setPrefWidth(width);
        Insets topInsets = FxHelper.getUIScaledInsets((double)12.0, (double)0.0, (double)0.0, (double)0.0);
        Label modeLabel = new Label(Dict.MODE.toString());
        Label projLabel = new Label(MDict.PROJECTION.toString());
        GridPane.setMargin((Node)projLabel, (Insets)topInsets);
        ToggleGroup modeToggleGroup = new ToggleGroup();
        this.mModeGlobeRadioButton = new RadioButton(MDict.GLOBE.toString());
        this.mModeGlobeRadioButton.setToggleGroup(modeToggleGroup);
        GridPane.setMargin((Node)this.mModeGlobeRadioButton, (Insets)topInsets);
        this.mModeFlatRadioButton = new RadioButton(MDict.FLAT.toString());
        this.mModeFlatRadioButton.setToggleGroup(modeToggleGroup);
        GridPane.setMargin((Node)this.mModeFlatRadioButton, (Insets)topInsets);
        this.mProjComboBox = new ComboBox();
        this.mWorldMapCheckBox = new CheckBox(MDict.WORLD_MAP.toString());
        GridPane.setMargin((Node)this.mWorldMapCheckBox, (Insets)topInsets);
        this.mScaleBarCheckBox = new CheckBox(MDict.SCALE_BAR.toString());
        GridPane.setMargin((Node)this.mScaleBarCheckBox, (Insets)topInsets);
        this.mControlsCheckBox = new CheckBox(MDict.VIEW_CONTROLS.toString());
        this.mControlsCheckBox.setDisable(true);
        GridPane.setMargin((Node)this.mControlsCheckBox, (Insets)topInsets);
        this.mCompassCheckBox = new CheckBox(MDict.COMPASS.toString());
        GridPane.setMargin((Node)this.mCompassCheckBox, (Insets)topInsets);
        this.mStarsCheckBox = new CheckBox(MDict.STARS.toString());
        GridPane.setMargin((Node)this.mStarsCheckBox, (Insets)topInsets);
        this.mAtmosphereCheckBox = new CheckBox(MDict.ATMOSPHERE.toString());
        GridPane.setMargin((Node)this.mAtmosphereCheckBox, (Insets)topInsets);
        this.mPlaceNameCheckBox = new CheckBox(Dict.PLACE_NAMES.toString());
        this.mPlaceNameCheckBox.setDisable(true);
        GridPane.setMargin((Node)this.mPlaceNameCheckBox, (Insets)topInsets);
        this.mProjComboBox.getItems().addAll(this.mProjections);
        this.mLeftPane.addColumn(0, new Node[]{modeLabel, this.mModeGlobeRadioButton, this.mModeFlatRadioButton, projLabel, this.mProjComboBox, this.mWorldMapCheckBox, this.mCompassCheckBox, this.mControlsCheckBox, this.mScaleBarCheckBox, this.mStarsCheckBox, this.mAtmosphereCheckBox, this.mPlaceNameCheckBox});
        this.mModeFlatRadioButton.setMaxWidth(Double.MAX_VALUE);
        this.mModeGlobeRadioButton.setMaxWidth(Double.MAX_VALUE);
        this.mProjComboBox.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow(this.mProjComboBox, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth(this.mProjComboBox, (Boolean)true);
        this.mProjComboBox.disableProperty().bind((ObservableValue)this.mModeGlobeRadioButton.selectedProperty());
        this.mModeGlobeRadioButton.setOnAction(event -> this.mOptions.put("map_mode", true));
        this.mModeFlatRadioButton.setOnAction(event -> this.mOptions.put("map_mode", false));
        this.mProjComboBox.setOnAction(event -> this.mOptions.put("map_projection", this.mProjComboBox.getSelectionModel().getSelectedIndex()));
        this.mWorldMapCheckBox.setOnAction(event -> this.mOptions.put("display_world_map", this.mWorldMapCheckBox.isSelected()));
        this.mScaleBarCheckBox.setOnAction(event -> this.mOptions.put("display_scale_bar", this.mScaleBarCheckBox.isSelected()));
        this.mControlsCheckBox.setOnAction(event -> this.mOptions.put("display_controls2", this.mControlsCheckBox.isSelected()));
        this.mCompassCheckBox.setOnAction(event -> this.mOptions.put("display_compass", this.mCompassCheckBox.isSelected()));
        this.mAtmosphereCheckBox.setOnAction(event -> this.mOptions.put("display_atmosphere", this.mAtmosphereCheckBox.isSelected()));
        this.mStarsCheckBox.setOnAction(event -> this.mOptions.put("display_stars", this.mStarsCheckBox.isSelected()));
        this.mPlaceNameCheckBox.setOnAction(event -> this.mOptions.put("display_place_names2", this.mPlaceNameCheckBox.isSelected()));
        this.mElevationCheckBox = new CheckBox(MDict.ELEVATION.toString());
        this.mElevationCheckBox.setOnAction(event -> this.mOptions.put("map_elevation", this.mElevationCheckBox.isSelected()));
        this.mMaskCheckBox = new CheckBox(Dict.MASK.toString());
        this.mMaskCheckBox.setOnAction(event -> this.mOptions.put("display_mask", this.mMaskCheckBox.isSelected()));
        this.mMaskColorPicker = new ColorPicker();
        this.mMaskColorPicker.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.mMaskColorPicker.disableProperty().bind((ObservableValue)this.mMaskCheckBox.selectedProperty().not());
        this.mMaskOpacitySlider.disableProperty().bind((ObservableValue)this.mMaskCheckBox.selectedProperty().not());
        Color color = FxHelper.colorFromHexRGBA((String)this.mOptions.get("mask_color", new String[]{"ffffff"}));
        this.mMaskColorPicker.setValue((Object)color);
        this.mMapOpacityBox = new VBox(new Node[]{new Label(Dict.OPACITY.toString()), this.mMapOpacitySlider});
        this.mMaskOpacityBox = new VBox((double)FxHelper.getUIScaled((int)8), new Node[]{this.mMaskCheckBox, this.mMaskOpacitySlider, this.mMaskColorPicker});
        this.getChildren().addAll((Object[])new Node[]{this.mLeftPane, new Separator(Orientation.VERTICAL), this.mStyleBox});
    }

    private void initListeners() {
        this.mMapOpacitySlider.valueProperty().addListener((observable, oldValue, newValue) -> this.mOptions.put("map_opacity", this.mMapOpacitySlider.getValue()));
        this.mMaskOpacitySlider.valueProperty().addListener((observable, oldValue, newValue) -> this.mOptions.put("mask_opacity", this.mMaskOpacitySlider.getValue()));
        this.mMaskColorPicker.valueProperty().addListener((ov, t, t1) -> this.mOptions.put("mask_color", FxHelper.colorToHexRGB((Color)t1)));
        Mapton.getGlobalState().addListener(evt -> this.initStyle(), new String[]{"data_sources.wms.styles"});
    }

    private void initStyle() {
        Platform.runLater(() -> {
            this.mStyleBox.getChildren().clear();
            ArrayList<MapStyle> styles = new ArrayList<MapStyle>(Lookup.getDefault().lookupAll(MapStyle.class));
            ArrayList wmsStyles = (ArrayList)Mapton.getGlobalState().get("data_sources.wms.styles");
            if (wmsStyles != null) {
                for (MWmsStyle wmsStyle : wmsStyles) {
                    styles.add(MapStyle.createFromWmsStyle(wmsStyle));
                }
            }
            Collections.sort(styles, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            TreeMap<String, ObservableList> categoryStyles = new TreeMap<String, ObservableList>();
            for (MapStyle mapStyle : styles) {
                if (StringUtils.isBlank((CharSequence)mapStyle.getCategory())) {
                    Button button = new Button(mapStyle.getName());
                    button.prefWidthProperty().bind((ObservableValue)this.widthProperty());
                    button.setOnAction(event -> {
                        this.mOptions.put("map_style_prev", this.mOptions.get("map_style", new String[0]));
                        this.mOptions.put("map_style", mapStyle.getId());
                    });
                    if (mapStyle.getSuppliers() != null) {
                        button.setTooltip(new Tooltip(mapStyle.getDescription()));
                    }
                    this.mStyleBox.getChildren().add((Object)button);
                    continue;
                }
                categoryStyles.computeIfAbsent(mapStyle.getCategory(), k -> FXCollections.observableArrayList()).add((Object)mapStyle);
            }
            this.mStyleBox.getChildren().add((Object)new Separator());
            for (String category : categoryStyles.keySet()) {
                ListView listView = new ListView((ObservableList)categoryStyles.get(category));
                listView.setPrefWidth((double)FxHelper.getUIScaled((int)250));
                listView.setCellFactory(param -> new MapStyleListCell());
                listView.parentProperty().addListener((observable, oldValue, newValue) -> {
                    Region region = (Region)newValue;
                    region.setPadding(Insets.EMPTY);
                    region.setBorder(Border.EMPTY);
                });
                MultipleSelectionModel selectionModel = listView.getSelectionModel();
                selectionModel.getSelectedItems().addListener(change -> {
                    change.next();
                    if (change.wasAdded() || change.wasReplaced()) {
                        try {
                            this.mOptions.put("map_style_prev", this.mOptions.get("map_style", new String[0]));
                            this.mOptions.put("map_style", ((MapStyle)selectionModel.getSelectedItem()).getId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                MenuButton menuButton = new MenuButton(category);
                menuButton.setPopupSide(Side.RIGHT);
                CustomMenuItem menuItem = new CustomMenuItem((Node)listView);
                menuButton.setOnShowing(event -> listView.getSelectionModel().clearSelection());
                menuButton.setOnShown(event -> {
                    listView.requestFocus();
                    for (MapStyle item : listView.getItems()) {
                        if (!item.getId().equalsIgnoreCase(this.mOptions.get("map_style", new String[0]))) continue;
                        listView.getSelectionModel().select((Object)item);
                        break;
                    }
                });
                menuItem.setHideOnClick(false);
                menuButton.getItems().add((Object)menuItem);
                menuButton.prefWidthProperty().bind((ObservableValue)this.widthProperty());
                this.mStyleBox.getChildren().add((Object)menuButton);
            }
            this.mStyleBox.getChildren().addAll((Object[])new Node[]{new Separator(), this.mElevationCheckBox, this.mMapOpacityBox, this.mMaskOpacityBox});
        });
    }

    private void load() {
        if (this.mOptions.is("map_mode", new boolean[]{true})) {
            this.mModeGlobeRadioButton.setSelected(true);
        } else {
            this.mModeFlatRadioButton.setSelected(true);
        }
        this.mProjComboBox.getSelectionModel().select(this.mOptions.getInt("map_projection", new Integer[]{1}));
        this.mWorldMapCheckBox.setSelected(this.mOptions.is("display_world_map", new boolean[]{false}));
        this.mScaleBarCheckBox.setSelected(this.mOptions.is("display_scale_bar", new boolean[]{true}));
        this.mControlsCheckBox.setSelected(this.mOptions.is("display_controls2", new boolean[]{false}));
        this.mCompassCheckBox.setSelected(this.mOptions.is("display_compass", new boolean[]{true}));
        this.mAtmosphereCheckBox.setSelected(this.mOptions.is("display_atmosphere", new boolean[]{true}));
        this.mStarsCheckBox.setSelected(this.mOptions.is("display_stars", new boolean[]{true}));
        this.mPlaceNameCheckBox.setSelected(this.mOptions.is("display_place_names2", new boolean[]{false}));
        this.mMapOpacitySlider.setValue(this.mOptions.getDouble("map_opacity", new Double[]{1.0}));
        this.mMaskOpacitySlider.setValue((double)this.mOptions.getFloat("mask_opacity", new Float[]{Float.valueOf(0.5f)}));
        this.mMaskCheckBox.setSelected(this.mOptions.is("display_mask", new boolean[]{false}));
        this.mElevationCheckBox.setSelected(this.mOptions.is("map_elevation", new boolean[]{false}));
    }

    class MapStyleListCell
    extends ListCell<MapStyle> {
        private final VBox mBox = new VBox();
        private final Label mDescLabel = new Label();
        private final Label mNameLabel = new Label();

        public MapStyleListCell() {
            this.createUI();
        }

        protected void updateItem(MapStyle mapStyle, boolean empty) {
            super.updateItem((Object)mapStyle, empty);
            if (mapStyle == null || empty) {
                this.clearContent();
            } else {
                this.addContent(mapStyle);
            }
        }

        private void addContent(MapStyle mapStyle) {
            this.setText(null);
            this.mNameLabel.setText(mapStyle.getName());
            this.mDescLabel.setText(mapStyle.getDescription());
            this.setGraphic((Node)this.mBox);
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
            String fontFamily = Font.getDefault().getFamily();
            double fontSize = FxHelper.getScaledFontSize();
            this.mNameLabel.setFont(Font.font((String)fontFamily, (FontWeight)FontWeight.BOLD, (double)fontSize));
            this.mDescLabel.setFont(Font.font((String)fontFamily, (FontPosture)FontPosture.ITALIC, (double)fontSize));
            this.mBox.setSpacing((double)FxHelper.getUIScaled((int)4));
            this.mBox.getChildren().setAll((Object[])new Node[]{this.mNameLabel, this.mDescLabel});
        }
    }
}

