/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import java.util.LinkedHashMap;
import javafx.scene.paint.Color;
import org.apache.commons.lang3.ObjectUtils;
import org.mapton.api.MPoi;
import org.mapton.api.MTemporaryPoiManager;
import org.mapton.api.Mapton;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.WWHelper;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public class TemporaryPoiLayerBundle
extends LayerBundle {
    private final RenderableLayer mLayer = new RenderableLayer();
    private final MTemporaryPoiManager mManager = MTemporaryPoiManager.getInstance();

    public TemporaryPoiLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(0L);
    }

    private void init() {
        this.mLayer.setName(Dict.TEMPORARY_CONTENT.toString());
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(Dict.TEMPORARY_CONTENT.toString());
        this.mLayer.setEnabled(true);
        this.mLayer.setPickEnabled(false);
        this.setParentLayer((Layer)this.mLayer);
    }

    private void initListeners() {
        this.mManager.getItems().addListener(c -> this.repaint());
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            for (MPoi poi : this.mManager.getItems()) {
                if (!poi.isDisplayMarker().booleanValue() || !ObjectUtils.allNotNull((Object[])new Object[]{poi.getLatitude(), poi.getLongitude()})) continue;
                PointPlacemark placemark = new PointPlacemark(Position.fromDegrees((double)poi.getLatitude(), (double)poi.getLongitude()));
                placemark.setLabelText(poi.getName());
                placemark.setAltitudeMode(1);
                placemark.setEnableLabelPicking(true);
                PointPlacemarkAttributes attrs = new PointPlacemarkAttributes(placemark.getDefaultAttributes());
                attrs.setImageAddress("images/pushpins/plain-white.png");
                attrs.setImageColor(FxHelper.colorToColor((Color)FxHelper.colorFromHexRGBA((String)poi.getColor())));
                placemark.setAttributes(attrs);
                placemark.setHighlightAttributes(WWHelper.createHighlightAttributes(attrs, 1.5));
                placemark.setValue("mapton.runnable.left_click", () -> {
                    LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
                    propertyMap.put(Dict.NAME.toString(), poi.getName());
                    propertyMap.put(Dict.DESCRIPTION.toString(), poi.getDescription());
                    propertyMap.put(Dict.CATEGORY.toString(), poi.getCategory());
                    propertyMap.put(Dict.COLOR.toString(), (String)Color.web((String)poi.getColor()));
                    Mapton.getGlobalState().put("object.properties", propertyMap);
                });
                this.mLayer.addRenderable((Renderable)placemark);
            }
            this.setDragEnabled(false);
        });
    }
}

