/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.mapton.api.Mapton;
import org.mapton.worldwind.api.LayerBundleManager;
import org.openide.util.Exceptions;
import se.trixon.almond.util.Dict;

public abstract class LayerBundle {
    public static final int DEFAULT_REPAINT_DELAY = 5000;
    private static final Set<Runnable> sActivePaintersSet = Collections.synchronizedSet(new HashSet());
    private HashSet<Layer> mChildLayers = new HashSet();
    private boolean mInitialized = false;
    private final ObservableList<Layer> mLayers = FXCollections.observableArrayList();
    private final StringProperty mName = new SimpleStringProperty();
    private final HashMap<Object, ArrayList<Renderable>> mObjectToRenderables = new HashMap();
    private Runnable mPainter;
    private Layer mParentLayer;
    private boolean mPopulated = false;

    public void addAllChildLayers(Layer ... childLayers) {
        this.mChildLayers.addAll(Arrays.asList(childLayers));
        for (Layer childLayer : childLayers) {
            this.setVisibleInLayerManager(childLayer, false);
            childLayer.setEnabled(this.mParentLayer.isEnabled());
        }
        this.mParentLayer.addPropertyChangeListener(pce -> {
            if (pce.getPropertyName().equals("Enabled")) {
                for (Layer childLayer : this.mChildLayers) {
                    childLayer.setEnabled(this.mParentLayer.isEnabled() && this.getChildVisibility(childLayer));
                }
            }
        });
    }

    public void attachTopComponentToLayer(String topComponentID, Layer layer) {
        layer.setValue("mapton.layer.fast_open", (Object)topComponentID);
    }

    public ObservableList<Layer> getLayers() {
        return this.mLayers;
    }

    public final String getName() {
        return (String)this.mName.get();
    }

    public Node getOptionsView() {
        return null;
    }

    public Layer getParentLayer() {
        return this.mParentLayer;
    }

    public ArrayList<Renderable> getRenderablesForObject(Object o) {
        return this.mObjectToRenderables.computeIfAbsent(o, k -> new ArrayList());
    }

    public boolean isPopulated() {
        return this.mPopulated;
    }

    public final StringProperty nameProperty() {
        return this.mName;
    }

    public void onSelectEvent(Object o, SelectEvent selectEvent) {
    }

    public abstract void populate() throws Exception;

    public void removeAllIcons(IconLayer ... layers) {
        for (IconLayer layer : layers) {
            layer.removeAllIcons();
        }
    }

    public void removeAllIcons() {
        Layer layer2 = this.mParentLayer;
        if (layer2 instanceof IconLayer) {
            IconLayer iconLayer2 = (IconLayer)layer2;
            iconLayer2.removeAllIcons();
        }
        this.mChildLayers.stream().filter(layer -> layer instanceof IconLayer).map(layer -> (IconLayer)layer).forEachOrdered(iconLayer -> iconLayer.removeAllIcons());
        this.mLayers.stream().filter(layer -> layer instanceof IconLayer).map(layer -> (IconLayer)layer).forEachOrdered(iconLayer -> iconLayer.removeAllIcons());
    }

    public void removeAllRenderables() {
        Layer layer2 = this.mParentLayer;
        if (layer2 instanceof RenderableLayer) {
            RenderableLayer renderableLayer2 = (RenderableLayer)layer2;
            renderableLayer2.removeAllRenderables();
        }
        this.mChildLayers.stream().filter(layer -> layer instanceof RenderableLayer).map(layer -> (RenderableLayer)layer).forEachOrdered(renderableLayer -> renderableLayer.removeAllRenderables());
        this.mLayers.stream().filter(layer -> layer instanceof RenderableLayer).map(layer -> (RenderableLayer)layer).forEachOrdered(renderableLayer -> renderableLayer.removeAllRenderables());
    }

    public void removeAllRenderables(RenderableLayer ... layers) {
        for (RenderableLayer layer : layers) {
            layer.removeAllRenderables();
        }
    }

    public synchronized void repaint(long delay) {
        if (this.mPainter == null || sActivePaintersSet.contains(this.mPainter)) {
            return;
        }
        if (delay != -1L) {
            this.mInitialized = true;
        }
        if (this.mInitialized) {
            sActivePaintersSet.add(this.mPainter);
            new Thread(() -> {
                if (delay > -1L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.mPainter.run();
                LayerBundleManager.getInstance().redraw();
                sActivePaintersSet.remove(this.mPainter);
            }, this.getClass().getName() + "->repaint").start();
        }
    }

    public void repaint() {
        this.repaint(-1L);
    }

    public void setAllChildLayers(Layer ... childLayers) {
        this.mChildLayers = new HashSet<Layer>(Arrays.asList(childLayers));
        this.addAllChildLayers(childLayers);
    }

    public void setCategory(Layer layer, String category) {
        layer.setValue("mapton.layer.category", (Object)category);
    }

    public void setCategoryAddOns(Layer layer) {
        this.setCategory(layer, "- %s -".formatted(Dict.ADD_ONS.toString()));
    }

    public void setCategorySystem(Layer layer) {
        this.setCategory(layer, "- %s -".formatted(Dict.SYSTEM.toString()));
    }

    public void setDragEnabled(boolean enabled, AbstractLayer ... abstractLayers) {
        for (AbstractLayer abstractLayer : abstractLayers) {
            Draggable draggable;
            if (abstractLayer instanceof RenderableLayer) {
                RenderableLayer renderableLayer = (RenderableLayer)abstractLayer;
                for (Renderable renderable : renderableLayer.getRenderables()) {
                    if (!(renderable instanceof Draggable)) continue;
                    draggable = (Draggable)renderable;
                    if (draggable instanceof AbstractAirspace) {
                        AbstractAirspace abstractAirspace = (AbstractAirspace)draggable;
                        this.setDragEnabled(abstractAirspace, enabled);
                        continue;
                    }
                    draggable.setDragEnabled(enabled);
                }
                continue;
            }
            if (abstractLayer instanceof IconLayer) {
                IconLayer iconLayer = (IconLayer)abstractLayer;
                for (WWIcon icon : iconLayer.getIcons()) {
                    if (!(icon instanceof Draggable)) continue;
                    draggable = (Draggable)icon;
                    draggable.setDragEnabled(enabled);
                }
                continue;
            }
            System.err.println("Unhandled layer type in: " + this.getClass().getName());
            System.err.println(abstractLayer.getClass().getName());
        }
    }

    public void setDragEnabled(boolean enabled) {
        Layer layer2 = this.mParentLayer;
        if (layer2 instanceof AbstractLayer) {
            AbstractLayer renderableLayer2 = (AbstractLayer)layer2;
            this.setDragEnabled(enabled, renderableLayer2);
        }
        this.mChildLayers.stream().filter(layer -> layer instanceof RenderableLayer).map(layer -> (RenderableLayer)layer).forEachOrdered(renderableLayer -> this.setDragEnabled(enabled, new AbstractLayer[]{renderableLayer}));
        this.mLayers.stream().filter(layer -> layer instanceof RenderableLayer).map(layer -> (RenderableLayer)layer).forEachOrdered(renderableLayer -> this.setDragEnabled(enabled, new AbstractLayer[]{renderableLayer}));
    }

    public final void setName(String value) {
        this.mName.set((Object)value);
    }

    public void setPainter(Runnable painter) {
        this.mPainter = painter;
    }

    public void setParentLayer(Layer parentLayer) {
        this.mParentLayer = parentLayer;
        this.mParentLayer.addPropertyChangeListener("Enabled", pce -> Mapton.getGlobalState().put(this.getClass().getCanonicalName() + "_Enabled", (Object)this.mParentLayer.isEnabled()));
    }

    public void setPopulated(boolean populated) {
        this.mPopulated = populated;
    }

    public void setSelectEventWatcher(AVListImpl avListImpl, Object object) {
        avListImpl.setValue("ww.drag.layer_bundle", (Object)this);
        avListImpl.setValue("ww.drag.object", object);
    }

    public void setVisibleInLayerManager(Layer layer, boolean visibility) {
        layer.setValue("mapton.layer.hide_from_manager", (Object)(!visibility ? 1 : 0));
    }

    private boolean getChildVisibility(Layer layer) {
        boolean visible = true;
        Object visibility = layer.getValue("map.layer.sub_visibility");
        if (visibility != null) {
            visible = (Boolean)visibility;
        }
        return visible;
    }

    private void setDragEnabled(AbstractAirspace abstractAirspace, boolean enabled) {
        try {
            Field dragEnabledField = AbstractAirspace.class.getDeclaredField("dragEnabled");
            boolean accessible = dragEnabledField.canAccess(abstractAirspace);
            dragEnabledField.setAccessible(true);
            dragEnabledField.set(abstractAirspace, enabled);
            dragEnabledField.setAccessible(accessible);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

