/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import org.mapton.api.MEngine;
import org.mapton.worldwind.WorldWindMapEngine;
import org.mapton.worldwind.WorldWindowPanel;
import se.trixon.almond.util.swing.DelayedResetRunner;

public class LayerBundleManager {
    private final DelayedResetRunner mDelayedResetRunner = new DelayedResetRunner(50, () -> {
        try {
            this.getMap().redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
    });
    private WorldWindMapEngine mEngine;
    private WorldWindowPanel mMap;

    public static LayerBundleManager getInstance() {
        return Holder.INSTANCE;
    }

    private LayerBundleManager() {
    }

    public void add(Layer layer) {
        this.getMap().addCustomLayer(layer);
    }

    public WorldWindow getWwd() {
        return this.mMap.getWwd();
    }

    public void redraw() {
        this.mDelayedResetRunner.reset();
    }

    public void remove(Layer layer) {
        this.getMap().removeCustomLayer(layer);
    }

    private WorldWindMapEngine getEngine() {
        if (this.mEngine == null) {
            this.mEngine = (WorldWindMapEngine)MEngine.byName((String)"WorldWind");
        }
        return this.mEngine;
    }

    private WorldWindowPanel getMap() {
        if (this.mMap == null) {
            this.mMap = this.getEngine().getMap();
        }
        return this.mMap;
    }

    private static class Holder {
        private static final LayerBundleManager INSTANCE = new LayerBundleManager();

        private Holder() {
        }
    }
}

