/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MWmsStyle;
import org.mapton.api.Mapton;
import org.openide.util.Lookup;

public abstract class MapStyle {
    private String mCategory;
    private String mDescription;
    private String mId;
    private String[] mLayers;
    private String mName;
    private String mSuppliers;

    public static MapStyle createFromWmsStyle(MWmsStyle wmsStyle) {
        MapStyle mapStyle = new MapStyle(){};
        mapStyle.setId(wmsStyle.getId());
        mapStyle.setName(wmsStyle.getName());
        mapStyle.setSuppliers(wmsStyle.getSupplier());
        mapStyle.setLayers(wmsStyle.getLayers().toArray(new String[0]));
        mapStyle.setCategory(wmsStyle.getCategory());
        mapStyle.setDescription(wmsStyle.getDescription());
        return mapStyle;
    }

    public static String[] getLayers(String id) {
        String[] layers = null;
        ArrayList styles = new ArrayList(Lookup.getDefault().lookupAll(MapStyle.class));
        ArrayList wmsStyles = (ArrayList)Mapton.getGlobalState().get("data_sources.wms.styles");
        try {
            wmsStyles.forEach(wmsStyle -> styles.add(MapStyle.createFromWmsStyle(wmsStyle)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (MapStyle mapStyle : styles) {
            if (!mapStyle.getId().equalsIgnoreCase(id)) continue;
            layers = mapStyle.getLayers();
            break;
        }
        return layers;
    }

    public static MapStyle getStyle(String id) {
        ArrayList styles = new ArrayList(Lookup.getDefault().lookupAll(MapStyle.class));
        ArrayList wmsStyles = (ArrayList)Mapton.getGlobalState().get("data_sources.wms.styles");
        if (wmsStyles != null) {
            wmsStyles.forEach(wmsStyle -> styles.add(MapStyle.createFromWmsStyle(wmsStyle)));
        }
        for (MapStyle mapStyle : styles) {
            if (!StringUtils.equals((CharSequence)mapStyle.getId(), (CharSequence)id)) continue;
            return mapStyle;
        }
        return new MapStyle(){

            @Override
            public String getId() {
                return "unknown.id";
            }
        };
    }

    public String getCategory() {
        return this.mCategory;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getId() {
        return this.mId;
    }

    public String[] getLayers() {
        return this.mLayers;
    }

    public String getName() {
        return this.mName;
    }

    public String getSuppliers() {
        return this.mSuppliers;
    }

    public void setCategory(String category) {
        this.mCategory = category;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public void setLayers(String[] value) {
        this.mLayers = (String[])value.clone();
    }

    public void setName(String value) {
        this.mName = value;
    }

    public void setSuppliers(String suppliers) {
        this.mSuppliers = suppliers;
    }

    public String toString() {
        return this.mName;
    }
}

