/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.MPoiStyle;

public class WWHelper {
    public static final String KEY_FAST_OPEN = "mapton.layer.fast_open";
    public static final String KEY_HOOVER_TEXT = "mapton.hoover.text";
    public static final String KEY_LAYER_CATEGORY = "mapton.layer.category";
    public static final String KEY_LAYER_HIDE_FROM_MANAGER = "mapton.layer.hide_from_manager";
    public static final String KEY_RUNNABLE_HOOVER = "mapton.runnable.hoover";
    public static final String KEY_RUNNABLE_LEFT_CLICK = "mapton.runnable.left_click";
    public static final String KEY_RUNNABLE_LEFT_DOUBLE_CLICK = "mapton.runnable.left_double_click";

    public static PointPlacemarkAttributes createHighlightAttributes(PointPlacemarkAttributes attrs, double scale) {
        PointPlacemarkAttributes highlightAttrs = new PointPlacemarkAttributes(attrs);
        highlightAttrs.setScale(Double.valueOf(attrs.getScale() * scale));
        highlightAttrs.setLabelScale(Double.valueOf(attrs.getLabelScale() * scale));
        return highlightAttrs;
    }

    public static MLatLon latLonFromPosition(Position position) {
        return new MLatLon(position.getLatitude().getDegrees(), position.getLongitude().getDegrees());
    }

    public static Position movePolar(Position position, double bearing, double distance) {
        MLatLon latLon = WWHelper.latLonFromPosition(position).getDestinationPoint(bearing, distance);
        return Position.fromDegrees((double)latLon.getLatitude(), (double)latLon.getLongitude());
    }

    public static Offset offsetFromImageLocation(MPoiStyle.ImageLocation imageLocation) {
        switch (imageLocation) {
            case BOTTOM_LEFT: {
                return Offset.fromFraction((double)0.0, (double)0.0);
            }
            case BOTTOM_CENTER: {
                return Offset.fromFraction((double)0.5, (double)0.0);
            }
            case BOTTOM_RIGHT: {
                return Offset.fromFraction((double)1.0, (double)0.0);
            }
            case MIDDLE_LEFT: {
                return Offset.fromFraction((double)0.0, (double)0.5);
            }
            case MIDDLE_CENTER: {
                return Offset.fromFraction((double)0.5, (double)0.5);
            }
            case MIDDLE_RIGHT: {
                return Offset.fromFraction((double)1.0, (double)0.5);
            }
            case TOP_LEFT: {
                return Offset.fromFraction((double)0.0, (double)1.0);
            }
            case TOP_CENTER: {
                return Offset.fromFraction((double)0.5, (double)1.0);
            }
            case TOP_RIGHT: {
                return Offset.fromFraction((double)1.0, (double)1.0);
            }
        }
        throw new AssertionError();
    }

    public static Position positionFromLatLon(MLatLon latLon) {
        return Position.fromDegrees((double)latLon.getLatitude(), (double)latLon.getLongitude());
    }

    public static Position positionFromLatLon(MLatLon latLon, double elevation) {
        return Position.fromDegrees((double)latLon.getLatitude(), (double)latLon.getLongitude(), (double)elevation);
    }

    public static ArrayList<Position> positionsFromGeometry(Geometry geometry, double elevation) {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Coordinate coordinate : geometry.getCoordinates()) {
            positions.add(Position.fromDegrees((double)coordinate.y, (double)coordinate.x, (double)elevation));
        }
        return positions;
    }

    public static Sector sectorFromCoordinates(ArrayList<Coordinate> coordinates) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Coordinate coordinate : coordinates) {
            minX = FastMath.min((double)minX, (double)coordinate.x);
            minY = FastMath.min((double)minY, (double)coordinate.y);
            maxX = FastMath.max((double)maxX, (double)coordinate.x);
            maxY = FastMath.max((double)maxY, (double)coordinate.y);
        }
        Sector sector = new Sector(Angle.fromDegreesLatitude((double)minY), Angle.fromDegreesLatitude((double)maxY), Angle.fromDegreesLongitude((double)minX), Angle.fromDegreesLongitude((double)maxX));
        return sector;
    }

    public static Sector sectorFromGeometry(Geometry geometry) {
        return WWHelper.sectorFromCoordinates(new ArrayList<Coordinate>(Arrays.asList(geometry.getCoordinates())));
    }

    public static Sector sectorFromLatLonBox(MLatLonBox latLonBox) {
        return new Sector(Angle.fromDegreesLatitude((double)latLonBox.getSouthWest().getLatitude()), Angle.fromDegreesLatitude((double)latLonBox.getNorthEast().getLatitude()), Angle.fromDegreesLongitude((double)latLonBox.getSouthWest().getLongitude()), Angle.fromDegreesLongitude((double)latLonBox.getNorthEast().getLongitude()));
    }
}

