/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerStyle;
import gov.nasa.worldwind.util.WWUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.mapton.api.MWmsSource;
import org.mapton.api.Mapton;

public abstract class WmsService {
    private final TreeSet<LayerInfo> mLayerInfos = new TreeSet((o1, o2) -> o1.getName().compareTo(o2.getName()));
    private final ArrayList<Layer> mLayers = new ArrayList();
    private boolean mPopulated = false;

    public static WmsService createFromWmsSource(final MWmsSource wmsSource) {
        WmsService wmsService = new WmsService(){

            @Override
            public String getName() {
                return wmsSource.getName();
            }

            @Override
            public void populate() throws Exception {
                String url = Mapton.replaceSubstring((String)wmsSource.getUrl());
                this.addService(new URI(url));
                for (LayerInfo layerInfo : this.getLayerInfos()) {
                    Object component;
                    if (!wmsSource.getLayers().keySet().contains(layerInfo.getName()) && !wmsSource.getLayers().values().contains(layerInfo.getName()) || !((component = this.createComponent(layerInfo.getWmsCapabilities(), (AVList)layerInfo.getParams())) instanceof Layer)) continue;
                    Layer layer = (Layer)component;
                    layer.setName(wmsSource.getLayerName(layerInfo.getName()));
                    this.getLayers().add(layer);
                }
                this.setPopulated(true);
            }
        };
        return wmsService;
    }

    public TreeSet<LayerInfo> getLayerInfos() {
        return this.mLayerInfos;
    }

    public ArrayList<Layer> getLayers() {
        return this.mLayers;
    }

    public abstract String getName();

    public boolean isPopulated() {
        return this.mPopulated;
    }

    public abstract void populate() throws Exception;

    public void setPopulated(boolean populated) {
        this.mPopulated = populated;
    }

    protected void addService(URI uri) throws Exception {
        WMSCapabilities wmsCapabilities = WMSCapabilities.retrieve((URI)uri);
        wmsCapabilities.parse(new Object[0]);
        for (WMSLayerCapabilities wmsLayerCapabilities : wmsCapabilities.getNamedLayers()) {
            Set wmsLayerStyles = wmsLayerCapabilities.getStyles();
            if (wmsLayerStyles == null || wmsLayerStyles.isEmpty()) {
                this.mLayerInfos.add(new LayerInfo(wmsCapabilities, wmsLayerCapabilities, null));
                continue;
            }
            for (WMSLayerStyle wmsLayerStyle : wmsLayerStyles) {
                this.mLayerInfos.add(new LayerInfo(wmsCapabilities, wmsLayerCapabilities, wmsLayerStyle));
            }
        }
    }

    protected Object createComponent(WMSCapabilities wmsCapabilities, AVList params) {
        AVList configParams = params.copy();
        configParams.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", (Object)30000);
        configParams.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", (Object)30000);
        configParams.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", (Object)60000);
        try {
            String factoryKey = this.getFactoryKeyForCapabilities(wmsCapabilities);
            Factory factory = (Factory)WorldWind.createConfigurationComponent((String)factoryKey);
            return factory.createFromConfigSource((Object)wmsCapabilities, configParams);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            return null;
        }
    }

    private String getFactoryKeyForCapabilities(WMSCapabilities wmsCapabilities) {
        boolean hasApplicationBilFormat = false;
        for (String format : wmsCapabilities.getImageFormats()) {
            if (!format.contains("application/bil")) continue;
            hasApplicationBilFormat = true;
            break;
        }
        return hasApplicationBilFormat ? "gov.nasa.worldwind.avkey.ElevationModelFactory" : "gov.nasa.worldwind.avkey.LayerFactory";
    }

    protected class LayerInfo {
        private final AVListImpl mParams = new AVListImpl();
        private final WMSCapabilities mWmsCapabilities;

        public LayerInfo(WMSCapabilities wmsCapabilities, WMSLayerCapabilities wmsLayerCapabilities, WMSLayerStyle wmsLayerstyle) {
            String abs;
            this.mWmsCapabilities = wmsCapabilities;
            this.mParams.setValue("gov.nasa.worldwind.avkey.LayerNames", (Object)wmsLayerCapabilities.getName());
            if (wmsLayerstyle != null) {
                this.mParams.setValue("gov.nasa.worldwind.avkey.StyleNames", (Object)wmsLayerstyle.getName());
            }
            if (!WWUtil.isEmpty((Object)(abs = wmsLayerCapabilities.getLayerAbstract()))) {
                this.mParams.setValue("gov.nasa.worldwind.avkey.LayerAbstract", (Object)abs);
            }
        }

        public String getAbstract() {
            return this.mParams.getStringValue("gov.nasa.worldwind.avkey.LayerAbstract");
        }

        public String getName() {
            return this.mParams.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        }

        public AVListImpl getParams() {
            return this.mParams;
        }

        public String getTitle() {
            return this.mParams.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        }

        public WMSCapabilities getWmsCapabilities() {
            return this.mWmsCapabilities;
        }
    }
}

