/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.worldwind;

import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.Logging;

public class AnalyticSurfaceAttributes {
    protected boolean drawInterior = true;
    protected boolean drawOutline = true;
    protected boolean drawShadow = true;
    protected Material interiorMaterial = Material.GRAY;
    protected Material outlineMaterial = Material.WHITE;
    protected double interiorOpacity = 1.0;
    protected double outlineOpacity = 1.0;
    protected double shadowOpacity = 1.0;
    protected double outlineWidth = 1.0;

    public AnalyticSurfaceAttributes(Material material, double opacity) {
        if (material == null) {
            String message = Logging.getMessage((String)"nullValue.MaterialIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.interiorMaterial = material;
        this.interiorOpacity = opacity;
    }

    public AnalyticSurfaceAttributes() {
        this(Material.GRAY, 1.0);
    }

    public AnalyticSurfaceAttributes(AnalyticSurfaceAttributes attributes) {
        if (attributes == null) {
            String message = Logging.getMessage((String)"nullValue.AttributesIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.drawInterior = attributes.isDrawInterior();
        this.drawOutline = attributes.isDrawOutline();
        this.drawShadow = attributes.isDrawShadow();
        this.interiorMaterial = attributes.getInteriorMaterial();
        this.outlineMaterial = attributes.getOutlineMaterial();
        this.interiorOpacity = attributes.getInteriorOpacity();
        this.outlineOpacity = attributes.getOutlineOpacity();
        this.shadowOpacity = attributes.getShadowOpacity();
        this.outlineWidth = attributes.getOutlineWidth();
    }

    public AnalyticSurfaceAttributes copy() {
        return new AnalyticSurfaceAttributes(this);
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean draw) {
        this.drawInterior = draw;
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean draw) {
        this.drawOutline = draw;
    }

    public boolean isDrawShadow() {
        return this.drawShadow;
    }

    public void setDrawShadow(boolean draw) {
        this.drawShadow = draw;
    }

    public Material getInteriorMaterial() {
        return this.interiorMaterial;
    }

    public void setInteriorMaterial(Material material) {
        if (material == null) {
            String message = Logging.getMessage((String)"nullValue.MaterialIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.interiorMaterial = material;
    }

    public Material getOutlineMaterial() {
        return this.outlineMaterial;
    }

    public void setOutlineMaterial(Material material) {
        if (material == null) {
            String message = Logging.getMessage((String)"nullValue.MaterialIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.outlineMaterial = material;
    }

    public double getInteriorOpacity() {
        return this.interiorOpacity;
    }

    public void setInteriorOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            String message = Logging.getMessage((String)"generic.OpacityOutOfRange", (Object[])new Object[]{opacity});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.interiorOpacity = opacity;
    }

    public double getOutlineOpacity() {
        return this.outlineOpacity;
    }

    public void setOutlineOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            String message = Logging.getMessage((String)"generic.OpacityOutOfRange", (Object[])new Object[]{opacity});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.outlineOpacity = opacity;
    }

    public double getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            String message = Logging.getMessage((String)"generic.OpacityOutOfRange", (Object[])new Object[]{opacity});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.shadowOpacity = opacity;
    }

    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(double width) {
        if (width < 0.0) {
            String message = Logging.getMessage((String)"Geom.LineWidthInvalid", (Object[])new Object[]{width});
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        this.outlineWidth = width;
    }
}

