/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.api.worldwind;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.geojson.GeoJSONDoc;
import gov.nasa.worldwind.formats.geojson.GeoJSONFeature;
import gov.nasa.worldwind.formats.geojson.GeoJSONFeatureCollection;
import gov.nasa.worldwind.formats.geojson.GeoJSONGeometry;
import gov.nasa.worldwind.formats.geojson.GeoJSONGeometryCollection;
import gov.nasa.worldwind.formats.geojson.GeoJSONLineString;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiLineString;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiPoint;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiPolygon;
import gov.nasa.worldwind.formats.geojson.GeoJSONObject;
import gov.nasa.worldwind.formats.geojson.GeoJSONPoint;
import gov.nasa.worldwind.formats.geojson.GeoJSONPolygon;
import gov.nasa.worldwind.formats.geojson.GeoJSONPositionArray;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import java.util.logging.Level;
import org.mapton.worldwind.api.worldwind.RandomShapeAttributes;

public class GeoJSONLoader {
    protected static final RandomShapeAttributes randomAttrs = new RandomShapeAttributes();

    public void addSourceGeometryToLayer(Object docSource, RenderableLayer layer) {
        if (WWUtil.isEmpty((Object)docSource)) {
            String message = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (layer == null) {
            String message = Logging.getMessage((String)"nullValue.LayerIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        GeoJSONDoc doc = null;
        try {
            doc = new GeoJSONDoc(docSource);
            doc.parse();
            if (doc.getRootObject() instanceof GeoJSONObject) {
                this.addGeoJSONGeometryToLayer((GeoJSONObject)doc.getRootObject(), layer);
            } else if (doc.getRootObject() instanceof Object[]) {
                for (Object o : (Object[])doc.getRootObject()) {
                    if (o instanceof GeoJSONObject) {
                        this.addGeoJSONGeometryToLayer((GeoJSONObject)o, layer);
                        continue;
                    }
                    this.handleUnrecognizedObject(o);
                }
            } else {
                this.handleUnrecognizedObject(doc.getRootObject());
            }
        }
        catch (IOException e) {
            String message = Logging.getMessage((String)"generic.ExceptionAttemptingToReadGeoJSON", (Object[])new Object[]{docSource});
            Logging.logger().log(Level.SEVERE, message, e);
            throw new WWRuntimeException(message, (Throwable)e);
        }
        finally {
            WWIO.closeStream((Object)doc, (String)docSource.toString());
        }
    }

    public void addGeoJSONGeometryToLayer(GeoJSONObject object, RenderableLayer layer) {
        if (object == null) {
            String message = Logging.getMessage((String)"nullValue.ObjectIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (layer == null) {
            String message = Logging.getMessage((String)"nullValue.LayerIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (object.isGeometry()) {
            this.addRenderableForGeometry(object.asGeometry(), layer, null);
        } else if (object.isFeature()) {
            this.addRenderableForFeature(object.asFeature(), layer);
        } else if (object.isFeatureCollection()) {
            this.addRenderableForFeatureCollection(object.asFeatureCollection(), layer);
        } else {
            this.handleUnrecognizedObject(object);
        }
    }

    public Layer createLayerFromSource(Object docSource) {
        if (WWUtil.isEmpty((Object)docSource)) {
            String message = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        RenderableLayer layer = new RenderableLayer();
        this.addSourceGeometryToLayer(docSource, layer);
        return layer;
    }

    public Layer createLayerFromGeoJSON(GeoJSONObject object) {
        if (object == null) {
            String message = Logging.getMessage((String)"nullValue.ObjectIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        RenderableLayer layer = new RenderableLayer();
        this.addGeoJSONGeometryToLayer(object, layer);
        return layer;
    }

    protected void handleUnrecognizedObject(Object o) {
        Logging.logger().warning(Logging.getMessage((String)"generic.UnrecognizedObjectType", (Object[])new Object[]{o}));
    }

    protected void addRenderableForGeometry(GeoJSONGeometry geom, RenderableLayer layer, AVList properties) {
        if (geom.isPoint()) {
            this.addRenderableForPoint(geom.asPoint(), layer, properties);
        } else if (geom.isMultiPoint()) {
            this.addRenderableForMultiPoint(geom.asMultiPoint(), layer, properties);
        } else if (geom.isLineString()) {
            this.addRenderableForLineString(geom.asLineString(), layer, properties);
        } else if (geom.isMultiLineString()) {
            this.addRenderableForMutiLineString(geom.asMultiLineString(), layer, properties);
        } else if (geom.isPolygon()) {
            this.addRenderableForPolygon(geom.asPolygon(), layer, properties);
        } else if (geom.isMultiPolygon()) {
            this.addRenderableForMultiPolygon(geom.asMultiPolygon(), layer, properties);
        } else if (geom.isGeometryCollection()) {
            this.addRenderableForGeometryCollection(geom.asGeometryCollection(), layer, properties);
        } else {
            this.handleUnrecognizedObject(geom);
        }
    }

    protected void addRenderableForGeometryCollection(GeoJSONGeometryCollection c, RenderableLayer layer, AVList properties) {
        if (c.getGeometries() == null || c.getGeometries().length == 0) {
            return;
        }
        for (GeoJSONGeometry geom : c.getGeometries()) {
            this.addRenderableForGeometry(geom, layer, properties);
        }
    }

    protected void addRenderableForFeature(GeoJSONFeature feature, RenderableLayer layer) {
        if (feature.getGeometry() == null) {
            Logging.logger().warning(Logging.getMessage((String)"nullValue.GeometryIsNull"));
            return;
        }
        this.addRenderableForGeometry(feature.getGeometry(), layer, feature.getProperties());
    }

    protected void addRenderableForFeatureCollection(GeoJSONFeatureCollection c, RenderableLayer layer) {
        if (c.getFeatures() != null && c.getFeatures().length == 0) {
            return;
        }
        for (GeoJSONFeature feat : c.getFeatures()) {
            this.addRenderableForFeature(feat, layer);
        }
    }

    protected void addRenderableForPoint(GeoJSONPoint geom, RenderableLayer layer, AVList properties) {
        PointPlacemarkAttributes attrs = this.createPointAttributes((GeoJSONGeometry)geom, (Layer)layer);
        layer.addRenderable(this.createPoint((GeoJSONGeometry)geom, geom.getPosition(), attrs, properties));
    }

    protected void addRenderableForMultiPoint(GeoJSONMultiPoint geom, RenderableLayer layer, AVList properties) {
        PointPlacemarkAttributes attrs = this.createPointAttributes((GeoJSONGeometry)geom, (Layer)layer);
        for (int i = 0; i < geom.getPointCount(); ++i) {
            layer.addRenderable(this.createPoint((GeoJSONGeometry)geom, geom.getPosition(i), attrs, properties));
        }
    }

    protected void addRenderableForLineString(GeoJSONLineString geom, RenderableLayer layer, AVList properties) {
        ShapeAttributes attrs = this.createPolylineAttributes((GeoJSONGeometry)geom, (Layer)layer);
        layer.addRenderable(this.createPolyline((GeoJSONGeometry)geom, (Iterable<? extends Position>)geom.getCoordinates(), attrs, properties));
    }

    protected void addRenderableForMutiLineString(GeoJSONMultiLineString geom, RenderableLayer layer, AVList properties) {
        ShapeAttributes attrs = this.createPolylineAttributes((GeoJSONGeometry)geom, (Layer)layer);
        for (GeoJSONPositionArray coords : geom.getCoordinates()) {
            layer.addRenderable(this.createPolyline((GeoJSONGeometry)geom, (Iterable<? extends Position>)coords, attrs, properties));
        }
    }

    protected void addRenderableForPolygon(GeoJSONPolygon geom, RenderableLayer layer, AVList properties) {
        ShapeAttributes attrs = this.createPolygonAttributes((GeoJSONGeometry)geom, (Layer)layer);
        layer.addRenderable(this.createPolygon((GeoJSONGeometry)geom, (Iterable<? extends Position>)geom.getExteriorRing(), (Iterable<? extends Position>[])geom.getInteriorRings(), attrs, properties));
    }

    protected void addRenderableForMultiPolygon(GeoJSONMultiPolygon geom, RenderableLayer layer, AVList properties) {
        ShapeAttributes attrs = this.createPolygonAttributes((GeoJSONGeometry)geom, (Layer)layer);
        for (int i = 0; i < geom.getPolygonCount(); ++i) {
            layer.addRenderable(this.createPolygon((GeoJSONGeometry)geom, (Iterable<? extends Position>)geom.getExteriorRing(i), (Iterable<? extends Position>[])geom.getInteriorRings(i), attrs, properties));
        }
    }

    protected Renderable createPoint(GeoJSONGeometry owner, Position pos, PointPlacemarkAttributes attrs, AVList properties) {
        PointPlacemark p = new PointPlacemark(pos);
        p.setAttributes(attrs);
        if (pos.getAltitude() != 0.0) {
            p.setAltitudeMode(0);
            p.setLineEnabled(true);
        } else {
            p.setAltitudeMode(1);
        }
        if (properties != null) {
            p.setValue("gov.nasa.worldwind.avkey.Properties", (Object)properties);
        }
        return p;
    }

    protected Renderable createPolyline(GeoJSONGeometry owner, Iterable<? extends Position> positions, ShapeAttributes attrs, AVList properties) {
        if (GeoJSONLoader.positionsHaveNonzeroAltitude(positions)) {
            Path p = new Path();
            p.setPositions(positions);
            p.setAltitudeMode(0);
            p.setAttributes(attrs);
            if (properties != null) {
                p.setValue("gov.nasa.worldwind.avkey.Properties", (Object)properties);
            }
            return p;
        }
        SurfacePolyline sp = new SurfacePolyline(attrs, positions);
        if (properties != null) {
            sp.setValue("gov.nasa.worldwind.avkey.Properties", (Object)properties);
        }
        return sp;
    }

    protected Renderable createPolygon(GeoJSONGeometry owner, Iterable<? extends Position> outerBoundary, Iterable<? extends Position>[] innerBoundaries, ShapeAttributes attrs, AVList properties) {
        if (GeoJSONLoader.positionsHaveNonzeroAltitude(outerBoundary)) {
            Polygon poly = new Polygon(outerBoundary);
            poly.setAttributes(attrs);
            if (innerBoundaries != null) {
                for (Iterable<? extends Position> iter : innerBoundaries) {
                    poly.addInnerBoundary(iter);
                }
            }
            if (properties != null) {
                poly.setValue("gov.nasa.worldwind.avkey.Properties", (Object)properties);
            }
            return poly;
        }
        SurfacePolygon poly = new SurfacePolygon(attrs, outerBoundary);
        if (innerBoundaries != null) {
            for (Iterable<? extends Position> iter : innerBoundaries) {
                poly.addInnerBoundary(iter);
            }
        }
        if (properties != null) {
            poly.setValue("gov.nasa.worldwind.avkey.Properties", (Object)properties);
        }
        return poly;
    }

    protected static boolean positionsHaveNonzeroAltitude(Iterable<? extends Position> positions) {
        for (Position position : positions) {
            if (position.getAltitude() == 0.0) continue;
            return true;
        }
        return false;
    }

    protected PointPlacemarkAttributes createPointAttributes(GeoJSONGeometry geom, Layer layer) {
        if (layer == null) {
            return randomAttrs.nextAttributes().asPointAttributes();
        }
        String key = this.getClass().getName() + ".PointAttributes";
        PointPlacemarkAttributes attrs = (PointPlacemarkAttributes)layer.getValue(key);
        if (attrs == null) {
            attrs = randomAttrs.nextAttributes().asPointAttributes();
            layer.setValue(key, (Object)attrs);
        }
        return attrs;
    }

    protected ShapeAttributes createPolylineAttributes(GeoJSONGeometry geom, Layer layer) {
        if (layer == null) {
            return randomAttrs.nextAttributes().asShapeAttributes();
        }
        String key = this.getClass().getName() + ".PolylineAttributes";
        ShapeAttributes attrs = (ShapeAttributes)layer.getValue(key);
        if (attrs == null) {
            attrs = randomAttrs.nextAttributes().asShapeAttributes();
            layer.setValue(key, (Object)attrs);
        }
        return attrs;
    }

    protected ShapeAttributes createPolygonAttributes(GeoJSONGeometry geom, Layer layer) {
        if (layer == null) {
            return randomAttrs.nextAttributes().asShapeAttributes();
        }
        String key = this.getClass().getName() + ".PolygonAttributes";
        ShapeAttributes attrs = (ShapeAttributes)layer.getValue(key);
        if (attrs == null) {
            attrs = randomAttrs.nextAttributes().asShapeAttributes();
            layer.setValue(key, (Object)attrs);
        }
        return attrs;
    }
}

