/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.custom_image;

import gov.nasa.worldwind.layers.SurfaceImageLayer;
import java.io.File;
import java.io.IOException;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.LayerBundleManager;
import org.openide.util.Exceptions;
import se.trixon.almond.util.swing.FileHelper;

public class ImageLayerBundle
extends LayerBundle {
    private SurfaceImageLayer mLayer = new SurfaceImageLayer();

    public ImageLayerBundle() {
        this.mLayer.setOpacity(1.0);
        this.mLayer.setPickEnabled(false);
        this.mLayer.setName("Custom Images");
    }

    @Override
    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.setPopulated(true);
    }

    private void loadImages(File dir) {
        for (File file : dir.listFiles()) {
            try {
                this.mLayer.addImage(file.getAbsolutePath());
                System.out.println("loading " + file.getAbsolutePath());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void refresh() {
        Thread thread = new Thread(() -> {
            File dir = new File(FileHelper.getDefaultDirectory(), "test/img");
            this.loadImages(dir);
            LayerBundleManager.getInstance().redraw();
        }, this.getClass().getCanonicalName());
        thread.setPriority(1);
        thread.start();
    }
}

