/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.file_renderer;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.geometry.Point2D;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.MLatLon;
import org.mapton.api.file_opener.GeoCoordinateFileOpener;
import org.mapton.worldwind.api.CoordinateFileRendererWW;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.WWHelper;
import org.openide.util.Exceptions;
import se.trixon.almond.util.GraphicsHelper;
import se.trixon.almond.util.MathHelper;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoLine;
import se.trixon.almond.util.io.GeoPoint;

public class GeoRenderer
extends CoordinateFileRendererWW {
    private BasicAirspaceAttributes mCircleAttributes;
    private final HashMap<String, BasicShapeAttributes> mColorToAttributeMap = new HashMap();
    private BasicShapeAttributes mLineBasicShapeAttributes;

    public GeoRenderer() {
        this.addSupportedFileOpeners(GeoCoordinateFileOpener.class);
        this.initAttributes();
    }

    @Override
    public void init(LayerBundle layerBundle) {
        this.setLayerBundle(layerBundle);
    }

    @Override
    protected void load(MCoordinateFile coordinateFile) {
        this.mCooTrans = coordinateFile.getCooTrans();
        new Thread(() -> {
            try {
                Geo geo = new Geo();
                geo.read(coordinateFile.getFile());
                RenderableLayer layer = new RenderableLayer();
                layer.setPickEnabled(false);
                this.renderPoints(layer, geo.getPoints(), this.mCircleAttributes);
                double elevation = 0.1;
                List<GeoPoint> linePoints = this.renderLines(layer, geo.getLines(), elevation, this.mLineBasicShapeAttributes);
                this.renderPoints(layer, linePoints, this.mCircleAttributes);
                this.addLayer(coordinateFile, (Layer)layer);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, this.getClass().getName() + " Load").start();
    }

    @Override
    protected void render() {
        for (MCoordinateFile coordinateFile : this.mCoordinateFileManager.getSublistBySupportedOpeners(this.getSupportedFileOpeners())) {
            this.render(coordinateFile);
        }
    }

    private void addCurvePoint(ArrayList<Position> positions, Point2D sourcePoint, double angle, double radius, double elevation) {
        double x = Math.cos(angle / 180.0 * Math.PI) * radius;
        double y = Math.sin(angle / 180.0 * Math.PI) * radius;
        Point2D destPoint = sourcePoint.add(y, x);
        Point2D destWgs84Point = this.mCooTrans.toWgs84(destPoint.getY(), destPoint.getX());
        positions.add(Position.fromDegrees((double)destWgs84Point.getY(), (double)destWgs84Point.getX(), (double)elevation));
    }

    private void initAttributes() {
        this.mLineBasicShapeAttributes = new BasicShapeAttributes();
        this.mLineBasicShapeAttributes.setDrawInterior(false);
        this.mLineBasicShapeAttributes.setOutlineMaterial(Material.RED);
        this.mLineBasicShapeAttributes.setOutlineWidth(1.0);
        this.mLineBasicShapeAttributes.setEnableAntialiasing(false);
        this.mLineBasicShapeAttributes.setEnableLighting(false);
        this.mCircleAttributes = new BasicAirspaceAttributes((ShapeAttributes)this.mLineBasicShapeAttributes);
    }

    private void renderCurvedLine(RenderableLayer layer, GeoLine geoLine, double elevation, BasicShapeAttributes attributes) {
        ArrayList<Position> straightPositions = new ArrayList<Position>();
        ArrayList<Position> curvePositions = new ArrayList<Position>();
        for (int i = 0; i < geoLine.getPoints().size(); ++i) {
            double radius;
            GeoPoint geoPoint = (GeoPoint)geoLine.getPoints().get(i);
            Point2D p = this.mCooTrans.toWgs84(geoPoint.getX().doubleValue(), geoPoint.getY().doubleValue());
            if (!StringUtils.equalsIgnoreCase((CharSequence)geoPoint.getSpecialCode(), (CharSequence)"R")) {
                straightPositions.add(Position.fromDegrees((double)p.getY(), (double)p.getX(), (double)elevation));
                continue;
            }
            if (!straightPositions.isEmpty()) {
                straightPositions.add(Position.fromDegrees((double)p.getY(), (double)p.getX(), (double)elevation));
                this.renderLine(layer, new ArrayList<Position>(straightPositions), false, attributes);
                straightPositions.clear();
            }
            if (i == geoLine.getPoints().size() - 1) break;
            GeoPoint nextGeoPoint = (GeoPoint)geoLine.getPoints().get(i + 1);
            Point2D sourcePoint2d = new Point2D(geoPoint.getY().doubleValue(), geoPoint.getX().doubleValue());
            Point2D destPoint2d = new Point2D(nextGeoPoint.getY().doubleValue(), nextGeoPoint.getX().doubleValue());
            try {
                radius = Double.parseDouble(geoPoint.getRemark());
            }
            catch (NumberFormatException e) {
                radius = sourcePoint2d.distance(destPoint2d);
            }
            Point2D centerPoint2d = MathHelper.calculateCircleCenter((Point2D)sourcePoint2d, (Point2D)destPoint2d, (double)radius);
            Point2D sourcePoint2dW84 = this.mCooTrans.toWgs84(sourcePoint2d.getY(), sourcePoint2d.getX());
            Point2D destPoint2dW84 = this.mCooTrans.toWgs84(destPoint2d.getY(), destPoint2d.getX());
            Point2D centerPoint2dW84 = this.mCooTrans.toWgs84(centerPoint2d.getY(), centerPoint2d.getX());
            MLatLon sourceLatLon = new MLatLon(sourcePoint2dW84.getY(), sourcePoint2dW84.getX());
            MLatLon destLatLon = new MLatLon(destPoint2dW84.getY(), destPoint2dW84.getX());
            MLatLon centerLatLon = new MLatLon(centerPoint2dW84.getY(), centerPoint2dW84.getX());
            double absR = Math.abs(radius);
            double sourceBearing = centerLatLon.getBearing(sourceLatLon);
            double destBearing = centerLatLon.getBearing(destLatLon);
            double angleStep = (sourceBearing < destBearing ? 1.0 : -1.0) * 2.0;
            MLatLon lastLatLon = destLatLon;
            if (Math.signum(destBearing - sourceBearing) != Math.signum(radius)) {
                lastLatLon = sourceLatLon;
                double x = destBearing;
                destBearing = sourceBearing;
                if (destBearing < 0.0) {
                    destBearing += 360.0;
                }
                if ((sourceBearing = x) < 0.0) {
                    sourceBearing += 360.0;
                }
            }
            if (sourceBearing < destBearing) {
                for (angle = sourceBearing; angle < destBearing; angle += angleStep) {
                    this.addCurvePoint(curvePositions, centerPoint2d, angle, absR, elevation);
                }
            } else {
                for (angle = sourceBearing; angle > destBearing; angle += angleStep) {
                    this.addCurvePoint(curvePositions, centerPoint2d, angle, absR, elevation);
                }
            }
            curvePositions.add(WWHelper.positionFromLatLon(lastLatLon, elevation));
        }
        this.renderLine(layer, curvePositions, false, attributes);
        if (!straightPositions.isEmpty()) {
            this.renderLine(layer, straightPositions, false, attributes);
        }
    }

    private void renderLine(RenderableLayer layer, List<Position> positions, boolean closed, BasicShapeAttributes attributes) {
        try {
            if (positions.size() > 1) {
                Object path = closed ? new Polygon(positions) : new Path(positions);
                path.setAttributes((ShapeAttributes)attributes);
                path.setAltitudeMode(0);
                layer.addRenderable((Renderable)path);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.format("%s: %s, %s\n", this.getClass().getSimpleName(), "Invalid path", e.getMessage());
        }
    }

    private List<GeoPoint> renderLines(RenderableLayer layer, List<GeoLine> geoLines, double elevation, BasicShapeAttributes attributes) {
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        for (GeoLine geoLine : geoLines) {
            ArrayList<Position> positions = new ArrayList<Position>();
            boolean ordinaryLine = true;
            BasicShapeAttributes attrs = null;
            try {
                if (geoLine.getAttributes().containsKey("COLOR")) {
                    String intString = (String)geoLine.getAttributes().get("COLOR");
                    attrs = this.mColorToAttributeMap.computeIfAbsent(intString, k -> {
                        BasicShapeAttributes a = new BasicShapeAttributes((ShapeAttributes)attributes);
                        Integer intColor = Integer.valueOf(intString);
                        a.setOutlineMaterial(new Material(GraphicsHelper.colorFromInt((int)intColor)));
                        return a;
                    });
                }
            }
            catch (Exception intString) {
                // empty catch block
            }
            if (attrs == null) {
                attrs = new BasicShapeAttributes((ShapeAttributes)attributes);
            }
            for (GeoPoint geoPoint : geoLine.getPoints()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)geoPoint.getSpecialCode(), (CharSequence)"C")) {
                    geoPoints.add(geoPoint);
                }
                if (this.mCooTrans.isWithinProjectedBounds(geoPoint.getX().doubleValue(), geoPoint.getY().doubleValue())) {
                    Point2D p = this.mCooTrans.toWgs84(geoPoint.getX().doubleValue(), geoPoint.getY().doubleValue());
                    elevation = MathHelper.convertDoubleToDouble((Double)geoPoint.getZ());
                    positions.add(Position.fromDegrees((double)p.getY(), (double)p.getX(), (double)elevation));
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)geoPoint.getSpecialCode(), (CharSequence)"R")) continue;
                ordinaryLine = false;
            }
            if (ordinaryLine) {
                this.renderLine(layer, positions, geoLine.isClosedPolygon(), attrs);
                continue;
            }
            try {
                this.renderCurvedLine(layer, geoLine, elevation, attrs);
            }
            catch (Exception e) {
                System.err.println("xxxxx");
                System.err.println(e);
            }
        }
        return geoPoints;
    }

    private void renderPoints(RenderableLayer layer, List<GeoPoint> geoPoints, BasicAirspaceAttributes circleAttributes) {
        for (GeoPoint geoPoint : geoPoints) {
            if (!this.mCooTrans.isWithinProjectedBounds(geoPoint.getX().doubleValue(), geoPoint.getY().doubleValue())) continue;
            Point2D p = this.mCooTrans.toWgs84(geoPoint.getX().doubleValue(), geoPoint.getY().doubleValue());
            Position position = Position.fromDegrees((double)p.getY(), (double)p.getX());
            if (StringUtils.equalsIgnoreCase((CharSequence)geoPoint.getSpecialCode(), (CharSequence)"C")) {
                String remark = StringUtils.replace((String)geoPoint.getRemark(), (String)"_", (String)" ");
                String[] raw = StringUtils.split((String)remark, (String)" ");
                String raw2 = StringUtils.replace((String)raw[0], (String)",", (String)".");
                double r = Double.parseDouble(raw2);
                CappedCylinder cappedCylinder = new CappedCylinder((LatLon)position, r);
                cappedCylinder.setAltitudes(0.0, 0.1);
                cappedCylinder.setCenter((LatLon)position);
                cappedCylinder.setRadii(r, r + 0.05);
                cappedCylinder.setAttributes((AirspaceAttributes)circleAttributes);
                layer.addRenderable((Renderable)cappedCylinder);
                continue;
            }
            PointPlacemark pointPlacemark = new PointPlacemark(position);
            pointPlacemark.setLabelText(geoPoint.getPointId());
            pointPlacemark.setAltitudeMode(1);
            pointPlacemark.setEnableLabelPicking(true);
            layer.addRenderable((Renderable)pointPlacemark);
        }
    }
}

