/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.file_renderer;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SurfaceImageLayer;
import java.io.File;
import java.io.IOException;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.file_opener.GeoTiffCoordinateFileOpener;
import org.mapton.worldwind.api.CoordinateFileRendererWW;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.LayerBundleManager;
import org.openide.util.Exceptions;

public class GeoTiffRenderer
extends CoordinateFileRendererWW {
    public GeoTiffRenderer() {
        this.addSupportedFileOpeners(GeoTiffCoordinateFileOpener.class);
    }

    @Override
    public void init(LayerBundle layerBundle) {
        this.setLayerBundle(layerBundle);
    }

    @Override
    protected void load(MCoordinateFile coordinateFile) {
        try {
            File sourceFile = coordinateFile.getFile();
            SurfaceImageLayer layer = new SurfaceImageLayer();
            layer.setPickEnabled(false);
            layer.addImage(sourceFile.getPath());
            layer.addPropertyChangeListener("Enabled", pce -> {
                LayerList layers = LayerBundleManager.getInstance().getWwd().getModel().getLayers();
                layers.remove((Layer)layer);
                layers.add((Layer)layer);
            });
            this.addLayer(coordinateFile, (Layer)layer);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected void render() {
        for (MCoordinateFile coordinateFile : this.mCoordinateFileManager.getSublistBySupportedOpeners(this.getSupportedFileOpeners())) {
            this.render(coordinateFile);
        }
    }
}

