/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.file_renderer;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.impl.KMLController;
import gov.nasa.worldwind.render.Renderable;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.file_opener.KmlCoordinateFileOpener;
import org.mapton.worldwind.api.CoordinateFileRendererWW;
import org.mapton.worldwind.api.LayerBundle;
import org.openide.util.Exceptions;

public class KmlRenderer
extends CoordinateFileRendererWW {
    public KmlRenderer() {
        this.addSupportedFileOpeners(KmlCoordinateFileOpener.class);
    }

    @Override
    public void init(LayerBundle layerBundle) {
        this.setLayerBundle(layerBundle);
    }

    @Override
    protected void load(MCoordinateFile coordinateFile) {
        RenderableLayer layer = new RenderableLayer();
        layer.setPickEnabled(false);
        try {
            KMLRoot kmlRoot = KMLRoot.createAndParse((Object)coordinateFile.getFile());
            layer.addRenderable((Renderable)new KMLController(kmlRoot));
            this.addLayer(coordinateFile, (Layer)layer);
        }
        catch (IOException | XMLStreamException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected void render() {
        for (MCoordinateFile coordinateFile : this.mCoordinateFileManager.getSublistBySupportedOpeners(this.getSupportedFileOpeners())) {
            this.render(coordinateFile);
        }
    }
}

