/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.ruler;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.ColorMode;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.measure.MeasureTool;
import java.awt.Color;
import java.util.ArrayList;
import javafx.geometry.Point3D;
import org.mapton.api.MKmlCreator;
import se.trixon.almond.util.fx.FxHelper;

class KmlFeatureGenerator
extends MKmlCreator {
    private final String mDescription;
    private final MeasureTool mMeasureTool;
    private final String mTitle;

    KmlFeatureGenerator(String title, String description, MeasureTool measureTool) {
        this.mTitle = title;
        this.mDescription = description;
        this.mMeasureTool = measureTool;
    }

    Feature generate() {
        switch (this.mMeasureTool.getMeasureShapeType()) {
            case "MeasureTool.ShapeLine": 
            case "MeasureTool.ShapePath": {
                return this.generateLine();
            }
            case "MeasureTool.ShapeEllipse": 
            case "MeasureTool.ShapePolygon": 
            case "MeasureTool.ShapeSquare": 
            case "MeasureTool.ShapeQuad": {
                return this.generatePolygon();
            }
            case "MeasureTool.ShapeCircle": {
                return this.generateCircle();
            }
        }
        return null;
    }

    private Feature generateCircle() {
        Position center = this.mMeasureTool.getCenterPosition();
        double lat = center.getLatitude().getDegrees();
        double lon = center.getLongitude().getDegrees();
        double radius = this.mMeasureTool.getHeight() / 2.0;
        int quality = 100;
        Placemark placemark = this.createCircle(this.mTitle, lat, lon, radius, quality, this.mMeasureTool.getLineWidth(), this.getColorLine(), this.getColorFill(), ColorMode.NORMAL, AltitudeMode.CLAMP_TO_GROUND);
        placemark.setDescription(this.mDescription);
        return placemark;
    }

    private Feature generateLine() {
        Placemark placemark = this.createLine(this.mTitle, this.getCoordinates(), this.mMeasureTool.getLineWidth(), this.getColorLine(), AltitudeMode.CLAMP_TO_GROUND);
        placemark.setDescription(this.mDescription);
        return placemark;
    }

    private Feature generatePolygon() {
        Placemark placemark = this.createPolygon(this.mTitle, this.getCoordinates(), this.mMeasureTool.getLineWidth(), this.getColorLine(), this.getColorFill(), ColorMode.NORMAL, AltitudeMode.CLAMP_TO_GROUND);
        placemark.setDescription(this.mDescription);
        return placemark;
    }

    private String getColorFill() {
        return FxHelper.colorToHexABGR((Color)this.mMeasureTool.getFillColor());
    }

    private String getColorLine() {
        return FxHelper.colorToHexABGR((Color)this.mMeasureTool.getLineColor());
    }

    private ArrayList<Point3D> getCoordinates() {
        ArrayList<Point3D> coordinates = new ArrayList<Point3D>();
        for (Position p : this.mMeasureTool.getPositions()) {
            Point3D c = new Point3D(p.getLongitude().getDegrees(), p.getLatitude().getDegrees(), 0.0);
            coordinates.add(c);
        }
        return coordinates;
    }
}

