/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.worldwind.ruler;

import gov.nasa.worldwind.WorldWindow;
import javafx.application.Platform;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.mapton.worldwind.ruler.RulerTab;
import se.trixon.almond.util.fx.FxHelper;

public class RulerTabPane
extends TabPane {
    private int mTabCounter = 0;
    private WorldWindow mWorldWindow;

    public static RulerTabPane getInstance() {
        return Holder.INSTANCE;
    }

    private RulerTabPane() {
        this.createUI();
        this.initListeners();
    }

    public void refresh(WorldWindow worldWindow) {
        this.mWorldWindow = worldWindow;
        this.addTab();
    }

    private void addTab() {
        Platform.runLater(() -> {
            RulerTab rulerTab = new RulerTab(Integer.toString(++this.mTabCounter), this.mWorldWindow);
            this.getTabs().add((Object)rulerTab);
            this.getSelectionModel().select((Object)rulerTab);
        });
    }

    private void createUI() {
        Tab plusTab = new Tab("+");
        plusTab.setClosable(false);
        this.getTabs().add((Object)plusTab);
        this.setPrefWidth(FxHelper.getUIScaled((int)300));
    }

    private void initListeners() {
        this.getSelectionModel().selectedItemProperty().addListener((ov, oldTab, newTab) -> {
            if (oldTab instanceof RulerTab) {
                RulerTab rulerTab = (RulerTab)((Object)oldTab);
                rulerTab.getMeasureTool().setArmed(false);
            }
            if (this.getSelectionModel().getSelectedIndex() == 0) {
                this.addTab();
            }
        });
    }

    private static class Holder {
        private static final RulerTabPane INSTANCE = new RulerTabPane();

        private Holder() {
        }
    }
}

