/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.transformation;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.geotools.geometry.DirectPosition3D;
import org.geotools.referencing.CRS;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MCrsManager;
import org.mapton.api.Mapton;
import org.mapton.transformation.CrsListCell;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.MathHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.LogPanel;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.io.CoordinateFormat;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoLine;
import se.trixon.almond.util.io.GeoPoint;
import se.trixon.almond.util.swing.FileHelper;

public class TransformationView
extends BorderPane {
    private final ResourceBundle mBundle = NbBundle.getBundle(TransformationView.class);
    private final ComboBox<CoordinateReferenceSystem> mDestComboBox = new ComboBox();
    private Geo mDestGeo;
    private final LogPanel mDestLogPanel = new LogPanel();
    private File mFile;
    private final MCrsManager mManager = MCrsManager.getInstance();
    private final ComboBox<CoordinateReferenceSystem> mSourceComboBox = new ComboBox();
    private Geo mSourceGeo;
    private final LogPanel mSourceLogPanel = new LogPanel();
    private final Spinner<Integer> mXYSpinner = new Spinner(0, 9, 3);
    private final Spinner<Integer> mZSpinner = new Spinner(0, 9, 3);
    private final Label mSourceLabel = new Label();

    public TransformationView() {
        this.createUI();
        this.initListeners();
        this.mSourceComboBox.setItems(this.mManager.getSelectedSystems());
        this.mDestComboBox.setItems(this.mManager.getSelectedSystems());
    }

    private void clear() {
        this.mSourceLogPanel.clear();
        this.mDestLogPanel.clear();
        this.mFile = null;
        this.mSourceGeo = null;
        this.mDestGeo = null;
        this.mSourceLabel.setText("");
    }

    private void createUI() {
        Action transformAction = new Action(this.mBundle.getString("transform"), event -> {
            if (ObjectUtils.allNotNull((Object[])new Object[]{this.mFile, this.mSourceComboBox.getValue(), this.mDestComboBox.getValue()})) {
                this.transform();
            }
        });
        transformAction.setGraphic((Node)MaterialIcon._Image.LEAK_REMOVE.getImageView(Mapton.getIconSizeToolBarInt()));
        Action saveAction = new Action(Dict.SAVE.toString(), event -> this.save());
        saveAction.setGraphic((Node)MaterialIcon._Content.SAVE.getImageView(Mapton.getIconSizeToolBarInt()));
        Action clearAction = new Action(Dict.CLEAR.toString(), event -> this.clear());
        clearAction.setGraphic((Node)MaterialIcon._Content.CLEAR.getImageView(Mapton.getIconSizeToolBarInt()));
        List<Action> actions = Arrays.asList(transformAction, saveAction, ActionUtils.ACTION_SPAN, clearAction);
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.SHOW);
        FxHelper.slimToolBar((ToolBar)toolBar);
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        GridPane gridPane = new GridPane();
        Label fromLabel = new Label(Dict.FROM.toString());
        Label toLabel = new Label(Dict.TO.toString());
        Label xyLabel = new Label("XY:");
        Label zLabel = new Label("Z:");
        HBox sourceBox = new HBox(new Node[]{fromLabel, this.mSourceComboBox, this.mSourceLabel});
        HBox destBox = new HBox(new Node[]{toLabel, this.mDestComboBox, xyLabel, this.mXYSpinner, zLabel, this.mZSpinner});
        sourceBox.setAlignment(Pos.CENTER_LEFT);
        destBox.setAlignment(Pos.CENTER_LEFT);
        Insets insets = FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)8.0);
        FxHelper.setPadding((Insets)insets, (Region[])new Region[]{this.mSourceLabel, xyLabel, zLabel});
        gridPane.addRow(0, new Node[]{sourceBox, destBox});
        gridPane.addRow(1, new Node[]{this.mSourceLogPanel, this.mDestLogPanel});
        FxHelper.autoSizeColumn((GridPane)gridPane, (int)2);
        gridPane.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.mSourceLogPanel.setPromptText(this.mBundle.getString("prompt_source"));
        this.mSourceLogPanel.setFont(Font.font((String)"monospaced"));
        this.mSourceLogPanel.prefHeightProperty().bind((ObservableValue)gridPane.heightProperty());
        this.mDestLogPanel.setFont(Font.font((String)"monospaced"));
        this.mSourceComboBox.setCellFactory(list -> new CrsListCell());
        this.mSourceComboBox.setButtonCell((ListCell)new CrsListCell());
        this.mDestComboBox.setCellFactory(list -> new CrsListCell());
        this.mDestComboBox.setButtonCell((ListCell)new CrsListCell());
        this.setTop((Node)toolBar);
        this.setCenter((Node)gridPane);
    }

    private void initListeners() {
        this.mSourceLogPanel.setOnDragOver(dragEvent -> {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragboard.hasFiles()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.mSourceLogPanel.setOnDragDropped(dragEvent -> this.open((File)dragEvent.getDragboard().getFiles().get(0)));
    }

    private void open(File file) {
        this.mFile = file;
        this.mSourceLabel.setText(file.getName());
        this.mSourceLabel.setTooltip(new Tooltip(file.getAbsolutePath()));
        try {
            this.mSourceGeo = new Geo();
            this.mSourceGeo.read(file);
            this.mSourceLogPanel.setText(this.mSourceGeo.toString());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void save() {
        String toSystem = StringUtils.substringAfter((String)((CoordinateReferenceSystem)this.mDestComboBox.getValue()).getName().toString(), (String)":");
        String name = "%s_%s.geo".formatted(FilenameUtils.getBaseName((String)this.mFile.getName()), toSystem);
        File templateFile = new File(this.mFile.getParentFile(), name);
        String dialogTitle = "%s %s".formatted(Dict.SAVE.toString(), Dict.COORDINATE_FILE.toString().toLowerCase());
        FileNameExtensionFilter geoExtensionFilter = (FileNameExtensionFilter)FileChooserHelper.getExtensionFilters().get("geo");
        JFileChooser fileChooser = new FileChooserBuilder(TransformationView.class).addFileFilter((FileFilter)geoExtensionFilter).setAcceptAllFileFilterUsed(false).setDefaultWorkingDirectory(FileHelper.getDefaultDirectory()).setFileFilter((FileFilter)geoExtensionFilter).setFilesOnly(true).setSelectionApprover(FileChooserHelper.getFileExistSelectionApprover((Component)Almond.getFrame())).setTitle(dialogTitle).createFileChooser();
        fileChooser.setSelectedFile(templateFile);
        if (fileChooser.showSaveDialog(Almond.getFrame()) == 0) {
            File file = FileChooserHelper.getFileWithProperExt((JFileChooser)fileChooser);
            new Thread(() -> {
                try {
                    switch (FilenameUtils.getExtension((String)file.getName())) {
                        case "geo": {
                            this.mDestGeo.write(file);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
        }
    }

    private void transform() {
        CoordinateReferenceSystem fromCrs = (CoordinateReferenceSystem)this.mSourceComboBox.getValue();
        CoordinateReferenceSystem toCrs = (CoordinateReferenceSystem)this.mDestComboBox.getValue();
        try {
            this.mDestGeo = new Geo();
            this.mDestGeo.read(this.mFile);
            this.mDestGeo.setCoordinateFormat(CoordinateFormat.FORMATTED);
            Integer xyValue = (Integer)this.mXYSpinner.getValue();
            Integer zValue = (Integer)this.mZSpinner.getValue();
            GeoPoint.setDecimalsX((int)xyValue);
            GeoPoint.setDecimalsY((int)xyValue);
            GeoPoint.setDecimalsZ((int)zValue);
            MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)fromCrs, (CoordinateReferenceSystem)toCrs, (boolean)false);
            for (GeoLine line : this.mDestGeo.getLines()) {
                for (GeoPoint point : line.getPoints()) {
                    this.transform(mathTransform, point);
                }
            }
            for (GeoPoint point : this.mDestGeo.getPoints()) {
                this.transform(mathTransform, point);
            }
            this.mDestLogPanel.setText(this.mDestGeo.toString());
        }
        catch (IOException | MismatchedDimensionException | FactoryException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void transform(MathTransform mathTransform, GeoPoint point) {
        try {
            double z = MathHelper.convertDoubleToDouble((Double)point.getZ());
            DirectPosition dp = mathTransform.transform((DirectPosition)new DirectPosition3D(point.getX().doubleValue(), point.getY().doubleValue(), z), null);
            point.setX(Double.valueOf(dp.getCoordinate()[0]));
            point.setY(Double.valueOf(dp.getCoordinate()[1]));
        }
        catch (MismatchedDimensionException | TransformException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

