/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;

public class AutoscrollListView<T>
extends ListView<T> {
    final double proximity = 20.0;
    private ScrollThread scrollThread;

    public AutoscrollListView() {
        this(FXCollections.observableArrayList());
    }

    public AutoscrollListView(ObservableList<T> items) {
        super(items);
        this.addEventFilter(DragEvent.DRAG_OVER, this::autoscrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_EXITED, this::stopAutoScrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_DROPPED, this::stopAutoScrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_DONE, this::stopAutoScrollIfNeeded);
    }

    private void autoscrollIfNeeded(DragEvent evt) {
        evt.acceptTransferModes(TransferMode.ANY);
        Object hotRegion = this.getClippedContainer();
        if (hotRegion.getBoundsInLocal().getWidth() < 1.0 && (hotRegion = this).getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded(evt);
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - hotRegion.localToScene(0.0, 0.0).getY();
        if (delta < 20.0) {
            yOffset = -(20.0 - delta);
        }
        if ((delta = hotRegion.localToScene(0.0, 0.0).getY() + hotRegion.getHeight() - evt.getSceneY()) < 20.0) {
            yOffset = 20.0 - delta;
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded(evt);
        }
    }

    private VirtualFlow<?> getVirtualFlow() {
        return (VirtualFlow)this.lookup("VirtualFlow");
    }

    private Region getClippedContainer() {
        for (Node child : this.getVirtualFlow().getChildrenUnmodifiable()) {
            if (!child.getStyleClass().contains((Object)"clipped-container")) continue;
            return (Region)child;
        }
        return null;
    }

    private void autoscroll(double yOffset) {
        if (this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
            this.scrollThread.start();
        }
        this.scrollThread.setDelta(yOffset);
    }

    private void stopAutoScrollIfNeeded(DragEvent evt) {
        if (this.scrollThread != null) {
            this.scrollThread.stopRunning();
            this.scrollThread = null;
        }
    }

    private class ScrollThread
    extends Thread {
        private boolean running;
        private double yOffset;

        ScrollThread() {
            super("Autoscrolling List View");
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (this.running) {
                Platform.runLater(() -> this.scrollY());
                try {
                    ScrollThread.sleep(15L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void scrollY() {
            VirtualFlow<?> flow = AutoscrollListView.this.getVirtualFlow();
            flow.scrollPixels(this.yOffset);
        }

        public void stopRunning() {
            this.running = false;
        }

        public void setDelta(double yOffset) {
            this.yOffset = yOffset;
        }
    }
}

