/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.GlassPane;
import com.dlsc.gemsfx.ResizableTextArea;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.RotateTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class DialogPane
extends Pane {
    private final GlassPane glassPane;
    private final ObservableList<ContentPane> dialogContentPanes = FXCollections.observableArrayList();
    private final Map<ContentPane, DoubleProperty> dialogVisibilityMap = new HashMap<ContentPane, DoubleProperty>();
    private final ListProperty<Dialog> dialogs = new SimpleListProperty((Object)this, "dialogs", FXCollections.observableArrayList());
    private final EventHandler<KeyEvent> escapeHandler = evt -> {
        Dialog dialog;
        if (evt.getCode() == KeyCode.ESCAPE && !this.dialogs.isEmpty() && !(dialog = (Dialog)this.dialogs.get(this.dialogs.size() - 1)).isCancelled()) {
            dialog.cancel();
            evt.consume();
        }
    };
    private final WeakEventHandler<KeyEvent> weakEscapeHandler = new WeakEventHandler(this.escapeHandler);
    private final BooleanProperty showCloseButton = new SimpleBooleanProperty((Object)this, "showCloseButton", true);
    private final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)100.0));
    private final BooleanProperty animateDialogs = new SimpleBooleanProperty((Object)this, "animateDialogs", true);
    private final BooleanProperty fadeInOut = new SimpleBooleanProperty((Object)this, "fadeInOut", true);
    private final ReadOnlyBooleanWrapper showingDialog = new ReadOnlyBooleanWrapper((Object)this, "showDialog", false);
    private final ObjectProperty<StringConverter<ButtonType>> converter = new SimpleObjectProperty((Object)this, "converter", (Object)new StringConverter<ButtonType>(){

        public String toString(ButtonType buttonType) {
            if (buttonType != null) {
                return buttonType.getText();
            }
            return "";
        }

        public ButtonType fromString(String string) {
            return null;
        }
    });

    public DialogPane() {
        this.getStyleClass().add((Object)"dialog-pane");
        this.showingDialog.bind((ObservableValue)this.dialogs.emptyProperty().not());
        this.mouseTransparentProperty().bind((ObservableValue)this.showingDialogProperty().not());
        this.glassPane = new GlassPane();
        this.glassPane.fadeInOutProperty().bind((ObservableValue)this.fadeInOutProperty());
        this.glassPane.fadeInOutDurationProperty().bind(this.animationDurationProperty());
        this.glassPane.hideProperty().bind((ObservableValue)this.dialogs.emptyProperty());
        this.dialogs.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(dialog -> {
                        ContentPane dialogPane = new ContentPane((Dialog<?>)dialog);
                        dialogPane.blockedProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.dialogContentPanes.isEmpty() && this.dialogContentPanes.get(this.dialogContentPanes.size() - 1) != dialogPane, (Observable[])new Observable[]{this.dialogContentPanes}));
                        this.dialogContentPanes.add((Object)dialogPane);
                        SimpleDoubleProperty visibility = new SimpleDoubleProperty();
                        visibility.addListener(it -> this.requestLayout());
                        this.dialogVisibilityMap.put(dialogPane, (DoubleProperty)visibility);
                        this.getChildren().add((Object)dialogPane);
                        this.slideInOut(1.0, (DoubleProperty)visibility, () -> dialogPane);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(dialog -> {
                    Optional<ContentPane> dialogOptional = this.dialogContentPanes.stream().filter(d -> d.getDialog() == dialog).findFirst();
                    if (dialogOptional.isPresent()) {
                        ContentPane dialogPane = dialogOptional.get();
                        DoubleProperty visibility = this.dialogVisibilityMap.get((Object)dialogPane);
                        this.slideInOut(0.0, visibility, () -> dialogPane);
                    }
                });
            }
        });
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clip);
        this.getChildren().add((Object)this.glassPane);
        this.sceneProperty().addListener((obs, oldScene, newScene) -> {
            if (oldScene != null) {
                oldScene.removeEventFilter(KeyEvent.KEY_PRESSED, this.weakEscapeHandler);
            }
            if (newScene != null) {
                newScene.addEventFilter(KeyEvent.KEY_PRESSED, this.weakEscapeHandler);
            }
        });
        this.getStylesheets().add((Object)this.getUserAgentStylesheet());
    }

    public String getUserAgentStylesheet() {
        return DialogPane.class.getResource("dialog.css").toExternalForm();
    }

    public boolean isShowCloseButton() {
        return this.showCloseButton.get();
    }

    public BooleanProperty showCloseButtonProperty() {
        return this.showCloseButton;
    }

    public void setShowCloseButton(boolean showCloseButton) {
        this.showCloseButton.set(showCloseButton);
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDuration.get();
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public void setAnimationDuration(Duration animationDuration) {
        this.animationDuration.set((Object)animationDuration);
    }

    public final <T> void showDialog(Dialog<T> dialog) {
        this.dialogs.add(dialog);
    }

    public final void hideDialog(Dialog<?> dialog) {
        this.dialogs.remove(dialog);
    }

    private Dialog<ButtonType> doShowDialog(Type type, String title, String message) {
        return this.doShowDialog(type, title, message, Collections.emptyList());
    }

    private Dialog<ButtonType> doShowDialog(Type type, String title, String message, List<ButtonType> buttons) {
        return this.showNode(type, title, (Node)new Label(message), buttons);
    }

    public final Dialog<Void> showError(String title, String message) {
        return this.showError(title, message, null, null);
    }

    public final Dialog<Void> showError(String title, String message, Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return this.showError(title, message, stringWriter.toString(), exception);
    }

    public final Dialog<Void> showError(String title, Exception exception) {
        return this.showError(title, exception.getMessage(), exception);
    }

    public final Dialog<Void> showError(String title, String message, Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return this.showError(title, message, stringWriter.toString(), exception);
    }

    public final Dialog<Void> showError(String title, String message, String details) {
        return this.showError(title, message, details, null);
    }

    private Dialog<Void> showError(String title, String message, String details, Throwable exception) {
        Dialog<Void> dialog = new Dialog<Void>(this, Type.ERROR);
        dialog.setTitle(title);
        Label messageLabel = new Label(message);
        messageLabel.setWrapText(true);
        messageLabel.setMaxWidth(500.0);
        if (StringUtils.isBlank((CharSequence)details)) {
            dialog.setContent((Node)messageLabel);
        } else {
            ResizableTextArea textArea = new ResizableTextArea();
            textArea.setText(details);
            textArea.getEditor().setWrapText(false);
            textArea.getEditor().setPrefColumnCount(80);
            textArea.setResizeHorizontal(true);
            textArea.setResizeVertical(true);
            textArea.getStyleClass().add((Object)"error-text-area");
            TitledPane titledPane = new TitledPane();
            titledPane.getStyleClass().add((Object)"error-details-titled-pane");
            titledPane.setText("Details");
            titledPane.setContent((Node)textArea);
            titledPane.setPrefHeight(300.0);
            VBox content = new VBox(new Node[]{messageLabel, titledPane});
            content.getStyleClass().add((Object)"container");
            dialog.setContent((Node)content);
        }
        dialog.setException(exception);
        this.dialogs.add(dialog);
        return dialog;
    }

    public final Dialog<ButtonType> showWarning(String title, String message) {
        return this.doShowDialog(Type.WARNING, title, message);
    }

    public final Dialog<ButtonType> showConfirmation(String title, String message) {
        return this.doShowDialog(Type.CONFIRMATION, title, message);
    }

    public final Dialog<ButtonType> showInformation(String title, String message) {
        return this.doShowDialog(Type.INFORMATION, title, message);
    }

    public final Dialog<ButtonType> showInformation(String title, String message, List<ButtonType> buttons) {
        return this.doShowDialog(Type.INFORMATION, title, message, buttons);
    }

    public final Dialog<String> showTextInput(String title, String text) {
        return this.showTextInput(title, null, null, text, false);
    }

    public final Dialog<String> showTextInput(String title, String text, boolean multiline) {
        return this.showTextInput(title, null, null, text, multiline);
    }

    public final Dialog<String> showTextInput(String title, String message, String text, boolean multiline) {
        return this.showTextInput(title, message, null, text, multiline);
    }

    public final Dialog<String> showTextInput(String title, String message, String prompt, String text, boolean multiline) {
        Object node;
        TextField textInputControl;
        if (multiline) {
            ResizableTextArea textArea = new ResizableTextArea(text);
            textArea.getEditor().setPromptText(prompt);
            textArea.getEditor().setWrapText(true);
            textArea.getEditor().setPrefRowCount(6);
            textArea.setResizeVertical(true);
            textArea.setResizeHorizontal(true);
            textArea.getEditor().skinProperty().addListener(it -> Platform.runLater(() -> textArea.getEditor().requestFocus()));
            textInputControl = textArea.getEditor();
            node = textArea;
        } else {
            TextField textField = new TextField(text);
            textField.setPromptText(prompt);
            textField.setPrefColumnCount(20);
            textField.skinProperty().addListener(it -> Platform.runLater(() -> textField.requestFocus()));
            textInputControl = textField;
            node = textField;
        }
        VBox box = new VBox();
        box.getStyleClass().add((Object)"prompt-node-wrapper");
        if (StringUtils.isNotBlank((CharSequence)message)) {
            Label promptLabel = new Label(message);
            box.getChildren().add((Object)promptLabel);
        }
        box.getChildren().add(node);
        Dialog<String> dialog = this.showNode(Type.INPUT, title, (Node)box);
        textInputControl.textProperty().addListener(arg_0 -> DialogPane.lambda$showTextInput$14(dialog, (TextInputControl)textInputControl, arg_0));
        return dialog;
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node) {
        return this.showNode(type, title, node, false, Collections.emptyList());
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize) {
        return this.showNode(type, title, node, maximize, Collections.emptyList());
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, List<ButtonType> buttons) {
        return this.showNode(type, title, node, false, buttons);
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize, List<ButtonType> buttons) {
        return this.showNode(type, title, node, maximize, buttons, true, null);
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize, List<ButtonType> buttons, boolean sameWidthButtons) {
        return this.showNode(type, title, node, maximize, buttons, sameWidthButtons, null);
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize, List<ButtonType> buttons, boolean sameWidthButtons, BooleanProperty validProperty) {
        Dialog dialog = new Dialog(this, type);
        dialog.setTitle(title);
        dialog.setContent(node);
        dialog.setMaximize(maximize);
        dialog.setSameWidthButtons(sameWidthButtons);
        if (!buttons.isEmpty()) {
            dialog.getButtonTypes().setAll(buttons);
        }
        if (validProperty != null) {
            dialog.validProperty().bind((ObservableValue)validProperty);
        }
        this.dialogs.add(dialog);
        return dialog;
    }

    public final Dialog<Void> showBusyIndicator() {
        BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.sceneProperty().addListener(it -> {
            if (busyIndicator.getScene() != null) {
                busyIndicator.start();
            } else {
                busyIndicator.stop();
            }
        });
        Dialog<Void> dialog = new Dialog<Void>(this, Type.BLANK);
        dialog.setContent((Node)busyIndicator);
        dialog.getButtonTypes().clear();
        this.dialogs.add(dialog);
        return dialog;
    }

    public final BooleanProperty animateDialogsProperty() {
        return this.animateDialogs;
    }

    public final boolean isAnimateDialogs() {
        return this.animateDialogs.get();
    }

    public final void setAnimateDialogs(boolean animate) {
        this.animateDialogs.set(animate);
    }

    public final BooleanProperty fadeInOutProperty() {
        return this.fadeInOut;
    }

    public final boolean isFadeInOut() {
        return this.fadeInOut.get();
    }

    public final void setFadeInOut(boolean animate) {
        this.fadeInOut.set(animate);
    }

    public ReadOnlyBooleanProperty showingDialogProperty() {
        return this.showingDialog.getReadOnlyProperty();
    }

    public boolean isShowingDialog() {
        return this.showingDialog.get();
    }

    private void slideInOut(double visibility, DoubleProperty visibilityProperty, Supplier<Node> nodeSupplier) {
        Node node = nodeSupplier.get();
        if (!this.getAnimationDuration().equals((Object)Duration.ZERO) && this.isAnimateDialogs()) {
            if (visibility == 1.0) {
                this.ensureNodeInChildrenList(node);
                node.setVisible(true);
                node.setOpacity(0.0);
            } else {
                node.setOpacity(1.0);
            }
            KeyValue value1 = new KeyValue((WritableValue)visibilityProperty, (Object)visibility);
            KeyValue value2 = new KeyValue((WritableValue)node.opacityProperty(), (Object)(visibility == 0.0 ? 0 : 1));
            KeyFrame frame = new KeyFrame(this.getAnimationDuration(), new KeyValue[]{value1, value2});
            Timeline timeline = new Timeline(new KeyFrame[]{frame});
            timeline.setOnFinished(evt -> {
                if (visibility == 0.0) {
                    node.setVisible(false);
                    this.getChildren().remove((Object)node);
                    if (node instanceof ContentPane) {
                        this.dialogContentPanes.remove((Object)node);
                        this.dialogVisibilityMap.remove(node);
                    }
                }
            });
            timeline.play();
        } else if (visibility == 1.0) {
            this.ensureNodeInChildrenList(node);
            node.setVisible(true);
            node.setOpacity(1.0);
            visibilityProperty.set(1.0);
        } else {
            node.setOpacity(0.0);
            visibilityProperty.set(0.0);
            this.getChildren().remove((Object)node);
            if (node instanceof ContentPane) {
                this.dialogContentPanes.remove((Object)node);
                this.dialogVisibilityMap.remove(node);
            }
        }
    }

    private void ensureNodeInChildrenList(Node node) {
        if (!this.getChildren().contains((Object)node)) {
            this.getChildren().add((Object)node);
        }
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double contentY = insets.getTop();
        double contentX = insets.getLeft();
        double contentWidth = this.getWidth() - insets.getLeft() - insets.getRight();
        double contentHeight = this.getHeight() - insets.getTop() - insets.getBottom();
        for (ContentPane dialogContentPane : this.dialogContentPanes) {
            double dialogWidth = Math.min(dialogContentPane.maxWidth(-1.0), Math.max(dialogContentPane.minWidth(-1.0), dialogContentPane.prefWidth(-1.0)));
            double dialogHeight = Math.min(dialogContentPane.maxHeight(-1.0), Math.max(dialogContentPane.minHeight(-1.0), dialogContentPane.prefHeight(-1.0)));
            Dialog<?> dialog = dialogContentPane.getDialog();
            if (dialog.isMaximize()) {
                dialogWidth = contentWidth * 0.9;
                dialogHeight = contentHeight * 0.9;
            } else {
                dialogWidth = Math.min(dialogWidth, contentWidth * 0.9);
                dialogHeight = Math.min(dialogHeight, contentHeight * 0.9);
            }
            double dialogTargetY = contentY + (contentHeight - dialogHeight) / 2.0;
            DoubleProperty dialogVisibility = this.dialogVisibilityMap.get((Object)dialogContentPane);
            if (dialogVisibility == null) continue;
            dialogContentPane.resizeRelocate(contentX + (contentWidth - dialogWidth) / 2.0, dialogTargetY * dialogVisibility.get(), dialogWidth, dialogHeight);
        }
        if (this.glassPane.isVisible()) {
            this.glassPane.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        }
    }

    public final StringConverter<ButtonType> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final ObjectProperty<StringConverter<ButtonType>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<ButtonType> converter) {
        this.converter.set(converter);
    }

    private static /* synthetic */ void lambda$showTextInput$14(Dialog dialog, TextInputControl textInputControl, Observable it) {
        dialog.setValue(textInputControl.getText());
    }

    private class CircularProgressIndicator
    extends Region {
        private static final double PREFERRED_WIDTH = 24.0;
        private static final double PREFERRED_HEIGHT = 24.0;
        private static final double MINIMUM_WIDTH = 12.0;
        private static final double MINIMUM_HEIGHT = 12.0;
        private static final double MAXIMUM_WIDTH = 1024.0;
        private static final double MAXIMUM_HEIGHT = 1024.0;
        private final DoubleProperty dashOffset = new SimpleDoubleProperty(0.0);
        private final DoubleProperty dashArray_0 = new SimpleDoubleProperty(1.0);
        private StackPane indeterminatePane;
        private Pane progressPane;
        private Circle circle;
        private Arc arc;
        private final Timeline timeline;
        private RotateTransition indeterminatePaneRotation;
        private final InvalidationListener listener;
        private final DoubleProperty progress;
        private final BooleanProperty indeterminate;
        private final BooleanProperty roundLineCap;
        private boolean isRunning;

        public CircularProgressIndicator() {
            this.getStyleClass().add((Object)"circular-progress");
            this.progress = new DoublePropertyBase(0.0){

                public void invalidated() {
                    if (this.get() < 0.0) {
                        CircularProgressIndicator.this.startIndeterminate();
                    } else {
                        CircularProgressIndicator.this.stopIndeterminate();
                        this.set(Math.max(0.0, Math.min(1.0, this.get())));
                        CircularProgressIndicator.this.redraw();
                    }
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "progress";
                }
            };
            this.indeterminate = new BooleanPropertyBase(false){

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "indeterminate";
                }
            };
            this.roundLineCap = new BooleanPropertyBase(false){

                public void invalidated() {
                    if (this.get()) {
                        CircularProgressIndicator.this.circle.setStrokeLineCap(StrokeLineCap.ROUND);
                        CircularProgressIndicator.this.arc.setStrokeLineCap(StrokeLineCap.ROUND);
                    } else {
                        CircularProgressIndicator.this.circle.setStrokeLineCap(StrokeLineCap.SQUARE);
                        CircularProgressIndicator.this.arc.setStrokeLineCap(StrokeLineCap.SQUARE);
                    }
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "roundLineCap";
                }
            };
            this.isRunning = false;
            this.timeline = new Timeline();
            this.listener = observable -> {
                this.circle.setStrokeDashOffset(this.dashOffset.get());
                this.circle.getStrokeDashArray().setAll((Object[])new Double[]{this.dashArray_0.getValue(), 200.0});
            };
            this.init();
            this.initGraphics();
            this.registerListeners();
        }

        private void init() {
            if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
                if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                    this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
                } else {
                    this.setPrefSize(24.0, 24.0);
                }
            }
            if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
                this.setMinSize(12.0, 12.0);
            }
            if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
                this.setMaxSize(1024.0, 1024.0);
            }
        }

        private void initGraphics() {
            double center = 12.0;
            double radius = 10.8;
            this.circle = new Circle();
            this.circle.setCenterX(center);
            this.circle.setCenterY(center);
            this.circle.setRadius(radius);
            this.circle.getStyleClass().add((Object)"indicator");
            this.circle.setStrokeLineCap(this.isRoundLineCap() ? StrokeLineCap.ROUND : StrokeLineCap.SQUARE);
            this.circle.setStrokeWidth(2.5263158399999996);
            this.circle.setStrokeDashOffset(this.dashOffset.get());
            this.circle.getStrokeDashArray().setAll((Object[])new Double[]{this.dashArray_0.getValue(), 200.0});
            this.arc = new Arc(center, center, radius, radius, 90.0, -360.0 * this.getProgress());
            this.arc.setStrokeLineCap(this.isRoundLineCap() ? StrokeLineCap.ROUND : StrokeLineCap.SQUARE);
            this.arc.setStrokeWidth(2.4000000000000004);
            this.arc.getStyleClass().add((Object)"indicator");
            this.indeterminatePane = new StackPane(new Node[]{this.circle});
            this.indeterminatePane.setVisible(false);
            this.progressPane = new Pane(new Node[]{this.arc});
            this.progressPane.setVisible(Double.compare(this.getProgress(), 0.0) != 0);
            this.getChildren().setAll((Object[])new Node[]{this.progressPane, this.indeterminatePane});
            KeyValue kvDashOffset_0 = new KeyValue((WritableValue)this.dashOffset, (Object)0, Interpolator.EASE_BOTH);
            KeyValue kvDashOffset_50 = new KeyValue((WritableValue)this.dashOffset, (Object)-32, Interpolator.EASE_BOTH);
            KeyValue kvDashOffset_100 = new KeyValue((WritableValue)this.dashOffset, (Object)-64, Interpolator.EASE_BOTH);
            KeyValue kvDashArray_0_0 = new KeyValue((WritableValue)this.dashArray_0, (Object)5, Interpolator.EASE_BOTH);
            KeyValue kvDashArray_0_50 = new KeyValue((WritableValue)this.dashArray_0, (Object)89, Interpolator.EASE_BOTH);
            KeyValue kvDashArray_0_100 = new KeyValue((WritableValue)this.dashArray_0, (Object)89, Interpolator.EASE_BOTH);
            KeyValue kvRotate_0 = new KeyValue((WritableValue)this.circle.rotateProperty(), (Object)-10, Interpolator.LINEAR);
            KeyValue kvRotate_100 = new KeyValue((WritableValue)this.circle.rotateProperty(), (Object)370, Interpolator.LINEAR);
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvDashOffset_0, kvDashArray_0_0, kvRotate_0});
            KeyFrame kf1 = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{kvDashOffset_50, kvDashArray_0_50});
            KeyFrame kf2 = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{kvDashOffset_100, kvDashArray_0_100, kvRotate_100});
            this.timeline.setCycleCount(-1);
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1, kf2});
            this.indeterminatePaneRotation = new RotateTransition();
            this.indeterminatePaneRotation.setNode((Node)this.indeterminatePane);
            this.indeterminatePaneRotation.setFromAngle(0.0);
            this.indeterminatePaneRotation.setToAngle(-360.0);
            this.indeterminatePaneRotation.setInterpolator(Interpolator.LINEAR);
            this.indeterminatePaneRotation.setCycleCount(-1);
            this.indeterminatePaneRotation.setDuration(new Duration(4500.0));
            this.indeterminatePane.rotateProperty().addListener(it -> {
                Window window;
                Scene scene = this.indeterminatePane.getScene();
                boolean stop = scene != null ? ((window = scene.getWindow()) == null ? true : !window.isShowing()) : true;
                if (stop) {
                    this.stopIndeterminate();
                }
            });
        }

        private void registerListeners() {
            this.widthProperty().addListener(o -> this.resize());
            this.heightProperty().addListener(o -> this.resize());
            this.progress.addListener(o -> this.redraw());
            this.dashOffset.addListener(this.listener);
        }

        public double getProgress() {
            return this.progress.get();
        }

        public void setProgress(double PROGRESS) {
            this.progress.set(PROGRESS);
        }

        public DoubleProperty progressProperty() {
            return this.progress;
        }

        private void startIndeterminate() {
            if (this.isRunning) {
                return;
            }
            this.manageNode((Node)this.indeterminatePane, true);
            this.manageNode((Node)this.progressPane, false);
            this.timeline.play();
            this.indeterminatePaneRotation.play();
            this.isRunning = true;
            this.indeterminate.set(true);
        }

        private void stopIndeterminate() {
            if (!this.isRunning) {
                return;
            }
            this.timeline.stop();
            this.indeterminatePaneRotation.stop();
            this.indeterminatePane.setRotate(0.0);
            this.manageNode((Node)this.progressPane, true);
            this.manageNode((Node)this.indeterminatePane, false);
            this.isRunning = false;
            this.indeterminate.set(false);
        }

        public boolean isIndeterminate() {
            return Double.compare(-1.0, this.getProgress()) == 0;
        }

        public ReadOnlyBooleanProperty indeterminateProperty() {
            return this.indeterminate;
        }

        public boolean isRoundLineCap() {
            return this.roundLineCap.get();
        }

        public void setRoundLineCap(boolean BOOLEAN) {
            this.roundLineCap.set(BOOLEAN);
        }

        public BooleanProperty roundLineCapProperty() {
            return this.roundLineCap;
        }

        private void manageNode(Node NODE, boolean MANAGED) {
            if (MANAGED) {
                NODE.setManaged(true);
                NODE.setVisible(true);
            } else {
                NODE.setVisible(false);
                NODE.setManaged(false);
            }
        }

        private void resize() {
            double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
            double height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
            double size = Math.min(width, height);
            if (width > 0.0 && height > 0.0) {
                this.indeterminatePane.setMaxSize(size, size);
                this.indeterminatePane.setPrefSize(size, size);
                this.indeterminatePane.relocate((this.getWidth() - size) * 0.5, (this.getHeight() - size) * 0.5);
                this.progressPane.setMaxSize(size, size);
                this.progressPane.setPrefSize(size, size);
                this.progressPane.relocate((this.getWidth() - size) * 0.5, (this.getHeight() - size) * 0.5);
                double center = size * 0.5;
                double radius = size * 0.45;
                this.arc.setCenterX(center);
                this.arc.setCenterY(center);
                this.arc.setRadiusX(radius);
                this.arc.setRadiusY(radius);
                this.arc.setStrokeWidth(size * 0.10526316);
                double factor = size / 24.0;
                this.circle.setScaleX(factor);
                this.circle.setScaleY(factor);
            }
        }

        private void redraw() {
            double progress = this.getProgress();
            this.progressPane.setVisible(Double.compare(progress, 0.0) > 0);
            this.arc.setLength(-360.0 * progress);
        }
    }

    private class BusyIndicator
    extends CircularProgressIndicator {
        public BusyIndicator() {
            this.getStyleClass().add((Object)"busy-indicator");
        }

        public void stop() {
            this.setProgress(0.0);
        }

        public void start() {
            this.setProgress(-1.0);
        }
    }

    private class ContentPane
    extends StackPane {
        private final ButtonBar dialogButtonBar;
        private final Dialog<?> dialog;
        private final ChangeListener<Node> focusListener = (o, oldOwner, newOwner) -> {
            if (newOwner != null && !this.isInsideDialogPane(newOwner.getParent()) && this.getScene() != null) {
                this.requestFocus();
            }
        };
        private final WeakChangeListener<Node> weakFocusListener = new WeakChangeListener(this.focusListener);
        private final BooleanProperty blocked = new SimpleBooleanProperty((Object)this, "blocked");

        public ContentPane(Dialog<?> dialog) {
            this.dialog = Objects.requireNonNull(dialog);
            DialogPane shell = this.dialog.getDialogPane();
            Label dialogTitle = new Label("Dialog");
            dialogTitle.setMaxWidth(Double.MAX_VALUE);
            dialogTitle.getStyleClass().add((Object)"title");
            ImageView dialogIcon = new ImageView();
            dialogIcon.getStyleClass().addAll((Object[])new String[]{"icon"});
            VBox dialogHeader = new VBox();
            dialogHeader.setAlignment(Pos.CENTER);
            dialogHeader.getStyleClass().add((Object)"header");
            dialogHeader.managedProperty().bind((ObservableValue)dialogHeader.visibleProperty());
            dialogHeader.getChildren().setAll((Object[])new Node[]{dialogIcon, dialogTitle});
            StackPane content = new StackPane();
            content.getStyleClass().add((Object)"content");
            if (dialog.isPadding()) {
                content.getStyleClass().add((Object)"padding");
            }
            this.dialogButtonBar = new ButtonBar();
            if (System.getProperty("os.name").startsWith("Mac")) {
                this.dialogButtonBar.setButtonOrder("L_NCYOAHE+U+FBIX_R");
            } else if (System.getProperty("os.name").startsWith("Windows")) {
                this.dialogButtonBar.setButtonOrder("L_YNOCAHE+U+FBXI_R");
            } else {
                this.dialogButtonBar.setButtonOrder("L_HENYCOA+U+FBIX_R");
            }
            this.dialogButtonBar.getStyleClass().add((Object)"button-bar");
            this.dialogButtonBar.managedProperty().bind((ObservableValue)this.dialogButtonBar.visibleProperty());
            this.dialogButtonBar.sceneProperty().addListener((obs, oldScene, newScene) -> {
                if (oldScene != null) {
                    oldScene.focusOwnerProperty().removeListener(this.weakFocusListener);
                }
                if (newScene != null) {
                    newScene.focusOwnerProperty().addListener(this.weakFocusListener);
                }
            });
            VBox.setVgrow((Node)dialogTitle, (Priority)Priority.NEVER);
            VBox.setVgrow((Node)content, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)this.dialogButtonBar, (Priority)Priority.NEVER);
            content.getChildren().setAll((Object[])new Node[]{this.dialog.getContent()});
            boolean blankDialog = this.dialog.getType().equals((Object)Type.BLANK);
            dialogHeader.setVisible(!blankDialog);
            this.dialogButtonBar.setVisible(!blankDialog);
            dialogTitle.textProperty().bind((ObservableValue)this.dialog.titleProperty());
            this.getStyleClass().setAll((Object[])new String[]{"content-pane"});
            this.getStyleClass().addAll(this.dialog.getStyleClass());
            if (!blankDialog) {
                this.createButtons();
            }
            VBox box = new VBox();
            box.getStyleClass().add((Object)"vbox");
            box.setFillWidth(true);
            box.getChildren().setAll((Object[])new Node[]{dialogHeader, content, this.dialogButtonBar});
            GlassPane glassPane = new GlassPane();
            glassPane.hideProperty().bind((ObservableValue)this.blocked.not());
            glassPane.fadeInOutProperty().bind((ObservableValue)shell.fadeInOutProperty());
            FontIcon fontIcon = new FontIcon((Ikon)MaterialDesign.MDI_CLOSE);
            Button closeButton = new Button();
            closeButton.setGraphic((Node)fontIcon);
            closeButton.setAlignment(Pos.CENTER);
            closeButton.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            closeButton.getStyleClass().add((Object)"close-button");
            closeButton.visibleProperty().bind((ObservableValue)dialog.showCloseButtonProperty().and((ObservableBooleanValue)DialogPane.this.showCloseButtonProperty()));
            closeButton.managedProperty().bind((ObservableValue)dialog.showCloseButtonProperty().and((ObservableBooleanValue)DialogPane.this.showCloseButtonProperty()));
            closeButton.setOnAction(evt -> dialog.cancel());
            StackPane.setAlignment((Node)closeButton, (Pos)Pos.TOP_RIGHT);
            this.getChildren().addAll((Object[])new Node[]{box, closeButton, glassPane});
        }

        private boolean isInsideDialogPane(Parent parent) {
            if (parent == null) {
                return false;
            }
            if (parent instanceof DialogPane) {
                return true;
            }
            return this.isInsideDialogPane(parent.getParent());
        }

        public boolean isBlocked() {
            return this.blocked.get();
        }

        public BooleanProperty blockedProperty() {
            return this.blocked;
        }

        public void setBlocked(boolean blocked) {
            this.blocked.set(blocked);
        }

        public Dialog<?> getDialog() {
            return this.dialog;
        }

        private void createButtons() {
            this.dialogButtonBar.getButtons().clear();
            this.dialogButtonBar.setVisible(this.dialog.isShowButtonsBar());
            boolean hasDefault = false;
            for (ButtonType buttonType : this.dialog.getButtonTypes()) {
                Button button = this.createButton(buttonType);
                this.dialog.buttonMap.put(buttonType, button);
                switch (buttonType.getButtonData()) {
                    case LEFT: 
                    case RIGHT: 
                    case HELP: 
                    case HELP_2: 
                    case NO: 
                    case NEXT_FORWARD: 
                    case BACK_PREVIOUS: 
                    case APPLY: 
                    case CANCEL_CLOSE: 
                    case OTHER: 
                    case BIG_GAP: 
                    case SMALL_GAP: {
                        break;
                    }
                    case YES: 
                    case OK_DONE: 
                    case FINISH: {
                        button.disableProperty().bind((ObservableValue)this.dialog.validProperty().not());
                    }
                }
                if (button != null) {
                    Node content;
                    ButtonBar.ButtonData buttonData = buttonType.getButtonData();
                    button.setDefaultButton(!hasDefault && buttonData != null && buttonData.isDefaultButton());
                    button.setCancelButton(buttonData != null && buttonData.isCancelButton());
                    button.setOnAction(evt -> {
                        if (buttonType.equals(ButtonType.CANCEL)) {
                            this.dialog.cancel();
                        } else {
                            this.dialog.getDialogPane().hideDialog(this.dialog);
                            this.dialog.complete(buttonType);
                        }
                    });
                    hasDefault |= buttonData != null && buttonData.isDefaultButton();
                    if (button.isDefaultButton() && (content = this.dialog.getContent()) instanceof ListView) {
                        content.setOnMouseClicked(evt -> {
                            if (evt.getClickCount() == 2) {
                                button.fire();
                            }
                        });
                    }
                }
                this.dialogButtonBar.getButtons().add((Object)button);
            }
        }

        protected Button createButton(ButtonType buttonType) {
            String text = buttonType.getText();
            StringConverter<ButtonType> converter = this.getDialog().getDialogPane().getConverter();
            if (converter != null) {
                text = converter.toString((Object)buttonType);
            }
            Button button = new Button(text);
            button.getStyleClass().add((Object)buttonType.getButtonData().getTypeCode().toLowerCase());
            ButtonBar.ButtonData buttonData = buttonType.getButtonData();
            button.setMinWidth(Double.NEGATIVE_INFINITY);
            ButtonBar.setButtonUniformSize((Node)button, (boolean)this.dialog.isSameWidthButtons());
            ButtonBar.setButtonData((Node)button, (ButtonBar.ButtonData)buttonData);
            button.setDefaultButton(buttonData.isDefaultButton());
            button.setCancelButton(buttonData.isCancelButton());
            return button;
        }
    }

    public static class Dialog<T>
    extends CompletableFuture<ButtonType> {
        private final Type type;
        private final DialogPane pane;
        private boolean padding = true;
        private final BooleanProperty showCloseButton = new SimpleBooleanProperty((Object)this, "showCloseButton", true);
        private final ObjectProperty<Duration> delay = new SimpleObjectProperty((Object)this, "delay", (Object)Duration.millis((double)100.0));
        private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value");
        private final BooleanProperty valid = new SimpleBooleanProperty((Object)this, "valid", true);
        private final ObservableList<ButtonType> buttonTypes = FXCollections.observableArrayList();
        private final BooleanProperty sameWidthButtons = new SimpleBooleanProperty(true);
        private final BooleanProperty maximize = new SimpleBooleanProperty();
        private final ObjectProperty<Callable> onCancelled = new SimpleObjectProperty((Object)this, "onCancelled");
        private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
        private final StringProperty title = new SimpleStringProperty((Object)this, "title", "Dialog");
        private final ObservableList<String> styleClass = FXCollections.observableArrayList();
        private final BooleanProperty showButtonsBar = new SimpleBooleanProperty((Object)this, "showButtonsBar", true);
        private final ObjectProperty<Throwable> exception = new SimpleObjectProperty((Object)this, "exception");
        Map<ButtonType, Button> buttonMap = new HashMap<ButtonType, Button>();

        public Dialog(DialogPane pane, Type type) {
            this.pane = Objects.requireNonNull(pane);
            this.type = Objects.requireNonNull(type);
            this.getStyleClass().add((Object)type.name().toLowerCase());
            switch (type) {
                case INPUT: 
                case WARNING: {
                    this.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
                    break;
                }
                case INFORMATION: 
                case ERROR: {
                    this.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
                    break;
                }
                case CONFIRMATION: {
                    this.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    break;
                }
            }
        }

        public final boolean isShowCloseButton() {
            return this.showCloseButton.get();
        }

        public final BooleanProperty showCloseButtonProperty() {
            return this.showCloseButton;
        }

        public final void setShowCloseButton(boolean showCloseButton) {
            this.showCloseButton.set(showCloseButton);
        }

        public final Duration getDelay() {
            return (Duration)this.delay.get();
        }

        public final ObjectProperty<Duration> delayProperty() {
            return this.delay;
        }

        public final void setDelay(Duration delay) {
            this.delay.set((Object)delay);
        }

        public final boolean isPadding() {
            return this.padding;
        }

        public final void setPadding(boolean padding) {
            this.padding = padding;
        }

        public final T getValue() {
            return (T)this.value.get();
        }

        public final ObjectProperty<T> valueProperty() {
            return this.value;
        }

        public final void setValue(T value) {
            this.value.set(value);
        }

        public final Type getType() {
            return this.type;
        }

        public final DialogPane getDialogPane() {
            return this.pane;
        }

        public void cancel() {
            this.pane.hideDialog(this);
            this.setValue(null);
            this.complete(ButtonType.CANCEL);
        }

        public boolean isValid() {
            return this.valid.get();
        }

        public BooleanProperty validProperty() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid.set(valid);
        }

        public ObservableList<ButtonType> getButtonTypes() {
            return this.buttonTypes;
        }

        public boolean isSameWidthButtons() {
            return this.sameWidthButtons.get();
        }

        public BooleanProperty sameWidthButtonsProperty() {
            return this.sameWidthButtons;
        }

        public void setSameWidthButtons(boolean sameWidthButtons) {
            this.sameWidthButtons.set(sameWidthButtons);
        }

        public final BooleanProperty maximizeProperty() {
            return this.maximize;
        }

        public final void setMaximize(boolean max) {
            this.maximize.set(max);
        }

        public final boolean isMaximize() {
            return this.maximize.get();
        }

        public Callable getOnCancelled() {
            return (Callable)this.onCancelled.get();
        }

        public final ObjectProperty<Node> contentProperty() {
            return this.content;
        }

        public void setContent(Node content) {
            this.content.set((Object)content);
        }

        public Node getContent() {
            return (Node)this.content.get();
        }

        public final StringProperty titleProperty() {
            return this.title;
        }

        public final String getTitle() {
            return (String)this.title.get();
        }

        public final void setTitle(String title) {
            this.title.set((Object)title);
        }

        public ObservableList<String> getStyleClass() {
            return this.styleClass;
        }

        public final BooleanProperty showButtonsBarProperty() {
            return this.showButtonsBar;
        }

        public final boolean isShowButtonsBar() {
            return this.showButtonsBarProperty().get();
        }

        public final void setShowButtonsBar(boolean showButtonsBar) {
            this.showButtonsBarProperty().set(showButtonsBar);
        }

        public final ObjectProperty<Throwable> exceptionProperty() {
            return this.exception;
        }

        public final void setException(Throwable ex) {
            this.exception.set((Object)ex);
        }

        public final Throwable getException() {
            return (Throwable)this.exception.get();
        }

        public final Button getButton(ButtonType type) {
            return this.buttonMap.get(type);
        }
    }

    public static enum Type {
        INPUT,
        INFORMATION,
        ERROR,
        WARNING,
        CONFIRMATION,
        BLANK;

    }
}

