/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;

public class ExpandingTextArea
extends TextArea {
    private Text text;
    private double offsetTop;
    private double offsetBottom;

    public ExpandingTextArea() {
        this.init();
    }

    public ExpandingTextArea(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"expanding-text-area");
        this.setWrapText(true);
        this.sceneProperty().addListener(it -> {
            if (this.getScene() != null) {
                this.performBinding();
            }
        });
        this.skinProperty().addListener(it -> {
            if (this.getSkin() != null) {
                this.performBinding();
            }
        });
    }

    private double computeHeight() {
        this.computeOffsets();
        Bounds layoutBounds = this.localToScreen(this.text.getLayoutBounds());
        if (layoutBounds != null) {
            double minY = layoutBounds.getMinY();
            double maxY = layoutBounds.getMaxY();
            return maxY - minY + this.offsetTop + this.offsetBottom;
        }
        return 0.0;
    }

    private void computeOffsets() {
        this.offsetTop = this.getInsets().getTop();
        this.offsetBottom = this.getInsets().getBottom();
        ScrollPane scrollPane = (ScrollPane)this.lookup(".scroll-pane");
        if (scrollPane != null) {
            Region viewport = (Region)scrollPane.lookup(".viewport");
            Region content = (Region)scrollPane.lookup(".content");
            this.offsetTop += viewport.getInsets().getTop();
            this.offsetTop += content.getInsets().getTop();
            this.offsetBottom += viewport.getInsets().getBottom();
            this.offsetBottom += content.getInsets().getBottom();
        }
    }

    private void performBinding() {
        ScrollPane scrollPane = (ScrollPane)this.lookup(".scroll-pane");
        if (scrollPane != null) {
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.skinProperty().addListener(it -> {
                if (scrollPane.getSkin() != null && this.text == null) {
                    this.text = this.findTextNode();
                    if (this.text != null) {
                        this.prefHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.computeHeight(), (Observable[])new Observable[]{this.text.layoutBoundsProperty()}));
                    }
                }
            });
        }
    }

    private Text findTextNode() {
        Set nodes = this.lookupAll(".text");
        for (Node node : nodes) {
            if (!(node.getParent() instanceof Group)) continue;
            return (Text)node;
        }
        return null;
    }
}

