/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextArea;
import javafx.scene.layout.StackPane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class ResizableTextArea
extends Control {
    private final TextArea editor = new TextArea();
    private final BooleanProperty resizeVertical = new SimpleBooleanProperty((Object)this, "resizeVertical", true);
    private final BooleanProperty resizeHorizontal = new SimpleBooleanProperty((Object)this, "resizeHorizontal", false);
    private final StringProperty text = new SimpleStringProperty((Object)this, "text");

    public ResizableTextArea() {
        this.getStyleClass().add((Object)"resizable-text-area");
        this.setFocusTraversable(false);
        this.getStylesheets().add((Object)this.getUserAgentStylesheet());
        this.editor.textProperty().bindBidirectional((Property)this.textProperty());
    }

    public ResizableTextArea(String text) {
        this();
        this.setText(text);
    }

    protected Skin<?> createDefaultSkin() {
        return new ResizableTextAreaSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ResizableTextArea.class.getResource("resizable-text-area.css").toExternalForm();
    }

    public final TextArea getEditor() {
        return this.editor;
    }

    public final boolean isResizeVertical() {
        return this.resizeVertical.get();
    }

    public final BooleanProperty resizeVerticalProperty() {
        return this.resizeVertical;
    }

    public final void setResizeVertical(boolean resizeVertical) {
        this.resizeVertical.set(resizeVertical);
    }

    public final boolean isResizeHorizontal() {
        return this.resizeHorizontal.get();
    }

    public final BooleanProperty resizeHorizontalProperty() {
        return this.resizeHorizontal;
    }

    public final void setResizeHorizontal(boolean resizeHorizontal) {
        this.resizeHorizontal.set(resizeHorizontal);
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String text) {
        this.text.set((Object)text);
    }

    private static class ResizableTextAreaSkin
    extends SkinBase<ResizableTextArea> {
        private double startX;
        private double startY;
        private double startW;
        private double startH;

        public ResizableTextAreaSkin(ResizableTextArea area) {
            super((Control)area);
            TextArea editor = area.getEditor();
            FontIcon resizeIcon = new FontIcon((Ikon)MaterialDesign.MDI_RESIZE_BOTTOM_RIGHT);
            StackPane resizeCorner = new StackPane(new Node[]{resizeIcon});
            resizeCorner.getStyleClass().add((Object)"resize-corner");
            resizeCorner.setPrefSize(10.0, 10.0);
            resizeCorner.setMaxSize(10.0, 10.0);
            resizeCorner.setOnMousePressed(evt -> {
                editor.requestFocus();
                this.startX = evt.getScreenX();
                this.startY = evt.getScreenY();
                this.startW = editor.getWidth();
                this.startH = editor.getHeight();
            });
            resizeCorner.setOnMouseDragged(evt -> {
                double screenX = evt.getScreenX();
                double screenY = evt.getScreenY();
                double deltaX = screenX - this.startX;
                double deltaY = screenY - this.startY;
                double w = this.startW + deltaX;
                double h = this.startH + deltaY;
                if (editor.getMaxWidth() > 0.0) {
                    w = Math.min(editor.getMaxWidth(), w);
                }
                if (editor.getMaxHeight() > 0.0) {
                    h = Math.min(editor.getMaxHeight(), h);
                }
                if (area.isResizeHorizontal()) {
                    editor.setPrefWidth(w);
                }
                if (area.isResizeVertical()) {
                    editor.setPrefHeight(h);
                }
            });
            StackPane.setAlignment((Node)resizeCorner, (Pos)Pos.BOTTOM_RIGHT);
            editor.focusedProperty().addListener(it -> resizeIcon.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"active"), editor.isFocused()));
            StackPane pane = new StackPane(new Node[]{editor, resizeCorner});
            this.getChildren().setAll((Object[])new Node[]{pane});
        }
    }
}

