/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.SearchField;
import com.dlsc.gemsfx.skins.TagsFieldSkin;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;

public class TagsField<T>
extends SearchField<T> {
    private static final int MAX_UNDO_AND_REDO_STEPS = 50;
    private static final String DEFAULT_STYLE_CLASS = "tags-field";
    private final Deque<Command> undoStack = new ArrayDeque<Command>();
    private final Deque<Command> redoStack = new ArrayDeque<Command>();
    private final ListProperty<T> tags = new SimpleListProperty((Object)this, "tags", FXCollections.observableArrayList());
    private final ObjectProperty<Callback<T, Node>> tagViewFactory = new SimpleObjectProperty((Object)this, "tagViewFactory");
    private final ObjectProperty<MultipleSelectionModel<T>> tagSelectionModel = new SimpleObjectProperty((Object)this, "selectionModel");

    public TagsField() {
        this.getStyleClass().addAll((Object[])new String[]{"text-input", DEFAULT_STYLE_CLASS});
        this.setFocusTraversable(false);
        this.getEditor().focusedProperty().addListener(it -> {
            if (this.getEditor().isFocused()) {
                this.getTagSelectionModel().clearSelection();
            }
        });
        this.setTagViewFactory(tag -> {
            Label tagLabel = new Label();
            tagLabel.setText(this.getConverter().toString(tag));
            return tagLabel;
        });
        this.addEventFilter(KeyEvent.KEY_RELEASED, evt -> {
            Object selectedItem;
            if ((evt.getCode().equals((Object)KeyCode.RIGHT) || evt.getCode().equals((Object)KeyCode.ENTER)) && (selectedItem = this.getSelectedItem()) != null && !this.getTags().contains(selectedItem)) {
                this.addTags(selectedItem);
                Platform.runLater(this::clear);
            }
        });
        this.textProperty().addListener(it -> this.getTagSelectionModel().clearSelection());
        this.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
            MultipleSelectionModel<T> tagSelectionModel = this.getTagSelectionModel();
            if (evt.getCode().equals((Object)KeyCode.BACK_SPACE)) {
                if (!tagSelectionModel.isEmpty()) {
                    this.removeTags(tagSelectionModel.getSelectedItems().toArray());
                } else if (this.getText().equals("") && !this.getTags().isEmpty()) {
                    this.removeTags(this.getTags().get(this.getTags().size() - 1));
                }
            } else if (KeyCombination.keyCombination((String)"shortcut+z").match(evt)) {
                this.undo();
            } else if (KeyCombination.keyCombination((String)"shortcut+shift+z").match(evt)) {
                this.redo();
            } else if (KeyCombination.keyCombination((String)"shortcut+a").match(evt)) {
                tagSelectionModel.selectAll();
            } else if (evt.getCode().equals((Object)KeyCode.ESCAPE)) {
                tagSelectionModel.clearSelection();
            }
        });
        this.setTagSelectionModel(new TagFieldSelectionModel());
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TagsFieldSkin(this);
    }

    @Override
    public String getUserAgentStylesheet() {
        return TagsField.class.getResource("tags-field.css").toExternalForm();
    }

    @Override
    public void commit() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null && !this.getTags().contains(selectedItem)) {
            this.addTags(selectedItem);
            this.clear();
        }
    }

    @Override
    protected void update(Collection<T> newSuggestions) {
        if (newSuggestions != null) {
            newSuggestions.removeAll((Collection<?>)this.getTags());
        }
        super.update(newSuggestions);
    }

    public final ObservableList<T> getTags() {
        return (ObservableList)this.tags.get();
    }

    public final ListProperty<T> tagsProperty() {
        return this.tags;
    }

    public final void setTags(ObservableList<T> tags) {
        this.tags.set(tags);
    }

    public final void addTags(T ... values) {
        this.execute(new AddTagCommand(values));
    }

    public final void removeTags(T ... values) {
        this.execute(new RemoveTagCommand(values));
    }

    public final void clearTags() {
        this.execute(new ClearTagsCommand(this.getTags()));
    }

    public final ObjectProperty<Callback<T, Node>> tagViewFactoryProperty() {
        return this.tagViewFactory;
    }

    public final Callback<T, Node> getTagViewFactory() {
        return (Callback)this.tagViewFactory.get();
    }

    public final void setTagViewFactory(Callback<T, Node> tagViewFactory) {
        this.tagViewFactory.set(tagViewFactory);
    }

    public final MultipleSelectionModel<T> getTagSelectionModel() {
        return (MultipleSelectionModel)this.tagSelectionModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<T>> tagSelectionModelProperty() {
        return this.tagSelectionModel;
    }

    public final void setTagSelectionModel(MultipleSelectionModel<T> tagSelectionModel) {
        this.tagSelectionModel.set(tagSelectionModel);
    }

    private void execute(Command cmd) {
        cmd.execute();
        this.undoStack.push(cmd);
        if (this.undoStack.size() > 50) {
            this.undoStack.removeLast();
        }
    }

    private void undo() {
        if (!this.undoStack.isEmpty()) {
            this.clear();
            Command cmd = this.undoStack.pop();
            cmd.undo();
            this.redoStack.push(cmd);
            if (this.redoStack.size() > 50) {
                this.redoStack.removeLast();
            }
        }
    }

    private void redo() {
        if (!this.redoStack.isEmpty()) {
            Command cmd = this.redoStack.pop();
            cmd.execute();
            this.undoStack.push(cmd);
        }
    }

    class TagFieldSelectionModel
    extends MultipleSelectionModel<T> {
        private final ObservableList<Integer> selectedIndices = FXCollections.observableArrayList();
        private final ObservableList<T> selectedItems = FXCollections.observableArrayList();

        public TagFieldSelectionModel() {
            this.selectedIndices.addListener(it -> this.selectedItems.setAll((Collection)this.selectedIndices.stream().map(index -> TagsField.this.getTags().get(index.intValue())).collect(Collectors.toList())));
            this.setSelectionMode(SelectionMode.MULTIPLE);
            TagsField.this.getTags().addListener(it -> this.clearSelection());
            this.selectionModeProperty().addListener(it -> this.clearSelection());
        }

        public void clearAndSelect(int index) {
            this.selectedIndices.clear();
            this.select(index);
        }

        public void select(int index) {
            if (this.getSelectionMode().equals((Object)SelectionMode.SINGLE)) {
                this.clearSelection();
            }
            if (!this.selectedIndices.contains((Object)index)) {
                this.selectedIndices.add((Object)index);
                this.setSelectedIndex(index);
                this.setSelectedItem(TagsField.this.getTags().get(index));
            }
        }

        public void select(T tag) {
            this.select(TagsField.this.getTags().indexOf(tag));
        }

        public void clearSelection(int index) {
            this.selectedIndices.remove((Object)index);
            if (this.getSelectedIndex() == index) {
                this.setSelectedIndex(-1);
                this.setSelectedItem(null);
            }
        }

        public void clearSelection() {
            this.selectedIndices.clear();
            this.setSelectedIndex(-1);
            this.setSelectedItem(null);
        }

        public boolean isSelected(int index) {
            return this.selectedIndices.contains((Object)index);
        }

        public boolean isEmpty() {
            return this.selectedIndices.isEmpty();
        }

        public void selectPrevious() {
            throw new UnsupportedOperationException();
        }

        public void selectNext() {
            throw new UnsupportedOperationException();
        }

        public ObservableList<Integer> getSelectedIndices() {
            return this.selectedIndices;
        }

        public ObservableList<T> getSelectedItems() {
            return this.selectedItems;
        }

        public void selectRange(int start, int end) {
            if (this.getSelectionMode().equals((Object)SelectionMode.SINGLE)) {
                this.clearSelection();
                this.select(end - 1);
            } else {
                super.selectRange(start, end);
            }
        }

        public void selectIndices(int index, int ... indices) {
            this.select(index);
            for (int i : indices) {
                this.select(i);
            }
        }

        public void selectAll() {
            this.selectRange(0, TagsField.this.getTags().size());
        }

        public void selectFirst() {
            this.selectIndices(0, new int[0]);
        }

        public void selectLast() {
            this.selectIndices(TagsField.this.getTags().size() - 1, new int[0]);
        }
    }

    private class ClearTagsCommand
    implements Command {
        private List<T> tags = new ArrayList();

        public ClearTagsCommand(List<T> tags) {
            this.tags.addAll(tags);
        }

        @Override
        public void undo() {
            TagsField.this.getTags().setAll(this.tags);
        }

        @Override
        public void execute() {
            TagsField.this.getTags().clear();
        }
    }

    private class RemoveTagCommand
    implements Command {
        private T[] tags;

        public RemoveTagCommand(T ... tags) {
            this.tags = tags;
        }

        @Override
        public void undo() {
            for (Object tag : this.tags) {
                if (TagsField.this.getTags().contains(tag)) continue;
                TagsField.this.getTags().add(tag);
            }
        }

        @Override
        public void execute() {
            TagsField.this.getTags().removeAll((Object[])this.tags);
        }
    }

    private class AddTagCommand
    implements Command {
        private T[] tags;

        public AddTagCommand(T ... tags) {
            this.tags = tags;
        }

        @Override
        public void undo() {
            TagsField.this.getTags().removeAll((Object[])this.tags);
        }

        @Override
        public void execute() {
            for (Object tag : this.tags) {
                if (TagsField.this.getTags().contains(tag)) continue;
                TagsField.this.getTags().add(tag);
            }
        }
    }

    private static interface Command {
        public void execute();

        public void undo();
    }
}

