/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.TimePickerSkin;
import java.time.LocalTime;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;

public class TimePicker
extends Control {
    private final ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper((Object)this, "showing", false);
    private final ReadOnlyBooleanWrapper adjusted = new ReadOnlyBooleanWrapper((Object)this, "adjusted");
    private final ObjectProperty<LocalTime> earliestTime = new SimpleObjectProperty((Object)this, "earliestTime", (Object)LocalTime.MIN);
    private final ObjectProperty<LocalTime> latestTime = new SimpleObjectProperty((Object)this, "latestTime", (Object)LocalTime.MAX);
    private final ObjectProperty<Node> separator = new SimpleObjectProperty((Object)this, "separator");
    private final BooleanProperty showPopupTriggerButton = new SimpleBooleanProperty((Object)this, "showPopupTriggerButton", true);
    private boolean adjustmentInProgress;
    private final ObjectProperty<LocalTime> time = new SimpleObjectProperty((Object)this, "time");
    private final IntegerProperty stepRateInMinutes = new SimpleIntegerProperty((Object)this, "stepRateInMinutes", 1);
    private final ObjectProperty<ClockType> clockType = new SimpleObjectProperty((Object)this, "clockType", (Object)ClockType.TWENTY_FOUR_HOUR_CLOCK);
    private final BooleanProperty linkingFields = new SimpleBooleanProperty((Object)this, "linkingFields", true);
    private final BooleanProperty rollover = new SimpleBooleanProperty((Object)this, "rollOver", true);
    private final ObjectProperty<Consumer<TimePicker>> onShowPopup = new SimpleObjectProperty((Object)this, "onShowPopup");

    public TimePicker() {
        this.getStyleClass().addAll((Object[])new String[]{"time-picker", "text-input"});
        this.setFocusTraversable(false);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.separatorProperty().addListener(it -> {
            if (this.getSeparator() == null) {
                throw new IllegalArgumentException("separator can not be null");
            }
        });
        Label label = new Label(":");
        label.getStyleClass().add((Object)"separator");
        this.setSeparator((Node)label);
        this.setTime(LocalTime.now());
        this.earliestTimeProperty().addListener(it -> {
            LocalTime earliestTime = this.getEarliestTime();
            if (earliestTime.isAfter(this.getLatestTime())) {
                throw new IllegalArgumentException("earliest time can not be after the latest time, earliest = " + earliestTime + ", latest time = " + this.getLatestTime());
            }
            this.adjust();
        });
        this.latestTimeProperty().addListener(it -> {
            LocalTime latestTime = this.getLatestTime();
            if (latestTime.isBefore(this.getEarliestTime())) {
                throw new IllegalArgumentException("latest time can not be before the earliest time, latest = " + latestTime + ", earliest = " + this.getEarliestTime());
            }
            this.adjust();
        });
        this.stepRateInMinutesProperty().addListener(it -> {
            int stepRateInMinutes = this.getStepRateInMinutes();
            if (stepRateInMinutes < 1) {
                throw new IllegalArgumentException("step rate can not be smaller than 0 minutes but was " + stepRateInMinutes);
            }
            if (stepRateInMinutes > 60) {
                throw new IllegalArgumentException("step rate can not be larger than 60 minutes but was " + stepRateInMinutes);
            }
            this.adjust();
        });
        this.getStylesheets().add((Object)TimePicker.class.getResource("time-picker.css").toExternalForm());
        this.setOnKeyPressed(evt -> {
            if (evt.getCode().equals((Object)KeyCode.F4) || evt.getCode().equals((Object)KeyCode.ENTER)) {
                this.getOnShowPopup().accept(this);
            }
        });
        MapChangeListener propertiesListener = change -> {
            if (change.wasAdded()) {
                if (change.getKey().equals("TIME_PICKER_POPUP")) {
                    this.setShowing(!this.isShowing());
                    this.getProperties().remove((Object)"TIME_PICKER_POPUP");
                } else if (change.getKey().equals("ADJUST_TIME")) {
                    this.adjust();
                    this.getProperties().remove((Object)"ADJUST_TIME");
                } else if (change.getKey().equals("CLEAR_ADJUSTED_TIME")) {
                    this.adjusted.set(false);
                    this.getProperties().remove((Object)"CLEAR_ADJUSTED_TIME");
                } else if (change.getKey().equals("NEW_TIME")) {
                    this.adjustmentInProgress = true;
                    try {
                        this.setTime((LocalTime)change.getValueAdded());
                    }
                    finally {
                        this.adjustmentInProgress = false;
                    }
                }
            }
        };
        this.getProperties().addListener(propertiesListener);
        this.timeProperty().addListener(it -> {
            if (!this.adjustmentInProgress) {
                this.adjusted.set(false);
            }
        });
        this.setOnShowPopup(picker -> this.show());
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    private void setShowing(boolean showing) {
        this.showing.set(showing);
    }

    public final void show() {
        this.setShowing(true);
    }

    public final void hide() {
        this.setShowing(false);
    }

    public final boolean isAdjusted() {
        return this.adjusted.get();
    }

    public final ReadOnlyBooleanProperty adjustedProperty() {
        return this.adjusted.getReadOnlyProperty();
    }

    protected Skin<?> createDefaultSkin() {
        return new TimePickerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return TimePicker.class.getResource("time-picker.css").toExternalForm();
    }

    public final LocalTime getEarliestTime() {
        return (LocalTime)this.earliestTime.get();
    }

    public final ObjectProperty<LocalTime> earliestTimeProperty() {
        return this.earliestTime;
    }

    public final void setEarliestTime(LocalTime earliestTime) {
        this.earliestTime.set((Object)earliestTime);
    }

    public final LocalTime getLatestTime() {
        return (LocalTime)this.latestTime.get();
    }

    public final ObjectProperty<LocalTime> latestTimeProperty() {
        return this.latestTime;
    }

    public final void setLatestTime(LocalTime latestTime) {
        this.latestTime.set((Object)latestTime);
    }

    public final Node getSeparator() {
        return (Node)this.separator.get();
    }

    public final ObjectProperty<Node> separatorProperty() {
        return this.separator;
    }

    public final void setSeparator(Node separator) {
        this.separator.set((Object)separator);
    }

    public final boolean getShowPopupTriggerButton() {
        return this.showPopupTriggerButton.get();
    }

    public final BooleanProperty showPopupTriggerButtonProperty() {
        return this.showPopupTriggerButton;
    }

    public final void setShowPopupTriggerButton(boolean showPopupTriggerButton) {
        this.showPopupTriggerButton.set(showPopupTriggerButton);
    }

    public final void adjust() {
        this.adjustmentInProgress = true;
        try {
            boolean adjusted;
            boolean bl = adjusted = this.adjustViaTimeBounds() || this.adjustViaStepRate();
            if (adjusted) {
                this.adjusted.set(true);
            }
        }
        finally {
            this.adjustmentInProgress = false;
        }
    }

    private boolean adjustViaTimeBounds() {
        LocalTime time = this.getTime();
        if (time != null) {
            boolean adjusted;
            LocalTime earliestTime = this.getEarliestTime();
            LocalTime latestTime = this.getLatestTime();
            int hour = time.getHour();
            int minute = time.getMinute();
            LocalTime newTime = LocalTime.of(hour, minute);
            if (time.isBefore(earliestTime)) {
                if (hour < earliestTime.getHour()) {
                    newTime = newTime.withHour(earliestTime.getHour());
                }
                if (newTime.isBefore(earliestTime)) {
                    newTime = newTime.withMinute(earliestTime.getMinute());
                }
            } else if (time.isAfter(latestTime)) {
                if (hour > latestTime.getHour()) {
                    newTime = newTime.withHour(latestTime.getHour());
                }
                if (newTime.isAfter(latestTime)) {
                    newTime = newTime.withMinute(latestTime.getMinute());
                }
            }
            boolean bl = adjusted = newTime.getHour() != time.getHour() || newTime.getMinute() != time.getMinute();
            if (adjusted) {
                this.setTime(newTime);
            }
            return adjusted;
        }
        return false;
    }

    private boolean adjustViaStepRate() {
        LocalTime time = this.getTime();
        if (time != null) {
            int hour = time.getHour();
            int unadjustedMinutes = time.getMinute();
            int lowerAdjustment = unadjustedMinutes - time.getMinute() % this.getStepRateInMinutes();
            int higherAdjustment = lowerAdjustment + this.getStepRateInMinutes();
            LocalTime adjustedTime = LocalTime.of(hour, lowerAdjustment);
            if (Math.abs(lowerAdjustment - unadjustedMinutes) > Math.abs(higherAdjustment - unadjustedMinutes)) {
                if (higherAdjustment > 59) {
                    higherAdjustment = lowerAdjustment;
                }
                adjustedTime = LocalTime.of(hour, higherAdjustment);
            }
            if (adjustedTime.getHour() != time.getHour() || adjustedTime.getMinute() != time.getMinute()) {
                this.setTime(adjustedTime);
            }
            return time.getHour() != adjustedTime.getHour() || time.getMinute() != adjustedTime.getMinute();
        }
        return false;
    }

    public final LocalTime getTime() {
        return (LocalTime)this.time.get();
    }

    public final ObjectProperty<LocalTime> timeProperty() {
        return this.time;
    }

    public final void setTime(LocalTime time) {
        this.time.set((Object)time);
    }

    public final int getStepRateInMinutes() {
        return this.stepRateInMinutes.get();
    }

    public final IntegerProperty stepRateInMinutesProperty() {
        return this.stepRateInMinutes;
    }

    public final void setStepRateInMinutes(int stepRateInMinutes) {
        this.stepRateInMinutes.set(stepRateInMinutes);
    }

    public final ClockType getClockType() {
        return (ClockType)((Object)this.clockType.get());
    }

    public final ObjectProperty<ClockType> clockTypeProperty() {
        return this.clockType;
    }

    public final void setClockType(ClockType clockType) {
        this.clockType.set((Object)clockType);
    }

    public final boolean isLinkingFields() {
        return this.linkingFields.get();
    }

    public final BooleanProperty linkingFieldsProperty() {
        return this.linkingFields;
    }

    public final void setLinkingFields(boolean linkingFields) {
        this.linkingFields.set(linkingFields);
    }

    public final boolean isRollover() {
        return this.rollover.get();
    }

    public final BooleanProperty rolloverProperty() {
        return this.rollover;
    }

    public final void setRollover(boolean rollover) {
        this.rollover.set(rollover);
    }

    public final Consumer<TimePicker> getOnShowPopup() {
        return (Consumer)this.onShowPopup.get();
    }

    public final ObjectProperty<Consumer<TimePicker>> onShowPopupProperty() {
        return this.onShowPopup;
    }

    public final void setOnShowPopup(Consumer<TimePicker> onShowPopup) {
        this.onShowPopup.set(onShowPopup);
    }

    public static enum ClockType {
        TWENTY_FOUR_HOUR_CLOCK,
        TWELVE_HOUR_CLOCK;

    }
}

