/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.incubator.templatepane;

import com.dlsc.gemsfx.incubator.templatepane.TemplatePane;
import com.dlsc.gemsfx.incubator.templatepane.Tile;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.util.Duration;

public class TemplatePaneSkin
extends SkinBase<TemplatePane> {
    private Map<Tile, Rectangle2D> currentTileBounds;
    private double contentX;
    private double contentY;
    private double contentWidth;
    private double contentHeight;

    public TemplatePaneSkin(TemplatePane pane) {
        super((Control)pane);
        for (TemplatePane.Position pos : TemplatePane.Position.values()) {
            Tile tile = pane.getTile(pos);
            tile.visibleProperty().addListener(it -> Platform.runLater(() -> this.update(tile.getTransition())));
        }
    }

    private Tile getTile(TemplatePane.Position pos) {
        return ((TemplatePane)this.getSkinnable()).getTile(pos);
    }

    private void update(Tile.TileTransition transition) {
        Map<Tile, Rectangle2D> newTileBounds = this.computeBounds(this.contentX, this.contentY, this.contentWidth, this.contentHeight);
        Timeline timeline = new Timeline();
        newTileBounds.forEach((tile, bounds) -> this.update((Tile)tile, (Rectangle2D)bounds, timeline, transition));
        if (!timeline.getKeyFrames().isEmpty()) {
            timeline.setOnFinished(evt -> ((TemplatePane)this.getSkinnable()).requestLayout());
            timeline.play();
        }
    }

    private void update(Tile tile, Rectangle2D newBounds, Timeline timeline, Tile.TileTransition transition) {
        Rectangle2D currentBounds = this.currentTileBounds.get(tile);
        System.out.println("tile = " + tile.getPosition());
        System.out.println("   cur bounds = " + currentBounds);
        System.out.println("   new bounds = " + newBounds);
        if (!currentBounds.equals((Object)newBounds)) {
            switch (transition) {
                case APPEAR: {
                    KeyValue xValue = new KeyValue((WritableValue)tile.layoutXProperty(), (Object)newBounds.getMinX());
                    KeyValue yValue = new KeyValue((WritableValue)tile.layoutYProperty(), (Object)newBounds.getMinY());
                    KeyValue widthValue = new KeyValue((WritableValue)tile.widthProperty(), (Object)newBounds.getWidth());
                    KeyValue heightValue = new KeyValue((WritableValue)tile.heightProperty(), (Object)newBounds.getHeight());
                    timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{xValue, yValue, widthValue, heightValue}));
                    break;
                }
                case SHRINK: {
                    KeyValue xValue = new KeyValue((WritableValue)tile.layoutXProperty(), (Object)newBounds.getMinX());
                    KeyValue yValue = new KeyValue((WritableValue)tile.layoutYProperty(), (Object)newBounds.getMinY());
                    KeyValue widthValue = new KeyValue((WritableValue)tile.widthProperty(), (Object)newBounds.getWidth());
                    KeyValue heightValue = new KeyValue((WritableValue)tile.heightProperty(), (Object)newBounds.getHeight());
                    timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{xValue, yValue, widthValue, heightValue}));
                    break;
                }
            }
        }
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.contentX = contentX;
        this.contentY = contentY;
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
        System.out.println("creating new tile bounds");
        this.currentTileBounds = this.computeBounds(contentX, contentY, contentWidth, contentHeight);
        this.currentTileBounds.forEach((tile, bounds) -> tile.resize(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight()));
    }

    private Map<Tile, Rectangle2D> computeBounds(double contentX, double contentY, double contentWidth, double contentHeight) {
        HashMap<Tile, Rectangle2D> boundsMap = new HashMap<Tile, Rectangle2D>();
        double aboveHeaderHeight = this.layoutAboveHeader(boundsMap, contentX, contentY, contentWidth, contentHeight);
        double headerHeight = this.layoutHeader(boundsMap, contentX, contentY += aboveHeaderHeight, contentWidth, contentHeight -= aboveHeaderHeight);
        double belowHeaderHeight = this.layoutBelowHeader(boundsMap, contentX, contentY += headerHeight, contentWidth, contentHeight -= headerHeight);
        double belowFooterHeight = this.layoutBelowFooter(boundsMap, contentX, (contentY += belowHeaderHeight) + (contentHeight -= belowHeaderHeight), contentWidth, contentHeight);
        double footerHeight = this.layoutFooter(boundsMap, contentX, contentY + (contentHeight -= belowFooterHeight), contentWidth, contentHeight);
        double aboveFooterHeight = this.layoutAboveFooter(boundsMap, contentX, contentY + (contentHeight -= footerHeight), contentWidth, contentHeight);
        double leftWidth = this.layoutLeft(boundsMap, contentX, contentY, contentWidth, contentHeight -= aboveFooterHeight);
        double rightWidth = this.layoutRight(boundsMap, (contentX += leftWidth) + (contentWidth -= leftWidth), contentY, contentWidth, contentHeight);
        double aboveSidesHeight = this.layoutAboveSides(boundsMap, contentX, contentY, contentWidth -= rightWidth, contentHeight);
        double belowSidesHeight = this.layoutBelowSides(boundsMap, contentX, (contentY += aboveSidesHeight) + (contentHeight -= aboveSidesHeight), contentWidth, contentHeight);
        double contentLeftWidth = this.layoutContentLeft(boundsMap, contentX, contentY, contentWidth, contentHeight -= belowSidesHeight);
        double contentRightWidth = this.layoutContentRight(boundsMap, (contentX += contentLeftWidth) + (contentWidth -= contentLeftWidth), contentY, contentWidth, contentHeight);
        double aboveContentHeight = this.layoutAboveContent(boundsMap, contentX, contentY, contentWidth -= contentRightWidth, contentHeight);
        double belowContentHeight = this.layoutBelowContent(boundsMap, contentX, (contentY += aboveContentHeight) + (contentHeight -= aboveContentHeight), contentWidth, contentHeight);
        this.layoutContent(boundsMap, contentX, contentY, contentWidth, contentHeight -= belowContentHeight);
        return boundsMap;
    }

    private void layoutContent(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.CONTENT);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY, contentWidth, contentHeight));
    }

    private double layoutBelowContent(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.BELOW_CONTENT);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY - prefHeight, contentWidth, prefHeight));
        return prefHeight;
    }

    private double layoutAboveContent(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.ABOVE_CONTENT);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY, contentWidth, prefHeight));
        return prefHeight;
    }

    private double layoutContentRight(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.CONTENT_RIGHT);
        double prefWidth = tile.prefWidth(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX - prefWidth, contentY, prefWidth, contentHeight));
        return prefWidth;
    }

    private double layoutContentLeft(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.CONTENT_LEFT);
        double prefWidth = tile.prefWidth(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY, prefWidth, contentHeight));
        return prefWidth;
    }

    private double layoutBelowSides(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.BELOW_SIDES);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY - prefHeight, contentWidth, prefHeight));
        return prefHeight;
    }

    private double layoutAboveSides(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.ABOVE_SIDES);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY, contentWidth, prefHeight));
        return prefHeight;
    }

    private double layoutLeft(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.LEFT);
        double prefWidth = tile.prefWidth(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY, prefWidth, contentHeight));
        return prefWidth;
    }

    private double layoutRight(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.RIGHT);
        double prefWidth = tile.prefWidth(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX + -prefWidth, contentY, prefWidth, contentHeight));
        return prefWidth;
    }

    private double layoutAboveFooter(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.ABOVE_FOOTER);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY - prefHeight, contentWidth, prefHeight));
        return prefHeight;
    }

    private double layoutFooter(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile footerLeft = this.getTile(TemplatePane.Position.FOOTER_LEFT);
        Tile footerRight = this.getTile(TemplatePane.Position.FOOTER_RIGHT);
        Tile footer = this.getTile(TemplatePane.Position.FOOTER);
        double prefWidthFooterLeft = footerLeft.prefWidth(-1.0);
        double prefWidthFooterRight = footerRight.prefWidth(-1.0);
        double prefHeightFooterLeft = footerLeft.prefHeight(-1.0);
        double prefHeightFooterRight = footerRight.prefHeight(-1.0);
        double prefHeightFooter = footer.prefHeight(-1.0);
        double prefHeight = 0.0;
        if (prefHeightFooter > 0.0) {
            prefHeight = Math.max(prefHeightFooter, Math.max(prefHeightFooterLeft, prefHeightFooterRight));
        }
        boundsMap.put(footerLeft, new Rectangle2D(contentX, contentY - prefHeight, prefWidthFooterLeft, prefHeight));
        boundsMap.put(footerRight, new Rectangle2D(contentX + contentWidth - prefWidthFooterRight, contentY - prefHeight, prefWidthFooterRight, prefHeight));
        boundsMap.put(footer, new Rectangle2D(contentX + prefWidthFooterLeft, contentY - prefHeight, contentWidth - prefWidthFooterLeft - prefWidthFooterRight, prefHeight));
        return prefHeight;
    }

    private double layoutBelowFooter(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.BELOW_FOOTER);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY - prefHeight, contentWidth, prefHeight));
        return prefHeight;
    }

    private double layoutAboveHeader(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.ABOVE_HEADER);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY, contentWidth, prefHeight));
        return prefHeight;
    }

    private double layoutHeader(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile headerLeft = this.getTile(TemplatePane.Position.HEADER_LEFT);
        Tile headerRight = this.getTile(TemplatePane.Position.HEADER_RIGHT);
        Tile header = this.getTile(TemplatePane.Position.HEADER);
        double prefWidthHeaderLeft = headerLeft.prefWidth(-1.0);
        double prefWidthHeaderRight = headerRight.prefWidth(-1.0);
        double prefHeightHeaderLeft = headerLeft.prefHeight(-1.0);
        double prefHeightHeaderRight = headerRight.prefHeight(-1.0);
        double prefHeightHeader = header.prefHeight(-1.0);
        double prefHeight = 0.0;
        if (prefHeightHeader > 0.0) {
            prefHeight = Math.max(prefHeightHeader, Math.max(prefHeightHeaderLeft, prefHeightHeaderRight));
        }
        boundsMap.put(headerLeft, new Rectangle2D(contentX, contentY, prefWidthHeaderLeft, prefHeight));
        boundsMap.put(headerRight, new Rectangle2D(contentX + contentWidth - prefWidthHeaderRight, contentY, prefWidthHeaderRight, prefHeight));
        boundsMap.put(header, new Rectangle2D(contentX + prefWidthHeaderLeft, contentY, contentWidth - prefWidthHeaderLeft - prefWidthHeaderRight, prefHeight));
        System.out.println("bounds: " + boundsMap.get(header));
        return prefHeight;
    }

    private double layoutBelowHeader(Map<Tile, Rectangle2D> boundsMap, double contentX, double contentY, double contentWidth, double contentHeight) {
        Tile tile = this.getTile(TemplatePane.Position.BELOW_HEADER);
        double prefHeight = tile.prefHeight(contentWidth);
        boundsMap.put(tile, new Rectangle2D(contentX, contentY, contentWidth, prefHeight));
        return prefHeight;
    }
}

