/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.infocenter;

import com.dlsc.gemsfx.infocenter.InfoCenterEvent;
import com.dlsc.gemsfx.infocenter.InfoCenterView;
import com.dlsc.gemsfx.skins.InfoCenterPaneSkin;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import one.jpro.jproutils.treeshowing.TreeShowing;

public class InfoCenterPane
extends Control {
    private final InfoCenterView infoCenterView = new InfoCenterView();
    private final ReadOnlyBooleanWrapper insideInfoCenter = new ReadOnlyBooleanWrapper((Object)this, "insideInfoCenter");
    private final EventHandler<MouseEvent> mouseClickedHandler = evt -> {
        if (evt.getTarget() == this.getContent() && this.isAutoHide() && !this.isPinned()) {
            this.setShowInfoCenter(false);
        }
    };
    private final WeakEventHandler<MouseEvent> weakMouseClickedHandler = new WeakEventHandler(this.mouseClickedHandler);
    private final ObjectProperty<Duration> autoHideDuration = new SimpleObjectProperty((Object)this, "autoHideDuration", (Object)Duration.seconds((double)5.0));
    private final BooleanProperty pinned = new SimpleBooleanProperty((Object)this, "pinned", false);
    private final BooleanProperty autoHide = new SimpleBooleanProperty((Object)this, "autoHide", true);
    private ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private final ObjectProperty<Duration> slideInDuration = new SimpleObjectProperty((Object)this, "slideDuration", (Object)Duration.millis((double)200.0));
    private final BooleanProperty showInfoCenter = new SimpleBooleanProperty((Object)this, "showInfoCenter", false);

    public InfoCenterPane() {
        this(null);
    }

    public InfoCenterPane(Node content) {
        this.getStyleClass().add((Object)"notification-pane");
        this.infoCenterView.showAllGroupProperty().addListener(it -> this.requestLayout());
        this.contentProperty().addListener((it, oldContent, newContent) -> {
            if (oldContent != null) {
                oldContent.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.weakMouseClickedHandler);
            }
            if (newContent != null) {
                newContent.addEventFilter(MouseEvent.MOUSE_CLICKED, this.weakMouseClickedHandler);
            }
        });
        this.setContent(content);
        this.infoCenterView.addEventHandler(InfoCenterEvent.NOTIFICATION_ADDED, evt -> this.setShowInfoCenter(true));
        this.infoCenterView.addEventHandler(InfoCenterEvent.HIDE, evt -> {
            if (!this.isPinned()) {
                this.setShowInfoCenter(false);
            }
        });
        this.infoCenterView.getUnmodifiableNotifications().addListener(it -> {
            if (this.infoCenterView.getUnmodifiableNotifications().isEmpty() && !this.isPinned()) {
                this.setShowInfoCenter(false);
            }
        });
        this.infoCenterView.setOnMouseClicked(evt -> {
            if (!evt.isConsumed() && evt.isStillSincePress() && evt.getButton().equals((Object)MouseButton.PRIMARY) && evt.getSource() == this.infoCenterView) {
                if (!this.isPinned()) {
                    this.setShowInfoCenter(false);
                }
                evt.consume();
            }
        });
        this.pinned.addListener(it -> this.setShowInfoCenter(this.isPinned()));
        AnimationTimer timer = new AnimationTimer(){
            private long lastToggle;
            private boolean reset;
            {
                InfoCenterPane.this.showInfoCenterProperty().addListener(it -> {
                    if (InfoCenterPane.this.isShowInfoCenter()) {
                        this.reset();
                    }
                });
                InfoCenterPane.this.insideInfoCenter.addListener(it -> {
                    if (!InfoCenterPane.this.insideInfoCenter.get()) {
                        this.reset();
                    }
                });
                InfoCenterPane.this.infoCenterView.addEventHandler(InfoCenterEvent.ANY, evt -> this.reset());
            }

            private void reset() {
                this.reset = true;
            }

            public void handle(long now) {
                if (this.lastToggle == 0L || this.reset) {
                    this.lastToggle = now;
                    this.reset = false;
                } else {
                    long diff = now - this.lastToggle;
                    if ((double)diff >= InfoCenterPane.this.getAutoHideDuration().toMillis() * 1000000.0) {
                        if (!InfoCenterPane.this.isPinned() && !InfoCenterPane.this.insideInfoCenter.get() && InfoCenterPane.this.isAutoHide()) {
                            InfoCenterPane.this.setShowInfoCenter(false);
                        }
                        this.lastToggle = now;
                    }
                }
            }
        };
        TreeShowing.treeShowing((Node)this).addListener((p, o, n) -> {
            if (n.booleanValue()) {
                timer.start();
            } else {
                timer.stop();
            }
        });
        timer.start();
        this.infoCenterView.addEventHandler(MouseEvent.MOUSE_ENTERED, evt -> this.insideInfoCenter.set(true));
        this.infoCenterView.addEventHandler(MouseEvent.MOUSE_EXITED, evt -> this.insideInfoCenter.set(false));
    }

    protected Skin<?> createDefaultSkin() {
        return new InfoCenterPaneSkin(this);
    }

    public final Duration getAutoHideDuration() {
        return (Duration)this.autoHideDuration.get();
    }

    public final ObjectProperty<Duration> autoHideDurationProperty() {
        return this.autoHideDuration;
    }

    public final void setAutoHideDuration(Duration autoHideDuration) {
        this.autoHideDuration.set((Object)autoHideDuration);
    }

    public final boolean isPinned() {
        return this.pinned.get();
    }

    public final BooleanProperty pinnedProperty() {
        return this.pinned;
    }

    public final void setPinned(boolean pinned) {
        this.pinned.set(pinned);
    }

    public final boolean isAutoHide() {
        return this.autoHide.get();
    }

    public final BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public final void setAutoHide(boolean autoHide) {
        this.autoHide.set(autoHide);
    }

    public final InfoCenterView getInfoCenterView() {
        return this.infoCenterView;
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public final void setContent(Node content) {
        this.contentProperty().set((Object)content);
    }

    public final ObjectProperty<Duration> slideInDuration() {
        return this.slideInDuration;
    }

    public final Duration getSlideInDuration() {
        return (Duration)this.slideInDuration.get();
    }

    public final void setSlideInDuration(Duration duration) {
        this.slideInDuration.set((Object)duration);
    }

    public final boolean isShowInfoCenter() {
        return this.showInfoCenter.get();
    }

    public final BooleanProperty showInfoCenterProperty() {
        return this.showInfoCenter;
    }

    public final void setShowInfoCenter(boolean showInfoCenter) {
        this.showInfoCenter.set(showInfoCenter);
    }
}

